/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeFeaturesResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.kafka.compat.PulsarClientKafkaConfig;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarKafkaAdminClient
implements Admin {
    private static final Logger log = LoggerFactory.getLogger(PulsarKafkaAdminClient.class);
    private final Properties properties;
    private final PulsarAdmin admin;
    private final ConcurrentHashMap<String, Boolean> partitionedTopics = new ConcurrentHashMap();

    private PulsarKafkaAdminClient(AdminClientConfig config) {
        this.properties = new Properties();
        log.info("config originals: {}", (Object)config.originals());
        config.originals().forEach((k, v) -> {
            log.info("Setting k = {} v = {}", k, v);
            if (k != null && v != null) {
                this.properties.put(k, v);
            }
        });
        PulsarAdminBuilder builder = PulsarClientKafkaConfig.getAdminBuilder(this.properties);
        try {
            this.admin = builder.build();
        }
        catch (PulsarClientException e) {
            log.error("Could not create Pulsar Admin", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static PulsarKafkaAdminClient createInternal(AdminClientConfig config) {
        return new PulsarKafkaAdminClient(config);
    }

    public static Admin create(Properties props) {
        return PulsarKafkaAdminClient.createInternal(new AdminClientConfig((Map)props, true));
    }

    public static Admin create(Map<String, Object> conf) {
        return PulsarKafkaAdminClient.createInternal(new AdminClientConfig(conf, true));
    }

    private boolean isPartitionedTopic(String topic) {
        Boolean res = this.partitionedTopics.computeIfAbsent(topic, t -> {
            try {
                int numPartitions = this.admin.topics().getPartitionedTopicMetadata((String)t).partitions;
                return numPartitions > 0;
            }
            catch (PulsarAdminException e) {
                log.error("getPartitionedTopicMetadata failed", (Throwable)e);
                return null;
            }
        });
        if (res == null) {
            throw new RuntimeException("Could not get topic metadata");
        }
        return res;
    }

    public <K, V> Map<K, KafkaFutureImpl<V>> execute(Collection<K> param, BiConsumer<K, KafkaFutureImpl<V>> func) {
        HashMap<K, KafkaFutureImpl> futures = new HashMap<K, KafkaFutureImpl>();
        for (K value : param) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(value, future);
            func.accept(value, future);
        }
        return futures;
    }

    public <K, K2, V> Map<K, KafkaFutureImpl<V>> execute(Map<K, K2> param, BiConsumer<Map.Entry<K, K2>, KafkaFutureImpl<V>> func) {
        HashMap<K, KafkaFutureImpl> futures = new HashMap<K, KafkaFutureImpl>(param.size());
        for (Map.Entry<K, K2> value : param.entrySet()) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            futures.put(value.getKey(), future);
            func.accept(value, future);
        }
        return futures;
    }

    public void close(Duration duration) {
        this.admin.close();
    }

    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions listOffsetsOptions) {
        Map futures = this.execute(topicPartitionOffsets, (Map.Entry<K, K2> entry, KafkaFutureImpl<V> future) -> {
            TopicPartition topicPartition = (TopicPartition)entry.getKey();
            String topicName = this.isPartitionedTopic(topicPartition.topic()) ? topicPartition.topic() + "-partition-" + topicPartition.partition() : topicPartition.topic();
            this.admin.topics().getLastMessageIdAsync(topicName).whenComplete((msgId, ex) -> {
                if (ex == null) {
                    long offset = FunctionCommon.getSequenceId((MessageId)msgId);
                    future.complete((Object)new ListOffsetsResult.ListOffsetsResultInfo(offset, System.currentTimeMillis(), Optional.empty()));
                } else {
                    log.error("Admin failed to get lastMessageId for topic " + topicName, ex);
                    future.completeExceptionally(ex);
                }
            });
        });
        return new ListOffsetsResult(new HashMap(futures));
    }

    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> map, DeleteRecordsOptions deleteRecordsOptions) {
        Map futures = this.execute(map, (Map.Entry<K, K2> entry, KafkaFutureImpl<V> future) -> future.complete((Object)new DeletedRecords(((RecordsToDelete)entry.getValue()).beforeOffset())));
        return new DeleteRecordsResult(new HashMap(futures));
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> collection, CreateTopicsOptions createTopicsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DeleteTopicsResult deleteTopics(Collection<String> collection, DeleteTopicsOptions deleteTopicsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public ListTopicsResult listTopics(ListTopicsOptions listTopicsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeTopicsResult describeTopics(Collection<String> collection, DescribeTopicsOptions describeTopicsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeClusterResult describeCluster(DescribeClusterOptions describeClusterOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeAclsResult describeAcls(AclBindingFilter aclBindingFilter, DescribeAclsOptions describeAclsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public CreateAclsResult createAcls(Collection<AclBinding> collection, CreateAclsOptions createAclsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> collection, DeleteAclsOptions deleteAclsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> collection, DescribeConfigsOptions describeConfigsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> map, AlterConfigsOptions alterConfigsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> map, AlterConfigsOptions alterConfigsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> map, AlterReplicaLogDirsOptions alterReplicaLogDirsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeLogDirsResult describeLogDirs(Collection<Integer> collection, DescribeLogDirsOptions describeLogDirsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> collection, DescribeReplicaLogDirsOptions describeReplicaLogDirsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> map, CreatePartitionsOptions createPartitionsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions createDelegationTokenOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public RenewDelegationTokenResult renewDelegationToken(byte[] bytes, RenewDelegationTokenOptions renewDelegationTokenOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public ExpireDelegationTokenResult expireDelegationToken(byte[] bytes, ExpireDelegationTokenOptions expireDelegationTokenOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions describeDelegationTokenOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> collection, DescribeConsumerGroupsOptions describeConsumerGroupsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions listConsumerGroupsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String s, ListConsumerGroupOffsetsOptions listConsumerGroupOffsetsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> collection, DeleteConsumerGroupsOptions deleteConsumerGroupsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String s, Set<TopicPartition> set, DeleteConsumerGroupOffsetsOptions deleteConsumerGroupOffsetsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> set, ElectLeadersOptions electLeadersOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> map, AlterPartitionReassignmentsOptions alterPartitionReassignmentsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> optional, ListPartitionReassignmentsOptions listPartitionReassignmentsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String s, RemoveMembersFromConsumerGroupOptions removeMembersFromConsumerGroupOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String s, Map<TopicPartition, OffsetAndMetadata> map, AlterConsumerGroupOffsetsOptions alterConsumerGroupOffsetsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter clientQuotaFilter, DescribeClientQuotasOptions describeClientQuotasOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> collection, AlterClientQuotasOptions alterClientQuotasOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeUserScramCredentialsResult describeUserScramCredentials(List<String> list, DescribeUserScramCredentialsOptions describeUserScramCredentialsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(List<UserScramCredentialAlteration> list, AlterUserScramCredentialsOptions alterUserScramCredentialsOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public DescribeFeaturesResult describeFeatures(DescribeFeaturesOptions describeFeaturesOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public UpdateFeaturesResult updateFeatures(Map<String, FeatureUpdate> map, UpdateFeaturesOptions updateFeaturesOptions) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public Map<MetricName, ? extends Metric> metrics() {
        throw new UnsupportedOperationException("Operation is not supported");
    }
}

