/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.kafka.compat;

import com.google.common.base.Preconditions;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;

public class PulsarKafkaSchema<T>
implements Schema<T> {
    private final Serializer<T> kafkaSerializer;
    private final Deserializer<T> kafkaDeserializer;
    private String topic;

    public PulsarKafkaSchema(Serializer<T> serializer) {
        this(serializer, null);
    }

    public PulsarKafkaSchema(Deserializer<T> deserializer) {
        this(null, deserializer);
    }

    public PulsarKafkaSchema(Serializer<T> serializer, Deserializer<T> deserializer) {
        this.kafkaSerializer = serializer;
        this.kafkaDeserializer = deserializer;
    }

    public Serializer<T> getKafkaSerializer() {
        return this.kafkaSerializer;
    }

    public Deserializer<T> getKafkaDeserializer() {
        return this.kafkaDeserializer;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public byte[] encode(T message) {
        Preconditions.checkArgument((this.kafkaSerializer != null ? 1 : 0) != 0, (Object)"Kafka serializer is not initialized yet");
        return this.kafkaSerializer.serialize(this.topic, message);
    }

    public T decode(byte[] message) {
        Preconditions.checkArgument((this.kafkaDeserializer != null ? 1 : 0) != 0, (Object)"Kafka deserializer is not initialized yet");
        return (T)this.kafkaDeserializer.deserialize(this.topic, message);
    }

    public SchemaInfo getSchemaInfo() {
        return Schema.BYTES.getSchemaInfo();
    }

    public Schema<T> clone() {
        return this;
    }
}

