/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AbstractBatchMessageContainer;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMessageContainerImpl
extends AbstractBatchMessageContainer {
    private PulsarApi.MessageMetadata.Builder messageMetadata = PulsarApi.MessageMetadata.newBuilder();
    private long lowestSequenceId = -1L;
    private long highestSequenceId = -1L;
    private ByteBuf batchedMessageMetadataAndPayload;
    private List<MessageImpl<?>> messages = Lists.newArrayList();
    protected SendCallback previousCallback = null;
    protected SendCallback firstCallback;
    private static final Logger log = LoggerFactory.getLogger(BatchMessageContainerImpl.class);

    BatchMessageContainerImpl() {
    }

    @Override
    public boolean add(MessageImpl<?> msg, SendCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] add message to batch, num messages in batch so far {}", new Object[]{this.topicName, this.producerName, this.numMessagesInBatch});
        }
        if (++this.numMessagesInBatch == 1) {
            this.messageMetadata.setSequenceId(msg.getSequenceId());
            this.lowestSequenceId = Commands.initBatchMessageMetadata((PulsarApi.MessageMetadata.Builder)this.messageMetadata, (PulsarApi.MessageMetadata.Builder)msg.getMessageBuilder());
            this.firstCallback = callback;
            this.batchedMessageMetadataAndPayload = PulsarByteBufAllocator.DEFAULT.buffer(Math.min(this.maxBatchSize, ClientCnx.getMaxMessageSize()));
            if (msg.getMessageBuilder().hasTxnidMostBits() && this.currentTxnidMostBits == -1L) {
                this.currentTxnidMostBits = msg.getMessageBuilder().getTxnidMostBits();
            }
            if (msg.getMessageBuilder().hasTxnidLeastBits() && this.currentTxnidLeastBits == -1L) {
                this.currentTxnidLeastBits = msg.getMessageBuilder().getTxnidLeastBits();
            }
        }
        if (this.previousCallback != null) {
            this.previousCallback.addCallback(msg, callback);
        }
        this.previousCallback = callback;
        this.currentBatchSizeBytes += (long)msg.getDataBuffer().readableBytes();
        this.messages.add(msg);
        if (this.lowestSequenceId == -1L) {
            this.lowestSequenceId = msg.getSequenceId();
            this.messageMetadata.setSequenceId(this.lowestSequenceId);
        }
        this.highestSequenceId = msg.getSequenceId();
        ProducerImpl.LAST_SEQ_ID_PUSHED_UPDATER.getAndUpdate(this.producer, prev -> Math.max(prev, msg.getSequenceId()));
        return this.isBatchFull();
    }

    private ByteBuf getCompressedBatchMetadataAndPayload() {
        int batchWriteIndex = this.batchedMessageMetadataAndPayload.writerIndex();
        int batchReadIndex = this.batchedMessageMetadataAndPayload.readerIndex();
        int n = this.messages.size();
        for (int i = 0; i < n; ++i) {
            MessageImpl<?> msg = this.messages.get(i);
            PulsarApi.MessageMetadata.Builder msgBuilder = msg.getMessageBuilder();
            msg.getDataBuffer().markReaderIndex();
            try {
                this.batchedMessageMetadataAndPayload = Commands.serializeSingleMessageInBatchWithPayload((PulsarApi.MessageMetadata.Builder)msgBuilder, (ByteBuf)msg.getDataBuffer(), (ByteBuf)this.batchedMessageMetadataAndPayload);
                continue;
            }
            catch (Throwable th) {
                for (int j = 0; j <= i; ++j) {
                    MessageImpl<?> previousMsg = this.messages.get(j);
                    previousMsg.getDataBuffer().resetReaderIndex();
                }
                this.batchedMessageMetadataAndPayload.writerIndex(batchWriteIndex);
                this.batchedMessageMetadataAndPayload.readerIndex(batchReadIndex);
                throw new RuntimeException(th);
            }
        }
        for (MessageImpl<?> msg : this.messages) {
            msg.getMessageBuilder().recycle();
        }
        int uncompressedSize = this.batchedMessageMetadataAndPayload.readableBytes();
        ByteBuf compressedPayload = this.compressor.encode(this.batchedMessageMetadataAndPayload);
        this.batchedMessageMetadataAndPayload.release();
        if (this.compressionType != PulsarApi.CompressionType.NONE) {
            this.messageMetadata.setCompression(this.compressionType);
            this.messageMetadata.setUncompressedSize(uncompressedSize);
        }
        this.maxBatchSize = Math.max(this.maxBatchSize, uncompressedSize);
        return compressedPayload;
    }

    public void clear() {
        this.messages = Lists.newArrayList();
        this.firstCallback = null;
        this.previousCallback = null;
        this.messageMetadata.clear();
        this.numMessagesInBatch = 0;
        this.currentBatchSizeBytes = 0L;
        this.lowestSequenceId = -1L;
        this.highestSequenceId = -1L;
        this.batchedMessageMetadataAndPayload = null;
        this.currentTxnidMostBits = -1L;
        this.currentTxnidLeastBits = -1L;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public void discard(Exception ex) {
        try {
            if (this.firstCallback != null) {
                this.firstCallback.sendComplete(ex);
            }
        }
        catch (Throwable t) {
            log.warn("[{}] [{}] Got exception while completing the callback for msg {}:", new Object[]{this.topicName, this.producerName, this.lowestSequenceId, t});
        }
        this.clear();
    }

    public boolean isMultiBatches() {
        return false;
    }

    @Override
    public ProducerImpl.OpSendMsg createOpSendMsg() throws IOException {
        ByteBuf encryptedPayload = this.producer.encryptMessage(this.messageMetadata, this.getCompressedBatchMetadataAndPayload());
        if (encryptedPayload.readableBytes() > ClientCnx.getMaxMessageSize()) {
            this.producer.getSemaphore().release(this.messages.size());
            this.discard((Exception)new PulsarClientException.InvalidMessageException("Message size is bigger than " + ClientCnx.getMaxMessageSize() + " bytes"));
            return null;
        }
        this.messageMetadata.setNumMessagesInBatch(this.numMessagesInBatch);
        this.messageMetadata.setHighestSequenceId(this.highestSequenceId);
        if (this.currentTxnidMostBits != -1L) {
            this.messageMetadata.setTxnidMostBits(this.currentTxnidMostBits);
        }
        if (this.currentTxnidLeastBits != -1L) {
            this.messageMetadata.setTxnidLeastBits(this.currentTxnidLeastBits);
        }
        ByteBufPair cmd = this.producer.sendMessage(this.producer.producerId, this.messageMetadata.getSequenceId(), this.messageMetadata.getHighestSequenceId(), this.numMessagesInBatch, this.messageMetadata.build(), encryptedPayload);
        ProducerImpl.OpSendMsg op = ProducerImpl.OpSendMsg.create(this.messages, cmd, this.messageMetadata.getSequenceId(), this.messageMetadata.getHighestSequenceId(), this.firstCallback);
        op.setNumMessagesInBatch(this.numMessagesInBatch);
        op.setBatchSizeByte(this.currentBatchSizeBytes);
        this.lowestSequenceId = -1L;
        return op;
    }

    @Override
    public boolean hasSameSchema(MessageImpl<?> msg) {
        if (this.numMessagesInBatch == 0) {
            return true;
        }
        if (!this.messageMetadata.hasSchemaVersion()) {
            return msg.getSchemaVersion() == null;
        }
        return Arrays.equals(msg.getSchemaVersion(), this.messageMetadata.getSchemaVersion().toByteArray());
    }
}

