/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerBase;
import org.apache.pulsar.client.impl.schema.KeyValueSchema;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.util.TypeCheckUtil;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shaded.com.google.protobuf.v241.ByteString;

public class TypedMessageBuilderImpl<T>
implements TypedMessageBuilder<T> {
    private static final long serialVersionUID = 0L;
    private static final ByteBuffer EMPTY_CONTENT = ByteBuffer.allocate(0);
    private final ProducerBase<?> producer;
    private final PulsarApi.MessageMetadata.Builder msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
    private final Schema<T> schema;
    private ByteBuffer content;
    private final TransactionImpl txn;

    public TypedMessageBuilderImpl(ProducerBase<?> producer, Schema<T> schema) {
        this(producer, schema, null);
    }

    public TypedMessageBuilderImpl(ProducerBase<?> producer, Schema<T> schema, TransactionImpl txn) {
        this.producer = producer;
        this.schema = schema;
        this.content = EMPTY_CONTENT;
        this.txn = txn;
    }

    private long beforeSend() {
        if (this.txn == null) {
            return -1L;
        }
        this.msgMetadataBuilder.setTxnidLeastBits(this.txn.getTxnIdLeastBits());
        this.msgMetadataBuilder.setTxnidMostBits(this.txn.getTxnIdMostBits());
        return -1L;
    }

    public MessageId send() throws PulsarClientException {
        try {
            CompletableFuture<MessageId> sendFuture = this.sendAsync();
            if (!sendFuture.isDone()) {
                this.producer.triggerFlush();
            }
            return sendFuture.get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<MessageId> sendAsync() {
        CompletableFuture<MessageId> sendFuture;
        Message<T> message = this.getMessage();
        if (this.txn != null) {
            sendFuture = this.producer.internalSendWithTxnAsync(message, this.txn);
            this.txn.registerSendOp(sendFuture);
        } else {
            sendFuture = this.producer.internalSendAsync(message);
        }
        return sendFuture;
    }

    public TypedMessageBuilder<T> key(String key) {
        if (this.schema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
            KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
            Preconditions.checkArgument((kvSchema.getKeyValueEncodingType() != KeyValueEncodingType.SEPARATED ? 1 : 0) != 0, (Object)"This method is not allowed to set keys when in encoding type is SEPARATED");
            if (key == null) {
                this.msgMetadataBuilder.setNullPartitionKey(true);
                return this;
            }
        }
        this.msgMetadataBuilder.setPartitionKey(key);
        this.msgMetadataBuilder.setPartitionKeyB64Encoded(false);
        return this;
    }

    public TypedMessageBuilder<T> keyBytes(byte[] key) {
        if (this.schema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
            KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
            Preconditions.checkArgument((kvSchema.getKeyValueEncodingType() != KeyValueEncodingType.SEPARATED ? 1 : 0) != 0, (Object)"This method is not allowed to set keys when in encoding type is SEPARATED");
            if (key == null) {
                this.msgMetadataBuilder.setNullPartitionKey(true);
                return this;
            }
        }
        this.msgMetadataBuilder.setPartitionKey(Base64.getEncoder().encodeToString(key));
        this.msgMetadataBuilder.setPartitionKeyB64Encoded(true);
        return this;
    }

    public TypedMessageBuilder<T> orderingKey(byte[] orderingKey) {
        this.msgMetadataBuilder.setOrderingKey(ByteString.copyFrom((byte[])orderingKey));
        return this;
    }

    public TypedMessageBuilder<T> value(T value) {
        if (value == null) {
            this.msgMetadataBuilder.setNullValue(true);
            return this;
        }
        if (this.schema.getSchemaInfo() != null && this.schema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
            KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
            KeyValue kv = (KeyValue)value;
            if (kvSchema.getKeyValueEncodingType() == KeyValueEncodingType.SEPARATED) {
                if (kv.getKey() != null) {
                    this.msgMetadataBuilder.setPartitionKey(Base64.getEncoder().encodeToString(kvSchema.getKeySchema().encode(kv.getKey())));
                    this.msgMetadataBuilder.setPartitionKeyB64Encoded(true);
                } else {
                    this.msgMetadataBuilder.setNullPartitionKey(true);
                }
                if (kv.getValue() != null) {
                    this.content = ByteBuffer.wrap(kvSchema.getValueSchema().encode(kv.getValue()));
                } else {
                    this.msgMetadataBuilder.setNullValue(true);
                }
                return this;
            }
        }
        this.content = ByteBuffer.wrap(this.schema.encode(value));
        return this;
    }

    public TypedMessageBuilder<T> property(String name, String value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Need Non-Null name");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)("Need Non-Null value for name: " + name));
        this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(name).setValue(value).build());
        return this;
    }

    public TypedMessageBuilder<T> properties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument((entry.getKey() != null ? 1 : 0) != 0, (Object)"Need Non-Null key");
            Preconditions.checkArgument((entry.getValue() != null ? 1 : 0) != 0, (Object)("Need Non-Null value for key: " + entry.getKey()));
            this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return this;
    }

    public TypedMessageBuilder<T> eventTime(long timestamp) {
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (String)"Invalid timestamp : '%s'", (long)timestamp);
        this.msgMetadataBuilder.setEventTime(timestamp);
        return this;
    }

    public TypedMessageBuilder<T> sequenceId(long sequenceId) {
        Preconditions.checkArgument((sequenceId >= 0L ? 1 : 0) != 0);
        this.msgMetadataBuilder.setSequenceId(sequenceId);
        return this;
    }

    public TypedMessageBuilder<T> replicationClusters(List<String> clusters) {
        Preconditions.checkNotNull(clusters);
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addAllReplicateTo(clusters);
        return this;
    }

    public TypedMessageBuilder<T> disableReplication() {
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addReplicateTo("__local__");
        return this;
    }

    public TypedMessageBuilder<T> deliverAfter(long delay, TimeUnit unit) {
        return this.deliverAt(System.currentTimeMillis() + unit.toMillis(delay));
    }

    public TypedMessageBuilder<T> deliverAt(long timestamp) {
        this.msgMetadataBuilder.setDeliverAtTime(timestamp);
        return this;
    }

    public TypedMessageBuilder<T> loadConf(Map<String, Object> config) {
        config.forEach((key, value) -> {
            switch (key) {
                case "key": {
                    this.key(TypeCheckUtil.checkType(value, String.class));
                    break;
                }
                case "properties": {
                    this.properties(TypeCheckUtil.checkType(value, Map.class));
                    break;
                }
                case "eventTime": {
                    this.eventTime(TypeCheckUtil.checkType(value, Long.class));
                    break;
                }
                case "sequenceId": {
                    this.sequenceId(TypeCheckUtil.checkType(value, Long.class));
                    break;
                }
                case "replicationClusters": {
                    this.replicationClusters(TypeCheckUtil.checkType(value, List.class));
                    break;
                }
                case "disableReplication": {
                    boolean disableReplication = TypeCheckUtil.checkType(value, Boolean.class);
                    if (!disableReplication) break;
                    this.disableReplication();
                    break;
                }
                case "deliverAfterSeconds": {
                    this.deliverAfter(TypeCheckUtil.checkType(value, Long.class), TimeUnit.SECONDS);
                    break;
                }
                case "deliverAt": {
                    this.deliverAt(TypeCheckUtil.checkType(value, Long.class));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid message config key '" + key + "'");
                }
            }
        });
        return this;
    }

    public PulsarApi.MessageMetadata.Builder getMetadataBuilder() {
        return this.msgMetadataBuilder;
    }

    public Message<T> getMessage() {
        this.beforeSend();
        return MessageImpl.create(this.msgMetadataBuilder, this.content, this.schema);
    }

    public long getPublishTime() {
        return this.msgMetadataBuilder.getPublishTime();
    }

    public boolean hasKey() {
        return this.msgMetadataBuilder.hasPartitionKey();
    }

    public String getKey() {
        return this.msgMetadataBuilder.getPartitionKey();
    }

    public ByteBuffer getContent() {
        return this.content;
    }
}

