/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AbstractStructSchema;
import org.apache.pulsar.client.impl.schema.ProtobufNativeSchemaUtils;
import org.apache.pulsar.client.impl.schema.reader.ProtobufNativeReader;
import org.apache.pulsar.client.impl.schema.writer.ProtobufNativeWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class ProtobufNativeSchema<T extends GeneratedMessageV3>
extends AbstractStructSchema<T> {
    public static final String PARSING_INFO_PROPERTY = "__PARSING_INFO__";

    private static <T> Descriptors.Descriptor createProtobufNativeSchema(Class<T> pojo) {
        try {
            Method method = pojo.getMethod("getDescriptor", new Class[0]);
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)method.invoke(null, new Object[0]);
            return descriptor;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private ProtobufNativeSchema(SchemaInfo schemaInfo, T protoMessageInstance) {
        super(schemaInfo);
        this.setReader(new ProtobufNativeReader<T>(protoMessageInstance));
        this.setWriter(new ProtobufNativeWriter());
        HashMap<String, String> allProperties = new HashMap<String, String>();
        allProperties.putAll(schemaInfo.getProperties());
        allProperties.put(PARSING_INFO_PROPERTY, this.getParsingInfo(protoMessageInstance));
        schemaInfo.setProperties(allProperties);
    }

    private String getParsingInfo(T protoMessageInstance) {
        final LinkedList protoBufParsingInfos = new LinkedList();
        protoMessageInstance.getDescriptorForType().getFields().forEach(new Consumer<Descriptors.FieldDescriptor>(){

            @Override
            public void accept(Descriptors.FieldDescriptor fieldDescriptor) {
                protoBufParsingInfos.add(new ProtoBufParsingInfo(fieldDescriptor.getNumber(), fieldDescriptor.getName(), fieldDescriptor.getType().name(), fieldDescriptor.toProto().getLabel().name(), null));
            }
        });
        try {
            return new ObjectMapper().writeValueAsString(protoBufParsingInfos);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Descriptors.Descriptor getProtobufNativeSchema() {
        return ProtobufNativeSchemaUtils.deserialize(this.schemaInfo.getSchema());
    }

    public static <T extends GeneratedMessageV3> ProtobufNativeSchema<T> of(Class<T> pojo) {
        return ProtobufNativeSchema.of(pojo, new HashMap<String, String>());
    }

    public static <T> ProtobufNativeSchema ofGenericClass(Class<T> pojo, Map<String, String> properties) {
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build();
        return ProtobufNativeSchema.of(schemaDefinition);
    }

    public static <T> ProtobufNativeSchema of(SchemaDefinition<T> schemaDefinition) {
        Class pojo = schemaDefinition.getPojo();
        if (!GeneratedMessageV3.class.isAssignableFrom(pojo)) {
            throw new IllegalArgumentException(GeneratedMessageV3.class.getName() + " is not assignable from " + pojo.getName());
        }
        Descriptors.Descriptor descriptor = ProtobufNativeSchema.createProtobufNativeSchema(schemaDefinition.getPojo());
        SchemaInfo schemaInfo = SchemaInfo.builder().schema(ProtobufNativeSchemaUtils.serialize(descriptor)).type(SchemaType.PROTOBUF_NATIVE).name("").properties(schemaDefinition.getProperties()).build();
        try {
            return new ProtobufNativeSchema<GeneratedMessageV3>(schemaInfo, (GeneratedMessageV3)pojo.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends GeneratedMessageV3> ProtobufNativeSchema<T> of(Class pojo, Map<String, String> properties) {
        return ProtobufNativeSchema.ofGenericClass(pojo, properties);
    }

    public static class ProtoBufParsingInfo {
        private final int number;
        private final String name;
        private final String type;
        private final String label;
        private final Map<String, Object> definition;

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        public Map<String, Object> getDefinition() {
            return this.definition;
        }

        public ProtoBufParsingInfo(int number, String name, String type, String label, Map<String, Object> definition) {
            this.number = number;
            this.name = name;
            this.type = type;
            this.label = label;
            this.definition = definition;
        }
    }
}

