/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.metrics;

import com.google.common.collect.Lists;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.common.naming.TopicName;

public final class MetricsUtil {
    private static final List<AttributeKey<String>> DEFAULT_AGGREGATION_LABELS = Lists.newArrayList((Object[])new AttributeKey[]{AttributeKey.stringKey((String)"pulsar.tenant"), AttributeKey.stringKey((String)"pulsar.namespace")});

    static List<AttributeKey<?>> getDefaultAggregationLabels(Attributes attrs) {
        ArrayList res = new ArrayList();
        res.addAll(DEFAULT_AGGREGATION_LABELS);
        res.addAll(attrs.asMap().keySet());
        return res;
    }

    static Attributes getTopicAttributes(String topic, Attributes baseAttributes) {
        TopicName tn = TopicName.get((String)topic);
        AttributesBuilder ab = baseAttributes.toBuilder();
        if (tn.isPartitioned()) {
            ab.put("pulsar.partition", (long)tn.getPartitionIndex());
        }
        ab.put("pulsar.topic", tn.getPartitionedTopicName());
        ab.put("pulsar.namespace", tn.getNamespace());
        ab.put("pulsar.tenant", tn.getTenant());
        return ab.build();
    }

    private MetricsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

