/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.OpenTelemetry;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.client.util.Secret;
import org.apache.pulsar.common.util.DefaultPulsarSslFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(name="serviceUrl", required=true, value="Pulsar cluster HTTP URL to connect to a broker.")
    private String serviceUrl;
    @ApiModelProperty(name="serviceUrlProvider", value="The implementation class of ServiceUrlProvider used to generate ServiceUrl.")
    @JsonIgnore
    private transient ServiceUrlProvider serviceUrlProvider;
    @ApiModelProperty(name="authentication", value="Authentication settings of the client.")
    @JsonIgnore
    private Authentication authentication;
    @ApiModelProperty(name="authPluginClassName", value="Class name of authentication plugin of the client.")
    private String authPluginClassName;
    @ApiModelProperty(name="authParams", value="Authentication parameter of the client.")
    @Secret
    private String authParams;
    @ApiModelProperty(name="authParamMap", value="Authentication map of the client.")
    @Secret
    private Map<String, String> authParamMap;
    @ApiModelProperty(name="originalPrincipal", value="Original principal for proxy authentication scenarios.")
    private String originalPrincipal;
    @ApiModelProperty(name="operationTimeoutMs", value="Client operation timeout (in milliseconds).")
    private long operationTimeoutMs = 30000L;
    @ApiModelProperty(name="lookupTimeoutMs", value="Client lookup timeout (in milliseconds).")
    private long lookupTimeoutMs = -1L;
    @ApiModelProperty(name="statsIntervalSeconds", value="Interval to print client stats (in seconds).")
    private long statsIntervalSeconds = 60L;
    @ApiModelProperty(name="numIoThreads", value="Number of IO threads.")
    private int numIoThreads = Runtime.getRuntime().availableProcessors();
    @ApiModelProperty(name="numListenerThreads", value="Number of consumer listener threads.")
    private int numListenerThreads = Runtime.getRuntime().availableProcessors();
    @ApiModelProperty(name="connectionsPerBroker", value="Number of connections established between the client and each Broker. A value of 0 means to disable connection pooling.")
    private int connectionsPerBroker = 1;
    @ApiModelProperty(name="connectionMaxIdleSeconds", value="Release the connection if it is not used for more than [connectionMaxIdleSeconds] seconds. If  [connectionMaxIdleSeconds] < 0, disabled the feature that auto release the idle connections")
    private int connectionMaxIdleSeconds = 60;
    @ApiModelProperty(name="useTcpNoDelay", value="Whether to use TCP NoDelay option.")
    private boolean useTcpNoDelay = true;
    @ApiModelProperty(name="useTls", value="Whether to use TLS.")
    private boolean useTls = false;
    @ApiModelProperty(name="tlsKeyFilePath", value="Path to the TLS key file.")
    private String tlsKeyFilePath = null;
    @ApiModelProperty(name="tlsCertificateFilePath", value="Path to the TLS certificate file.")
    private String tlsCertificateFilePath = null;
    @ApiModelProperty(name="tlsTrustCertsFilePath", value="Path to the trusted TLS certificate file.")
    private String tlsTrustCertsFilePath = null;
    @ApiModelProperty(name="tlsAllowInsecureConnection", value="Whether the client accepts untrusted TLS certificates from the broker.")
    private boolean tlsAllowInsecureConnection = false;
    @ApiModelProperty(name="tlsHostnameVerificationEnable", value="Whether the hostname is validated when the client creates a TLS connection with brokers.")
    private boolean tlsHostnameVerificationEnable = false;
    @ApiModelProperty(name="sslFactoryPlugin", value="SSL Factory Plugin class to provide SSLEngine and SSLContext objects. The default  class used is DefaultPulsarSslFactory.")
    private String sslFactoryPlugin = DefaultPulsarSslFactory.class.getName();
    @ApiModelProperty(name="sslFactoryPluginParams", value="SSL Factory plugin configuration parameters.")
    private String sslFactoryPluginParams = "";
    @ApiModelProperty(name="concurrentLookupRequest", value="The number of concurrent lookup requests that can be sent on each broker connection. Setting a maximum prevents overloading a broker.")
    private int concurrentLookupRequest = 5000;
    @ApiModelProperty(name="maxLookupRequest", value="Maximum number of lookup requests allowed on each broker connection to prevent overloading a broker.")
    private int maxLookupRequest = 50000;
    @ApiModelProperty(name="maxLookupRedirects", value="Maximum times of redirected lookup requests.")
    private int maxLookupRedirects = 20;
    @ApiModelProperty(name="maxNumberOfRejectedRequestPerConnection", value="Maximum number of rejected requests of a broker in a certain time frame (60 seconds) after the current connection is closed and the client creating a new connection to connect to a different broker.")
    private int maxNumberOfRejectedRequestPerConnection = 50;
    @ApiModelProperty(name="keepAliveIntervalSeconds", value="Seconds of keeping alive interval for each client broker connection.")
    private int keepAliveIntervalSeconds = 30;
    @ApiModelProperty(name="connectionTimeoutMs", value="Duration of waiting for a connection to a broker to be established.If the duration passes without a response from a broker, the connection attempt is dropped.")
    private int connectionTimeoutMs = 10000;
    @ApiModelProperty(name="requestTimeoutMs", value="Maximum duration for completing a request.")
    private int requestTimeoutMs = 60000;
    @ApiModelProperty(name="readTimeoutMs", value="Maximum read time of a request.")
    private int readTimeoutMs = 60000;
    @ApiModelProperty(name="autoCertRefreshSeconds", value="Seconds of auto refreshing certificate.")
    private int autoCertRefreshSeconds = 300;
    @ApiModelProperty(name="initialBackoffIntervalNanos", value="Initial backoff interval (in nanosecond).")
    private long initialBackoffIntervalNanos = TimeUnit.MILLISECONDS.toNanos(100L);
    @ApiModelProperty(name="maxBackoffIntervalNanos", value="Max backoff interval (in nanosecond).")
    private long maxBackoffIntervalNanos = TimeUnit.SECONDS.toNanos(60L);
    @ApiModelProperty(name="enableBusyWait", value="Whether to enable BusyWait for EpollEventLoopGroup.")
    private boolean enableBusyWait = false;
    @ApiModelProperty(name="listenerName", value="Listener name for lookup. Clients can use listenerName to choose one of the listeners as the service URL to create a connection to the broker as long as the network is accessible.\"advertisedListeners\" must enabled in broker side.")
    private String listenerName;
    @ApiModelProperty(name="useKeyStoreTls", value="Set TLS using KeyStore way.")
    private boolean useKeyStoreTls = false;
    @ApiModelProperty(name="sslProvider", value="The TLS provider used by an internal client to authenticate with other Pulsar brokers.")
    private String sslProvider = null;
    @ApiModelProperty(name="tlsKeyStoreType", value="TLS KeyStore type configuration.")
    private String tlsKeyStoreType = "JKS";
    @ApiModelProperty(name="tlsKeyStorePath", value="Path of TLS KeyStore.")
    private String tlsKeyStorePath = null;
    @ApiModelProperty(name="tlsKeyStorePassword", value="Password of TLS KeyStore.")
    @Secret
    private String tlsKeyStorePassword = null;
    @ApiModelProperty(name="tlsTrustStoreType", value="TLS TrustStore type configuration. You need to set this configuration when client authentication is required.")
    private String tlsTrustStoreType = "JKS";
    @ApiModelProperty(name="tlsTrustStorePath", value="Path of TLS TrustStore.")
    private String tlsTrustStorePath = null;
    @ApiModelProperty(name="tlsTrustStorePassword", value="Password of TLS TrustStore.")
    @Secret
    private String tlsTrustStorePassword = null;
    @ApiModelProperty(name="tlsCiphers", value="Set of TLS Ciphers.")
    private Set<String> tlsCiphers = new TreeSet<String>();
    @ApiModelProperty(name="tlsProtocols", value="Protocols of TLS.")
    private Set<String> tlsProtocols = new TreeSet<String>();
    @ApiModelProperty(name="memoryLimitBytes", value="Limit of client memory usage (in byte). The 64M default can guarantee a high producer throughput.")
    private long memoryLimitBytes = 0x4000000L;
    @ApiModelProperty(name="proxyServiceUrl", value="URL of proxy service. proxyServiceUrl and proxyProtocol must be mutually inclusive.")
    private String proxyServiceUrl;
    @ApiModelProperty(name="proxyProtocol", value="Protocol of proxy service. proxyServiceUrl and proxyProtocol must be mutually inclusive.")
    private ProxyProtocol proxyProtocol;
    @ApiModelProperty(name="enableTransaction", value="Whether to enable transaction.")
    private boolean enableTransaction = false;
    @JsonIgnore
    private Clock clock = Clock.systemDefaultZone();
    @ApiModelProperty(name="dnsLookupBindAddress", value="The Pulsar client dns lookup bind address, default behavior is bind on 0.0.0.0")
    private String dnsLookupBindAddress = null;
    @ApiModelProperty(name="dnsLookupBindPort", value="The Pulsar client dns lookup bind port, takes effect when dnsLookupBindAddress is configured, default value is 0.")
    private int dnsLookupBindPort = 0;
    @ApiModelProperty(name="dnsServerAddresses", value="The Pulsar client dns lookup server address")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
    private List<InetSocketAddress> dnsServerAddresses = new ArrayList<InetSocketAddress>();
    @ApiModelProperty(name="socks5ProxyAddress", value="Address of SOCKS5 proxy.")
    private InetSocketAddress socks5ProxyAddress;
    @ApiModelProperty(name="socks5ProxyUsername", value="User name of SOCKS5 proxy.")
    private String socks5ProxyUsername;
    @ApiModelProperty(name="socks5ProxyPassword", value="Password of SOCKS5 proxy.")
    @Secret
    private String socks5ProxyPassword;
    @ApiModelProperty(name="description", value="The extra description of the client version. The length cannot exceed 64.")
    private String description;
    private Map<String, String> lookupProperties;
    private transient OpenTelemetry openTelemetry;

    public Authentication getAuthentication() {
        return this.authentication != null ? this.authentication : AuthenticationDisabled.INSTANCE;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public boolean isUseTls() {
        if (this.useTls) {
            return true;
        }
        if (this.getServiceUrl() != null && (this.getServiceUrl().startsWith("pulsar+ssl") || this.getServiceUrl().startsWith("https"))) {
            this.useTls = true;
            return true;
        }
        return false;
    }

    public long getLookupTimeoutMs() {
        if (this.lookupTimeoutMs >= 0L) {
            return this.lookupTimeoutMs;
        }
        return this.operationTimeoutMs;
    }

    public ClientConfigurationData clone() {
        try {
            return (ClientConfigurationData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ClientConfigurationData");
        }
    }

    public InetSocketAddress getSocks5ProxyAddress() {
        if (Objects.nonNull(this.socks5ProxyAddress)) {
            return this.socks5ProxyAddress;
        }
        String proxyAddress = System.getProperty("socks5Proxy.address");
        return Optional.ofNullable(proxyAddress).map(address -> {
            try {
                URI uri = URI.create(address);
                return new InetSocketAddress(uri.getHost(), uri.getPort());
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid config [socks5Proxy.address]", e);
            }
        }).orElse(null);
    }

    public String getSocks5ProxyUsername() {
        return Objects.nonNull(this.socks5ProxyUsername) ? this.socks5ProxyUsername : System.getProperty("socks5Proxy.username");
    }

    public String getSocks5ProxyPassword() {
        return Objects.nonNull(this.socks5ProxyPassword) ? this.socks5ProxyPassword : System.getProperty("socks5Proxy.password");
    }

    public void setLookupProperties(Map<String, String> lookupProperties) {
        this.lookupProperties = Collections.unmodifiableMap(lookupProperties);
    }

    public Map<String, String> getLookupProperties() {
        return this.lookupProperties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.lookupProperties);
    }

    @Generated
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Generated
    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    @Generated
    public String getAuthPluginClassName() {
        return this.authPluginClassName;
    }

    @Generated
    public String getAuthParams() {
        return this.authParams;
    }

    @Generated
    public Map<String, String> getAuthParamMap() {
        return this.authParamMap;
    }

    @Generated
    public String getOriginalPrincipal() {
        return this.originalPrincipal;
    }

    @Generated
    public long getOperationTimeoutMs() {
        return this.operationTimeoutMs;
    }

    @Generated
    public long getStatsIntervalSeconds() {
        return this.statsIntervalSeconds;
    }

    @Generated
    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    @Generated
    public int getNumListenerThreads() {
        return this.numListenerThreads;
    }

    @Generated
    public int getConnectionsPerBroker() {
        return this.connectionsPerBroker;
    }

    @Generated
    public int getConnectionMaxIdleSeconds() {
        return this.connectionMaxIdleSeconds;
    }

    @Generated
    public boolean isUseTcpNoDelay() {
        return this.useTcpNoDelay;
    }

    @Generated
    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    @Generated
    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    @Generated
    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    @Generated
    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    @Generated
    public boolean isTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    @Generated
    public String getSslFactoryPlugin() {
        return this.sslFactoryPlugin;
    }

    @Generated
    public String getSslFactoryPluginParams() {
        return this.sslFactoryPluginParams;
    }

    @Generated
    public int getConcurrentLookupRequest() {
        return this.concurrentLookupRequest;
    }

    @Generated
    public int getMaxLookupRequest() {
        return this.maxLookupRequest;
    }

    @Generated
    public int getMaxLookupRedirects() {
        return this.maxLookupRedirects;
    }

    @Generated
    public int getMaxNumberOfRejectedRequestPerConnection() {
        return this.maxNumberOfRejectedRequestPerConnection;
    }

    @Generated
    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    @Generated
    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    @Generated
    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    @Generated
    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    @Generated
    public int getAutoCertRefreshSeconds() {
        return this.autoCertRefreshSeconds;
    }

    @Generated
    public long getInitialBackoffIntervalNanos() {
        return this.initialBackoffIntervalNanos;
    }

    @Generated
    public long getMaxBackoffIntervalNanos() {
        return this.maxBackoffIntervalNanos;
    }

    @Generated
    public boolean isEnableBusyWait() {
        return this.enableBusyWait;
    }

    @Generated
    public String getListenerName() {
        return this.listenerName;
    }

    @Generated
    public boolean isUseKeyStoreTls() {
        return this.useKeyStoreTls;
    }

    @Generated
    public String getSslProvider() {
        return this.sslProvider;
    }

    @Generated
    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    @Generated
    public String getTlsKeyStorePath() {
        return this.tlsKeyStorePath;
    }

    @Generated
    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    @Generated
    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    @Generated
    public String getTlsTrustStorePath() {
        return this.tlsTrustStorePath;
    }

    @Generated
    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    @Generated
    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    @Generated
    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    @Generated
    public long getMemoryLimitBytes() {
        return this.memoryLimitBytes;
    }

    @Generated
    public String getProxyServiceUrl() {
        return this.proxyServiceUrl;
    }

    @Generated
    public ProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    @Generated
    public boolean isEnableTransaction() {
        return this.enableTransaction;
    }

    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public String getDnsLookupBindAddress() {
        return this.dnsLookupBindAddress;
    }

    @Generated
    public int getDnsLookupBindPort() {
        return this.dnsLookupBindPort;
    }

    @Generated
    public List<InetSocketAddress> getDnsServerAddresses() {
        return this.dnsServerAddresses;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Generated
    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @JsonIgnore
    @Generated
    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.serviceUrlProvider = serviceUrlProvider;
    }

    @Generated
    public void setAuthPluginClassName(String authPluginClassName) {
        this.authPluginClassName = authPluginClassName;
    }

    @Generated
    public void setAuthParams(String authParams) {
        this.authParams = authParams;
    }

    @Generated
    public void setAuthParamMap(Map<String, String> authParamMap) {
        this.authParamMap = authParamMap;
    }

    @Generated
    public void setOriginalPrincipal(String originalPrincipal) {
        this.originalPrincipal = originalPrincipal;
    }

    @Generated
    public void setOperationTimeoutMs(long operationTimeoutMs) {
        this.operationTimeoutMs = operationTimeoutMs;
    }

    @Generated
    public void setLookupTimeoutMs(long lookupTimeoutMs) {
        this.lookupTimeoutMs = lookupTimeoutMs;
    }

    @Generated
    public void setStatsIntervalSeconds(long statsIntervalSeconds) {
        this.statsIntervalSeconds = statsIntervalSeconds;
    }

    @Generated
    public void setNumIoThreads(int numIoThreads) {
        this.numIoThreads = numIoThreads;
    }

    @Generated
    public void setNumListenerThreads(int numListenerThreads) {
        this.numListenerThreads = numListenerThreads;
    }

    @Generated
    public void setConnectionsPerBroker(int connectionsPerBroker) {
        this.connectionsPerBroker = connectionsPerBroker;
    }

    @Generated
    public void setConnectionMaxIdleSeconds(int connectionMaxIdleSeconds) {
        this.connectionMaxIdleSeconds = connectionMaxIdleSeconds;
    }

    @Generated
    public void setUseTcpNoDelay(boolean useTcpNoDelay) {
        this.useTcpNoDelay = useTcpNoDelay;
    }

    @Generated
    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    @Generated
    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    @Generated
    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    @Generated
    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    @Generated
    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    @Generated
    public void setTlsHostnameVerificationEnable(boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
    }

    @Generated
    public void setSslFactoryPlugin(String sslFactoryPlugin) {
        this.sslFactoryPlugin = sslFactoryPlugin;
    }

    @Generated
    public void setSslFactoryPluginParams(String sslFactoryPluginParams) {
        this.sslFactoryPluginParams = sslFactoryPluginParams;
    }

    @Generated
    public void setConcurrentLookupRequest(int concurrentLookupRequest) {
        this.concurrentLookupRequest = concurrentLookupRequest;
    }

    @Generated
    public void setMaxLookupRequest(int maxLookupRequest) {
        this.maxLookupRequest = maxLookupRequest;
    }

    @Generated
    public void setMaxLookupRedirects(int maxLookupRedirects) {
        this.maxLookupRedirects = maxLookupRedirects;
    }

    @Generated
    public void setMaxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
    }

    @Generated
    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    @Generated
    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    @Generated
    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    @Generated
    public void setReadTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }

    @Generated
    public void setAutoCertRefreshSeconds(int autoCertRefreshSeconds) {
        this.autoCertRefreshSeconds = autoCertRefreshSeconds;
    }

    @Generated
    public void setInitialBackoffIntervalNanos(long initialBackoffIntervalNanos) {
        this.initialBackoffIntervalNanos = initialBackoffIntervalNanos;
    }

    @Generated
    public void setMaxBackoffIntervalNanos(long maxBackoffIntervalNanos) {
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
    }

    @Generated
    public void setEnableBusyWait(boolean enableBusyWait) {
        this.enableBusyWait = enableBusyWait;
    }

    @Generated
    public void setListenerName(String listenerName) {
        this.listenerName = listenerName;
    }

    @Generated
    public void setUseKeyStoreTls(boolean useKeyStoreTls) {
        this.useKeyStoreTls = useKeyStoreTls;
    }

    @Generated
    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    @Generated
    public void setTlsKeyStoreType(String tlsKeyStoreType) {
        this.tlsKeyStoreType = tlsKeyStoreType;
    }

    @Generated
    public void setTlsKeyStorePath(String tlsKeyStorePath) {
        this.tlsKeyStorePath = tlsKeyStorePath;
    }

    @Generated
    public void setTlsKeyStorePassword(String tlsKeyStorePassword) {
        this.tlsKeyStorePassword = tlsKeyStorePassword;
    }

    @Generated
    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    @Generated
    public void setTlsTrustStorePath(String tlsTrustStorePath) {
        this.tlsTrustStorePath = tlsTrustStorePath;
    }

    @Generated
    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    @Generated
    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    @Generated
    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    @Generated
    public void setMemoryLimitBytes(long memoryLimitBytes) {
        this.memoryLimitBytes = memoryLimitBytes;
    }

    @Generated
    public void setProxyServiceUrl(String proxyServiceUrl) {
        this.proxyServiceUrl = proxyServiceUrl;
    }

    @Generated
    public void setProxyProtocol(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    @Generated
    public void setEnableTransaction(boolean enableTransaction) {
        this.enableTransaction = enableTransaction;
    }

    @JsonIgnore
    @Generated
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Generated
    public void setDnsLookupBindAddress(String dnsLookupBindAddress) {
        this.dnsLookupBindAddress = dnsLookupBindAddress;
    }

    @Generated
    public void setDnsLookupBindPort(int dnsLookupBindPort) {
        this.dnsLookupBindPort = dnsLookupBindPort;
    }

    @Generated
    public void setDnsServerAddresses(List<InetSocketAddress> dnsServerAddresses) {
        this.dnsServerAddresses = dnsServerAddresses;
    }

    @Generated
    public void setSocks5ProxyAddress(InetSocketAddress socks5ProxyAddress) {
        this.socks5ProxyAddress = socks5ProxyAddress;
    }

    @Generated
    public void setSocks5ProxyUsername(String socks5ProxyUsername) {
        this.socks5ProxyUsername = socks5ProxyUsername;
    }

    @Generated
    public void setSocks5ProxyPassword(String socks5ProxyPassword) {
        this.socks5ProxyPassword = socks5ProxyPassword;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfigurationData)) {
            return false;
        }
        ClientConfigurationData other = (ClientConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOperationTimeoutMs() != other.getOperationTimeoutMs()) {
            return false;
        }
        if (this.getLookupTimeoutMs() != other.getLookupTimeoutMs()) {
            return false;
        }
        if (this.getStatsIntervalSeconds() != other.getStatsIntervalSeconds()) {
            return false;
        }
        if (this.getNumIoThreads() != other.getNumIoThreads()) {
            return false;
        }
        if (this.getNumListenerThreads() != other.getNumListenerThreads()) {
            return false;
        }
        if (this.getConnectionsPerBroker() != other.getConnectionsPerBroker()) {
            return false;
        }
        if (this.getConnectionMaxIdleSeconds() != other.getConnectionMaxIdleSeconds()) {
            return false;
        }
        if (this.isUseTcpNoDelay() != other.isUseTcpNoDelay()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsHostnameVerificationEnable() != other.isTlsHostnameVerificationEnable()) {
            return false;
        }
        if (this.getConcurrentLookupRequest() != other.getConcurrentLookupRequest()) {
            return false;
        }
        if (this.getMaxLookupRequest() != other.getMaxLookupRequest()) {
            return false;
        }
        if (this.getMaxLookupRedirects() != other.getMaxLookupRedirects()) {
            return false;
        }
        if (this.getMaxNumberOfRejectedRequestPerConnection() != other.getMaxNumberOfRejectedRequestPerConnection()) {
            return false;
        }
        if (this.getKeepAliveIntervalSeconds() != other.getKeepAliveIntervalSeconds()) {
            return false;
        }
        if (this.getConnectionTimeoutMs() != other.getConnectionTimeoutMs()) {
            return false;
        }
        if (this.getRequestTimeoutMs() != other.getRequestTimeoutMs()) {
            return false;
        }
        if (this.getReadTimeoutMs() != other.getReadTimeoutMs()) {
            return false;
        }
        if (this.getAutoCertRefreshSeconds() != other.getAutoCertRefreshSeconds()) {
            return false;
        }
        if (this.getInitialBackoffIntervalNanos() != other.getInitialBackoffIntervalNanos()) {
            return false;
        }
        if (this.getMaxBackoffIntervalNanos() != other.getMaxBackoffIntervalNanos()) {
            return false;
        }
        if (this.isEnableBusyWait() != other.isEnableBusyWait()) {
            return false;
        }
        if (this.isUseKeyStoreTls() != other.isUseKeyStoreTls()) {
            return false;
        }
        if (this.getMemoryLimitBytes() != other.getMemoryLimitBytes()) {
            return false;
        }
        if (this.isEnableTransaction() != other.isEnableTransaction()) {
            return false;
        }
        if (this.getDnsLookupBindPort() != other.getDnsLookupBindPort()) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
            return false;
        }
        String this$authPluginClassName = this.getAuthPluginClassName();
        String other$authPluginClassName = other.getAuthPluginClassName();
        if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
            return false;
        }
        String this$authParams = this.getAuthParams();
        String other$authParams = other.getAuthParams();
        if (this$authParams == null ? other$authParams != null : !this$authParams.equals(other$authParams)) {
            return false;
        }
        Map<String, String> this$authParamMap = this.getAuthParamMap();
        Map<String, String> other$authParamMap = other.getAuthParamMap();
        if (this$authParamMap == null ? other$authParamMap != null : !((Object)this$authParamMap).equals(other$authParamMap)) {
            return false;
        }
        String this$originalPrincipal = this.getOriginalPrincipal();
        String other$originalPrincipal = other.getOriginalPrincipal();
        if (this$originalPrincipal == null ? other$originalPrincipal != null : !this$originalPrincipal.equals(other$originalPrincipal)) {
            return false;
        }
        String this$tlsKeyFilePath = this.getTlsKeyFilePath();
        String other$tlsKeyFilePath = other.getTlsKeyFilePath();
        if (this$tlsKeyFilePath == null ? other$tlsKeyFilePath != null : !this$tlsKeyFilePath.equals(other$tlsKeyFilePath)) {
            return false;
        }
        String this$tlsCertificateFilePath = this.getTlsCertificateFilePath();
        String other$tlsCertificateFilePath = other.getTlsCertificateFilePath();
        if (this$tlsCertificateFilePath == null ? other$tlsCertificateFilePath != null : !this$tlsCertificateFilePath.equals(other$tlsCertificateFilePath)) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        String this$sslFactoryPlugin = this.getSslFactoryPlugin();
        String other$sslFactoryPlugin = other.getSslFactoryPlugin();
        if (this$sslFactoryPlugin == null ? other$sslFactoryPlugin != null : !this$sslFactoryPlugin.equals(other$sslFactoryPlugin)) {
            return false;
        }
        String this$sslFactoryPluginParams = this.getSslFactoryPluginParams();
        String other$sslFactoryPluginParams = other.getSslFactoryPluginParams();
        if (this$sslFactoryPluginParams == null ? other$sslFactoryPluginParams != null : !this$sslFactoryPluginParams.equals(other$sslFactoryPluginParams)) {
            return false;
        }
        String this$listenerName = this.getListenerName();
        String other$listenerName = other.getListenerName();
        if (this$listenerName == null ? other$listenerName != null : !this$listenerName.equals(other$listenerName)) {
            return false;
        }
        String this$sslProvider = this.getSslProvider();
        String other$sslProvider = other.getSslProvider();
        if (this$sslProvider == null ? other$sslProvider != null : !this$sslProvider.equals(other$sslProvider)) {
            return false;
        }
        String this$tlsKeyStoreType = this.getTlsKeyStoreType();
        String other$tlsKeyStoreType = other.getTlsKeyStoreType();
        if (this$tlsKeyStoreType == null ? other$tlsKeyStoreType != null : !this$tlsKeyStoreType.equals(other$tlsKeyStoreType)) {
            return false;
        }
        String this$tlsKeyStorePath = this.getTlsKeyStorePath();
        String other$tlsKeyStorePath = other.getTlsKeyStorePath();
        if (this$tlsKeyStorePath == null ? other$tlsKeyStorePath != null : !this$tlsKeyStorePath.equals(other$tlsKeyStorePath)) {
            return false;
        }
        String this$tlsKeyStorePassword = this.getTlsKeyStorePassword();
        String other$tlsKeyStorePassword = other.getTlsKeyStorePassword();
        if (this$tlsKeyStorePassword == null ? other$tlsKeyStorePassword != null : !this$tlsKeyStorePassword.equals(other$tlsKeyStorePassword)) {
            return false;
        }
        String this$tlsTrustStoreType = this.getTlsTrustStoreType();
        String other$tlsTrustStoreType = other.getTlsTrustStoreType();
        if (this$tlsTrustStoreType == null ? other$tlsTrustStoreType != null : !this$tlsTrustStoreType.equals(other$tlsTrustStoreType)) {
            return false;
        }
        String this$tlsTrustStorePath = this.getTlsTrustStorePath();
        String other$tlsTrustStorePath = other.getTlsTrustStorePath();
        if (this$tlsTrustStorePath == null ? other$tlsTrustStorePath != null : !this$tlsTrustStorePath.equals(other$tlsTrustStorePath)) {
            return false;
        }
        String this$tlsTrustStorePassword = this.getTlsTrustStorePassword();
        String other$tlsTrustStorePassword = other.getTlsTrustStorePassword();
        if (this$tlsTrustStorePassword == null ? other$tlsTrustStorePassword != null : !this$tlsTrustStorePassword.equals(other$tlsTrustStorePassword)) {
            return false;
        }
        Set<String> this$tlsCiphers = this.getTlsCiphers();
        Set<String> other$tlsCiphers = other.getTlsCiphers();
        if (this$tlsCiphers == null ? other$tlsCiphers != null : !((Object)this$tlsCiphers).equals(other$tlsCiphers)) {
            return false;
        }
        Set<String> this$tlsProtocols = this.getTlsProtocols();
        Set<String> other$tlsProtocols = other.getTlsProtocols();
        if (this$tlsProtocols == null ? other$tlsProtocols != null : !((Object)this$tlsProtocols).equals(other$tlsProtocols)) {
            return false;
        }
        String this$proxyServiceUrl = this.getProxyServiceUrl();
        String other$proxyServiceUrl = other.getProxyServiceUrl();
        if (this$proxyServiceUrl == null ? other$proxyServiceUrl != null : !this$proxyServiceUrl.equals(other$proxyServiceUrl)) {
            return false;
        }
        ProxyProtocol this$proxyProtocol = this.getProxyProtocol();
        ProxyProtocol other$proxyProtocol = other.getProxyProtocol();
        if (this$proxyProtocol == null ? other$proxyProtocol != null : !this$proxyProtocol.equals(other$proxyProtocol)) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
            return false;
        }
        String this$dnsLookupBindAddress = this.getDnsLookupBindAddress();
        String other$dnsLookupBindAddress = other.getDnsLookupBindAddress();
        if (this$dnsLookupBindAddress == null ? other$dnsLookupBindAddress != null : !this$dnsLookupBindAddress.equals(other$dnsLookupBindAddress)) {
            return false;
        }
        List<InetSocketAddress> this$dnsServerAddresses = this.getDnsServerAddresses();
        List<InetSocketAddress> other$dnsServerAddresses = other.getDnsServerAddresses();
        if (this$dnsServerAddresses == null ? other$dnsServerAddresses != null : !((Object)this$dnsServerAddresses).equals(other$dnsServerAddresses)) {
            return false;
        }
        InetSocketAddress this$socks5ProxyAddress = this.getSocks5ProxyAddress();
        InetSocketAddress other$socks5ProxyAddress = other.getSocks5ProxyAddress();
        if (this$socks5ProxyAddress == null ? other$socks5ProxyAddress != null : !((Object)this$socks5ProxyAddress).equals(other$socks5ProxyAddress)) {
            return false;
        }
        String this$socks5ProxyUsername = this.getSocks5ProxyUsername();
        String other$socks5ProxyUsername = other.getSocks5ProxyUsername();
        if (this$socks5ProxyUsername == null ? other$socks5ProxyUsername != null : !this$socks5ProxyUsername.equals(other$socks5ProxyUsername)) {
            return false;
        }
        String this$socks5ProxyPassword = this.getSocks5ProxyPassword();
        String other$socks5ProxyPassword = other.getSocks5ProxyPassword();
        if (this$socks5ProxyPassword == null ? other$socks5ProxyPassword != null : !this$socks5ProxyPassword.equals(other$socks5ProxyPassword)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$lookupProperties = this.getLookupProperties();
        Map<String, String> other$lookupProperties = other.getLookupProperties();
        return !(this$lookupProperties == null ? other$lookupProperties != null : !((Object)this$lookupProperties).equals(other$lookupProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientConfigurationData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $operationTimeoutMs = this.getOperationTimeoutMs();
        result = result * 59 + (int)($operationTimeoutMs >>> 32 ^ $operationTimeoutMs);
        long $lookupTimeoutMs = this.getLookupTimeoutMs();
        result = result * 59 + (int)($lookupTimeoutMs >>> 32 ^ $lookupTimeoutMs);
        long $statsIntervalSeconds = this.getStatsIntervalSeconds();
        result = result * 59 + (int)($statsIntervalSeconds >>> 32 ^ $statsIntervalSeconds);
        result = result * 59 + this.getNumIoThreads();
        result = result * 59 + this.getNumListenerThreads();
        result = result * 59 + this.getConnectionsPerBroker();
        result = result * 59 + this.getConnectionMaxIdleSeconds();
        result = result * 59 + (this.isUseTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsHostnameVerificationEnable() ? 79 : 97);
        result = result * 59 + this.getConcurrentLookupRequest();
        result = result * 59 + this.getMaxLookupRequest();
        result = result * 59 + this.getMaxLookupRedirects();
        result = result * 59 + this.getMaxNumberOfRejectedRequestPerConnection();
        result = result * 59 + this.getKeepAliveIntervalSeconds();
        result = result * 59 + this.getConnectionTimeoutMs();
        result = result * 59 + this.getRequestTimeoutMs();
        result = result * 59 + this.getReadTimeoutMs();
        result = result * 59 + this.getAutoCertRefreshSeconds();
        long $initialBackoffIntervalNanos = this.getInitialBackoffIntervalNanos();
        result = result * 59 + (int)($initialBackoffIntervalNanos >>> 32 ^ $initialBackoffIntervalNanos);
        long $maxBackoffIntervalNanos = this.getMaxBackoffIntervalNanos();
        result = result * 59 + (int)($maxBackoffIntervalNanos >>> 32 ^ $maxBackoffIntervalNanos);
        result = result * 59 + (this.isEnableBusyWait() ? 79 : 97);
        result = result * 59 + (this.isUseKeyStoreTls() ? 79 : 97);
        long $memoryLimitBytes = this.getMemoryLimitBytes();
        result = result * 59 + (int)($memoryLimitBytes >>> 32 ^ $memoryLimitBytes);
        result = result * 59 + (this.isEnableTransaction() ? 79 : 97);
        result = result * 59 + this.getDnsLookupBindPort();
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        String $authPluginClassName = this.getAuthPluginClassName();
        result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
        String $authParams = this.getAuthParams();
        result = result * 59 + ($authParams == null ? 43 : $authParams.hashCode());
        Map<String, String> $authParamMap = this.getAuthParamMap();
        result = result * 59 + ($authParamMap == null ? 43 : ((Object)$authParamMap).hashCode());
        String $originalPrincipal = this.getOriginalPrincipal();
        result = result * 59 + ($originalPrincipal == null ? 43 : $originalPrincipal.hashCode());
        String $tlsKeyFilePath = this.getTlsKeyFilePath();
        result = result * 59 + ($tlsKeyFilePath == null ? 43 : $tlsKeyFilePath.hashCode());
        String $tlsCertificateFilePath = this.getTlsCertificateFilePath();
        result = result * 59 + ($tlsCertificateFilePath == null ? 43 : $tlsCertificateFilePath.hashCode());
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        String $sslFactoryPlugin = this.getSslFactoryPlugin();
        result = result * 59 + ($sslFactoryPlugin == null ? 43 : $sslFactoryPlugin.hashCode());
        String $sslFactoryPluginParams = this.getSslFactoryPluginParams();
        result = result * 59 + ($sslFactoryPluginParams == null ? 43 : $sslFactoryPluginParams.hashCode());
        String $listenerName = this.getListenerName();
        result = result * 59 + ($listenerName == null ? 43 : $listenerName.hashCode());
        String $sslProvider = this.getSslProvider();
        result = result * 59 + ($sslProvider == null ? 43 : $sslProvider.hashCode());
        String $tlsKeyStoreType = this.getTlsKeyStoreType();
        result = result * 59 + ($tlsKeyStoreType == null ? 43 : $tlsKeyStoreType.hashCode());
        String $tlsKeyStorePath = this.getTlsKeyStorePath();
        result = result * 59 + ($tlsKeyStorePath == null ? 43 : $tlsKeyStorePath.hashCode());
        String $tlsKeyStorePassword = this.getTlsKeyStorePassword();
        result = result * 59 + ($tlsKeyStorePassword == null ? 43 : $tlsKeyStorePassword.hashCode());
        String $tlsTrustStoreType = this.getTlsTrustStoreType();
        result = result * 59 + ($tlsTrustStoreType == null ? 43 : $tlsTrustStoreType.hashCode());
        String $tlsTrustStorePath = this.getTlsTrustStorePath();
        result = result * 59 + ($tlsTrustStorePath == null ? 43 : $tlsTrustStorePath.hashCode());
        String $tlsTrustStorePassword = this.getTlsTrustStorePassword();
        result = result * 59 + ($tlsTrustStorePassword == null ? 43 : $tlsTrustStorePassword.hashCode());
        Set<String> $tlsCiphers = this.getTlsCiphers();
        result = result * 59 + ($tlsCiphers == null ? 43 : ((Object)$tlsCiphers).hashCode());
        Set<String> $tlsProtocols = this.getTlsProtocols();
        result = result * 59 + ($tlsProtocols == null ? 43 : ((Object)$tlsProtocols).hashCode());
        String $proxyServiceUrl = this.getProxyServiceUrl();
        result = result * 59 + ($proxyServiceUrl == null ? 43 : $proxyServiceUrl.hashCode());
        ProxyProtocol $proxyProtocol = this.getProxyProtocol();
        result = result * 59 + ($proxyProtocol == null ? 43 : $proxyProtocol.hashCode());
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        String $dnsLookupBindAddress = this.getDnsLookupBindAddress();
        result = result * 59 + ($dnsLookupBindAddress == null ? 43 : $dnsLookupBindAddress.hashCode());
        List<InetSocketAddress> $dnsServerAddresses = this.getDnsServerAddresses();
        result = result * 59 + ($dnsServerAddresses == null ? 43 : ((Object)$dnsServerAddresses).hashCode());
        InetSocketAddress $socks5ProxyAddress = this.getSocks5ProxyAddress();
        result = result * 59 + ($socks5ProxyAddress == null ? 43 : ((Object)$socks5ProxyAddress).hashCode());
        String $socks5ProxyUsername = this.getSocks5ProxyUsername();
        result = result * 59 + ($socks5ProxyUsername == null ? 43 : $socks5ProxyUsername.hashCode());
        String $socks5ProxyPassword = this.getSocks5ProxyPassword();
        result = result * 59 + ($socks5ProxyPassword == null ? 43 : $socks5ProxyPassword.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $lookupProperties = this.getLookupProperties();
        result = result * 59 + ($lookupProperties == null ? 43 : ((Object)$lookupProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientConfigurationData(serviceUrl=" + this.getServiceUrl() + ", serviceUrlProvider=" + this.getServiceUrlProvider() + ", authentication=" + this.getAuthentication() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", authParams=" + this.getAuthParams() + ", authParamMap=" + this.getAuthParamMap() + ", originalPrincipal=" + this.getOriginalPrincipal() + ", operationTimeoutMs=" + this.getOperationTimeoutMs() + ", lookupTimeoutMs=" + this.getLookupTimeoutMs() + ", statsIntervalSeconds=" + this.getStatsIntervalSeconds() + ", numIoThreads=" + this.getNumIoThreads() + ", numListenerThreads=" + this.getNumListenerThreads() + ", connectionsPerBroker=" + this.getConnectionsPerBroker() + ", connectionMaxIdleSeconds=" + this.getConnectionMaxIdleSeconds() + ", useTcpNoDelay=" + this.isUseTcpNoDelay() + ", useTls=" + this.isUseTls() + ", tlsKeyFilePath=" + this.getTlsKeyFilePath() + ", tlsCertificateFilePath=" + this.getTlsCertificateFilePath() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsHostnameVerificationEnable=" + this.isTlsHostnameVerificationEnable() + ", sslFactoryPlugin=" + this.getSslFactoryPlugin() + ", sslFactoryPluginParams=" + this.getSslFactoryPluginParams() + ", concurrentLookupRequest=" + this.getConcurrentLookupRequest() + ", maxLookupRequest=" + this.getMaxLookupRequest() + ", maxLookupRedirects=" + this.getMaxLookupRedirects() + ", maxNumberOfRejectedRequestPerConnection=" + this.getMaxNumberOfRejectedRequestPerConnection() + ", keepAliveIntervalSeconds=" + this.getKeepAliveIntervalSeconds() + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ", requestTimeoutMs=" + this.getRequestTimeoutMs() + ", readTimeoutMs=" + this.getReadTimeoutMs() + ", autoCertRefreshSeconds=" + this.getAutoCertRefreshSeconds() + ", initialBackoffIntervalNanos=" + this.getInitialBackoffIntervalNanos() + ", maxBackoffIntervalNanos=" + this.getMaxBackoffIntervalNanos() + ", enableBusyWait=" + this.isEnableBusyWait() + ", listenerName=" + this.getListenerName() + ", useKeyStoreTls=" + this.isUseKeyStoreTls() + ", sslProvider=" + this.getSslProvider() + ", tlsKeyStoreType=" + this.getTlsKeyStoreType() + ", tlsKeyStorePath=" + this.getTlsKeyStorePath() + ", tlsKeyStorePassword=" + this.getTlsKeyStorePassword() + ", tlsTrustStoreType=" + this.getTlsTrustStoreType() + ", tlsTrustStorePath=" + this.getTlsTrustStorePath() + ", tlsTrustStorePassword=" + this.getTlsTrustStorePassword() + ", tlsCiphers=" + this.getTlsCiphers() + ", tlsProtocols=" + this.getTlsProtocols() + ", memoryLimitBytes=" + this.getMemoryLimitBytes() + ", proxyServiceUrl=" + this.getProxyServiceUrl() + ", proxyProtocol=" + this.getProxyProtocol() + ", enableTransaction=" + this.isEnableTransaction() + ", clock=" + this.getClock() + ", dnsLookupBindAddress=" + this.getDnsLookupBindAddress() + ", dnsLookupBindPort=" + this.getDnsLookupBindPort() + ", dnsServerAddresses=" + this.getDnsServerAddresses() + ", socks5ProxyAddress=" + this.getSocks5ProxyAddress() + ", socks5ProxyUsername=" + this.getSocks5ProxyUsername() + ", socks5ProxyPassword=" + this.getSocks5ProxyPassword() + ", description=" + this.getDescription() + ", lookupProperties=" + this.getLookupProperties() + ", openTelemetry=" + this.getOpenTelemetry() + ")";
    }

    @Generated
    public ClientConfigurationData() {
    }

    @Generated
    public ClientConfigurationData(String serviceUrl, ServiceUrlProvider serviceUrlProvider, Authentication authentication, String authPluginClassName, String authParams, Map<String, String> authParamMap, String originalPrincipal, long operationTimeoutMs, long lookupTimeoutMs, long statsIntervalSeconds, int numIoThreads, int numListenerThreads, int connectionsPerBroker, int connectionMaxIdleSeconds, boolean useTcpNoDelay, boolean useTls, String tlsKeyFilePath, String tlsCertificateFilePath, String tlsTrustCertsFilePath, boolean tlsAllowInsecureConnection, boolean tlsHostnameVerificationEnable, String sslFactoryPlugin, String sslFactoryPluginParams, int concurrentLookupRequest, int maxLookupRequest, int maxLookupRedirects, int maxNumberOfRejectedRequestPerConnection, int keepAliveIntervalSeconds, int connectionTimeoutMs, int requestTimeoutMs, int readTimeoutMs, int autoCertRefreshSeconds, long initialBackoffIntervalNanos, long maxBackoffIntervalNanos, boolean enableBusyWait, String listenerName, boolean useKeyStoreTls, String sslProvider, String tlsKeyStoreType, String tlsKeyStorePath, String tlsKeyStorePassword, String tlsTrustStoreType, String tlsTrustStorePath, String tlsTrustStorePassword, Set<String> tlsCiphers, Set<String> tlsProtocols, long memoryLimitBytes, String proxyServiceUrl, ProxyProtocol proxyProtocol, boolean enableTransaction, Clock clock, String dnsLookupBindAddress, int dnsLookupBindPort, List<InetSocketAddress> dnsServerAddresses, InetSocketAddress socks5ProxyAddress, String socks5ProxyUsername, String socks5ProxyPassword, String description, Map<String, String> lookupProperties, OpenTelemetry openTelemetry) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlProvider = serviceUrlProvider;
        this.authentication = authentication;
        this.authPluginClassName = authPluginClassName;
        this.authParams = authParams;
        this.authParamMap = authParamMap;
        this.originalPrincipal = originalPrincipal;
        this.operationTimeoutMs = operationTimeoutMs;
        this.lookupTimeoutMs = lookupTimeoutMs;
        this.statsIntervalSeconds = statsIntervalSeconds;
        this.numIoThreads = numIoThreads;
        this.numListenerThreads = numListenerThreads;
        this.connectionsPerBroker = connectionsPerBroker;
        this.connectionMaxIdleSeconds = connectionMaxIdleSeconds;
        this.useTcpNoDelay = useTcpNoDelay;
        this.useTls = useTls;
        this.tlsKeyFilePath = tlsKeyFilePath;
        this.tlsCertificateFilePath = tlsCertificateFilePath;
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        this.sslFactoryPlugin = sslFactoryPlugin;
        this.sslFactoryPluginParams = sslFactoryPluginParams;
        this.concurrentLookupRequest = concurrentLookupRequest;
        this.maxLookupRequest = maxLookupRequest;
        this.maxLookupRedirects = maxLookupRedirects;
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.autoCertRefreshSeconds = autoCertRefreshSeconds;
        this.initialBackoffIntervalNanos = initialBackoffIntervalNanos;
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
        this.enableBusyWait = enableBusyWait;
        this.listenerName = listenerName;
        this.useKeyStoreTls = useKeyStoreTls;
        this.sslProvider = sslProvider;
        this.tlsKeyStoreType = tlsKeyStoreType;
        this.tlsKeyStorePath = tlsKeyStorePath;
        this.tlsKeyStorePassword = tlsKeyStorePassword;
        this.tlsTrustStoreType = tlsTrustStoreType;
        this.tlsTrustStorePath = tlsTrustStorePath;
        this.tlsTrustStorePassword = tlsTrustStorePassword;
        this.tlsCiphers = tlsCiphers;
        this.tlsProtocols = tlsProtocols;
        this.memoryLimitBytes = memoryLimitBytes;
        this.proxyServiceUrl = proxyServiceUrl;
        this.proxyProtocol = proxyProtocol;
        this.enableTransaction = enableTransaction;
        this.clock = clock;
        this.dnsLookupBindAddress = dnsLookupBindAddress;
        this.dnsLookupBindPort = dnsLookupBindPort;
        this.dnsServerAddresses = dnsServerAddresses;
        this.socks5ProxyAddress = socks5ProxyAddress;
        this.socks5ProxyUsername = socks5ProxyUsername;
        this.socks5ProxyPassword = socks5ProxyPassword;
        this.description = description;
        this.lookupProperties = lookupProperties;
        this.openTelemetry = openTelemetry;
    }
}

