/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSender;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderCache;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.internal.adapter.AdaptedReactiveMessageSender;
import org.apache.pulsar.reactive.client.internal.adapter.ProducerCache;
import org.apache.pulsar.reactive.client.internal.adapter.ReactiveProducerAdapterFactory;
import org.apache.pulsar.reactive.client.internal.api.InflightLimiter;
import org.apache.pulsar.reactive.client.internal.api.PublisherTransformer;
import reactor.core.scheduler.Schedulers;

class AdaptedReactiveMessageSenderBuilder<T>
implements ReactiveMessageSenderBuilder<T> {
    private static final int MAX_CONCURRENCY_LOWER_BOUND = 32;
    private static final int MAX_CONCURRENCY_UPPER_BOUND = 256;
    private final Schema<T> schema;
    private final ReactiveProducerAdapterFactory reactiveProducerAdapterFactory;
    private final MutableReactiveMessageSenderSpec senderSpec;
    private ReactiveMessageSenderCache producerCache;
    private int maxInflight = -1;
    private int maxConcurrentSenderSubscriptions = 1024;
    private boolean stopOnError = false;
    private Supplier<PublisherTransformer> producerActionTransformer = PublisherTransformer::identity;

    AdaptedReactiveMessageSenderBuilder(Schema<T> schema, ReactiveProducerAdapterFactory reactiveProducerAdapterFactory) {
        this(schema, reactiveProducerAdapterFactory, new MutableReactiveMessageSenderSpec());
    }

    private AdaptedReactiveMessageSenderBuilder(Schema<T> schema, ReactiveProducerAdapterFactory reactiveProducerAdapterFactory, MutableReactiveMessageSenderSpec senderSpec) {
        this.schema = schema;
        this.reactiveProducerAdapterFactory = reactiveProducerAdapterFactory;
        this.senderSpec = senderSpec;
    }

    public ReactiveMessageSenderBuilder<T> cache(ReactiveMessageSenderCache producerCache) {
        this.producerCache = producerCache;
        return this;
    }

    public MutableReactiveMessageSenderSpec getMutableSpec() {
        return this.senderSpec;
    }

    public ReactiveMessageSenderBuilder<T> maxInflight(int maxInflight) {
        this.maxInflight = maxInflight;
        return this;
    }

    public ReactiveMessageSenderBuilder<T> maxConcurrentSenderSubscriptions(int maxConcurrentSenderSubscriptions) {
        this.maxConcurrentSenderSubscriptions = maxConcurrentSenderSubscriptions;
        return this;
    }

    public ReactiveMessageSenderBuilder<T> stopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
        return this;
    }

    public ReactiveMessageSenderBuilder<T> clone() {
        AdaptedReactiveMessageSenderBuilder<T> cloned = new AdaptedReactiveMessageSenderBuilder<T>(this.schema, this.reactiveProducerAdapterFactory, new MutableReactiveMessageSenderSpec((ReactiveMessageSenderSpec)this.senderSpec));
        cloned.producerCache = this.producerCache;
        cloned.maxInflight = this.maxInflight;
        cloned.maxConcurrentSenderSubscriptions = this.maxConcurrentSenderSubscriptions;
        cloned.producerActionTransformer = this.producerActionTransformer;
        cloned.stopOnError = this.stopOnError;
        return cloned;
    }

    public ReactiveMessageSender<T> build() {
        ProducerActionTransformerKey producerActionTransformerKey;
        if (this.maxInflight > 0) {
            Objects.requireNonNull(this.producerCache, "cache must be provided when maxInflight is set.");
            this.producerActionTransformer = () -> new InflightLimiter(this.maxInflight, Math.max(this.maxInflight / 2, 1), Schedulers.single(), this.maxConcurrentSenderSubscriptions);
            producerActionTransformerKey = new ProducerActionTransformerKey(this.maxInflight, this.maxConcurrentSenderSubscriptions);
        } else {
            producerActionTransformerKey = null;
        }
        return new AdaptedReactiveMessageSender<T>(this.schema, (ReactiveMessageSenderSpec)this.senderSpec, this.resolveMaxConcurrency(), this.reactiveProducerAdapterFactory, (ProducerCache)this.producerCache, this.producerActionTransformer, producerActionTransformerKey, this.stopOnError);
    }

    private int resolveMaxConcurrency() {
        return Math.min(Math.max(32, this.maxInflight / 2), 256);
    }

    private static class ProducerActionTransformerKey {
        private final int maxInflight;
        private final int maxConcurrentSenderSubscriptions;

        ProducerActionTransformerKey(int maxInflight, int maxConcurrentSenderSubscriptions) {
            this.maxInflight = maxInflight;
            this.maxConcurrentSenderSubscriptions = maxConcurrentSenderSubscriptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProducerActionTransformerKey that = (ProducerActionTransformerKey)o;
            return this.maxInflight == that.maxInflight && this.maxConcurrentSenderSubscriptions == that.maxConcurrentSenderSubscriptions;
        }

        public int hashCode() {
            return Objects.hash(this.maxInflight, this.maxConcurrentSenderSubscriptions);
        }
    }
}

