/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.reactive.client.api.MessageSpec;

public class MessageSendResult<T> {
    private final MessageId messageId;
    private final MessageSpec<T> messageSpec;
    private final Throwable exception;

    public MessageSendResult(MessageId messageId, MessageSpec<T> messageSpec, Throwable exception) {
        this.messageId = messageId;
        this.messageSpec = messageSpec;
        this.exception = exception;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageSpec<T> getMessageSpec() {
        return this.messageSpec;
    }

    public Throwable getException() {
        return this.exception;
    }

    public <C> C getCorrelationMetadata() {
        return this.messageSpec.getCorrelationMetadata();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSendResult that = (MessageSendResult)o;
        return Objects.equals(this.messageId, that.messageId) && Objects.equals(this.messageSpec, that.messageSpec);
    }

    public int hashCode() {
        return Objects.hash(this.messageId, this.messageSpec);
    }
}

