/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import reactor.core.scheduler.Scheduler;

public interface ReactiveMessageConsumerSpec {
    public List<String> getTopicNames();

    public Pattern getTopicsPattern();

    public RegexSubscriptionMode getTopicsPatternSubscriptionMode();

    public Duration getTopicsPatternAutoDiscoveryPeriod();

    public String getSubscriptionName();

    public SubscriptionMode getSubscriptionMode();

    public SubscriptionType getSubscriptionType();

    public SubscriptionInitialPosition getSubscriptionInitialPosition();

    public KeySharedPolicy getKeySharedPolicy();

    public Boolean getReplicateSubscriptionState();

    public Map<String, String> getSubscriptionProperties();

    public String getConsumerName();

    public Map<String, String> getProperties();

    public Integer getPriorityLevel();

    public Boolean getReadCompacted();

    public Boolean getBatchIndexAckEnabled();

    public Duration getAckTimeout();

    public Duration getAckTimeoutTickTime();

    public Duration getAcknowledgementsGroupTime();

    public Boolean getAcknowledgeAsynchronously();

    public Scheduler getAcknowledgeScheduler();

    public Duration getNegativeAckRedeliveryDelay();

    public DeadLetterPolicy getDeadLetterPolicy();

    public Boolean getRetryLetterTopicEnable();

    public Integer getReceiverQueueSize();

    public Integer getMaxTotalReceiverQueueSizeAcrossPartitions();

    public Boolean getAutoUpdatePartitions();

    public Duration getAutoUpdatePartitionsInterval();

    public CryptoKeyReader getCryptoKeyReader();

    public ConsumerCryptoFailureAction getCryptoFailureAction();

    public Integer getMaxPendingChunkedMessage();

    public Boolean getAutoAckOldestChunkedMessageOnQueueFull();

    public Duration getExpireTimeOfIncompleteChunkedMessage();
}

