/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.producercache;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.reactive.client.adapter.ProducerCacheProvider;
import reactor.core.scheduler.Schedulers;

public class CaffeineProducerCacheProvider
implements ProducerCacheProvider {
    final AsyncCache<Object, Object> cache;

    public CaffeineProducerCacheProvider() {
        this((Caffeine<Object, Object>)Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).expireAfterWrite(Duration.ofMinutes(10L)).maximumSize(1000L));
    }

    public CaffeineProducerCacheProvider(CaffeineSpec caffeineSpec) {
        this((Caffeine<Object, Object>)Caffeine.from((CaffeineSpec)caffeineSpec));
    }

    public CaffeineProducerCacheProvider(Caffeine<Object, Object> caffeineBuilder) {
        this.cache = caffeineBuilder.scheduler(Scheduler.systemScheduler()).executor(arg_0 -> ((reactor.core.scheduler.Scheduler)Schedulers.boundedElastic()).schedule(arg_0)).removalListener(this::onRemoval).buildAsync();
    }

    private void onRemoval(Object key, Object entry, RemovalCause cause) {
        if (entry instanceof AutoCloseable) {
            try {
                ((AutoCloseable)entry).close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void close() {
        this.cache.synchronous().invalidateAll();
    }

    public <K, V> CompletableFuture<V> getOrCreateCachedEntry(K key, Function<K, CompletableFuture<V>> createEntryFunction) {
        return this.cache.get(key, (__, ___) -> (CompletableFuture)createEntryFunction.apply(key));
    }
}

