/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdUsageFormatter;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.PulsarAdminImpl;

public abstract class CmdBase {
    protected final JCommander jcommander;
    private final Supplier<PulsarAdmin> adminSupplier;
    private PulsarAdmin admin;
    private IUsageFormatter usageFormatter;
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = 60000L;
    @Parameter(names={"--help", "-h"}, help=true, hidden=true)
    private boolean help = false;

    public boolean isHelp() {
        return this.help;
    }

    public CmdBase(String cmdName, Supplier<PulsarAdmin> adminSupplier) {
        this.adminSupplier = adminSupplier;
        this.jcommander = new JCommander((Object)this);
        this.usageFormatter = new CmdUsageFormatter(this.jcommander);
        this.jcommander.setProgramName("pulsar-admin " + cmdName);
        this.jcommander.setUsageFormatter(this.usageFormatter);
    }

    protected IUsageFormatter getUsageFormatter() {
        if (this.usageFormatter == null) {
            this.usageFormatter = new DefaultUsageFormatter(this.jcommander);
        }
        return this.usageFormatter;
    }

    private void tryShowCommandUsage() {
        try {
            String chosenCommand = this.jcommander.getParsedCommand();
            this.getUsageFormatter().usage(chosenCommand);
        }
        catch (Exception e) {
            System.err.println("Invalid command, please use `pulsar-admin --help` to check out how to use");
        }
    }

    public boolean run(String[] args) {
        try {
            this.jcommander.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            this.tryShowCommandUsage();
            return false;
        }
        String cmd = this.jcommander.getParsedCommand();
        if (cmd == null) {
            this.jcommander.usage();
            return this.help;
        }
        JCommander obj = (JCommander)this.jcommander.getCommands().get(cmd);
        CliCommand cmdObj = (CliCommand)obj.getObjects().get(0);
        if (cmdObj.isHelp()) {
            obj.setProgramName(this.jcommander.getProgramName() + " " + cmd);
            obj.usage();
            return true;
        }
        try {
            cmdObj.run();
            return true;
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.println();
            return false;
        }
        catch (PulsarAdminException.ConnectException e) {
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("Error connecting to: " + this.getAdmin().getServiceUrl());
            return false;
        }
        catch (PulsarAdminException e) {
            System.err.println(e.getHttpError());
            System.err.println();
            System.err.println("Reason: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected PulsarAdmin getAdmin() {
        if (this.admin == null) {
            this.admin = this.adminSupplier.get();
        }
        return this.admin;
    }

    protected long getReadTimeoutMs() {
        PulsarAdmin pulsarAdmin = this.getAdmin();
        if (pulsarAdmin instanceof PulsarAdminImpl) {
            return ((PulsarAdminImpl)pulsarAdmin).getClientConfigData().getReadTimeoutMs();
        }
        return 60000L;
    }

    protected <T> T sync(Supplier<CompletableFuture<T>> executor) throws PulsarAdminException {
        try {
            return executor.get().get(this.getReadTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw PulsarAdminException.wrap((PulsarAdminException)BaseResource.getApiException((Throwable)e.getCause()));
        }
        catch (Exception e) {
            throw PulsarAdminException.wrap((PulsarAdminException)BaseResource.getApiException((Throwable)e));
        }
    }

    static Map<String, String> parseListKeyValueMap(List<String> metadata) {
        HashMap<String, String> map = null;
        if (metadata != null && !metadata.isEmpty()) {
            map = new HashMap<String, String>();
            for (String property : metadata) {
                int pos = property.indexOf(61);
                if (pos <= 0) {
                    throw new ParameterException(String.format("Invalid key value pair '%s', valid format like 'a=b'.", property));
                }
                map.put(property.substring(0, pos), property.substring(pos + 1));
            }
        }
        return map;
    }

    public JCommander getJcommander() {
        return this.jcommander;
    }
}

