/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.Packages;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;

@Parameters(commandDescription="Operations about packages")
class CmdPackages
extends CmdBase {
    private Packages packages;

    public CmdPackages(Supplier<PulsarAdmin> admin) {
        super("packages", admin);
        this.jcommander.addCommand("get-metadata", (Object)new GetMetadataCmd());
        this.jcommander.addCommand("update-metadata", (Object)new UpdateMetadataCmd());
        this.jcommander.addCommand("upload", (Object)new UploadCmd());
        this.jcommander.addCommand("download", (Object)new DownloadCmd());
        this.jcommander.addCommand("list", (Object)new ListPackagesCmd());
        this.jcommander.addCommand("list-versions", (Object)new ListPackageVersionsCmd());
        this.jcommander.addCommand("delete", (Object)new DeletePackageCmd());
    }

    private Packages getPackages() {
        if (this.packages == null) {
            this.packages = this.getAdmin().packages();
        }
        return this.packages;
    }

    @Parameters(commandDescription="Get a package metadata information.")
    private class GetMetadataCmd
    extends CliCommand {
        @Parameter(description="type://tenant/namespace/packageName@version", required=true)
        private String packageName;

        private GetMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdPackages.this.getPackages().getMetadata(this.packageName));
        }
    }

    @Parameters(commandDescription="Update a package metadata information.")
    private class UpdateMetadataCmd
    extends CliCommand {
        @Parameter(description="type://tenant/namespace/packageName@version", required=true)
        private String packageName;
        @Parameter(names={"-d", "--description"}, description="descriptions of a package", required=true)
        private String description;
        @Parameter(names={"-c", "--contact"}, description="contact info of a package")
        private String contact;
        @DynamicParameter(names={"--properties", "-P"}, description="external information of a package")
        private Map<String, String> properties = new HashMap<String, String>();

        private UpdateMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            CmdPackages.this.getPackages().updateMetadata(this.packageName, PackageMetadata.builder().description(this.description).contact(this.contact).properties(this.properties).build());
            this.print(String.format("The metadata of the package '%s' updated successfully", this.packageName));
        }
    }

    @Parameters(commandDescription="Upload a package")
    private class UploadCmd
    extends CliCommand {
        @Parameter(description="type://tenant/namespace/packageName@version", required=true)
        private String packageName;
        @Parameter(names={"--description"}, description="descriptions of a package", required=true)
        private String description;
        @Parameter(names={"--contact"}, description="contact information of a package")
        private String contact;
        @DynamicParameter(names={"--properties", "-P"}, description="external information of a package")
        private Map<String, String> properties = new HashMap<String, String>();
        @Parameter(names={"--path"}, description="file path of the package", required=true)
        private String path;

        private UploadCmd() {
        }

        @Override
        void run() throws Exception {
            PackageMetadata metadata = PackageMetadata.builder().description(this.description).contact(this.contact).properties(this.properties).build();
            CmdPackages.this.getPackages().upload(metadata, this.packageName, this.path);
            this.print(String.format("The package '%s' uploaded from path '%s' successfully", this.packageName, this.path));
        }
    }

    @Parameters(commandDescription="Download a package")
    private class DownloadCmd
    extends CliCommand {
        @Parameter(description="type://tenant/namespace/packageName@version", required=true)
        private String packageName;
        @Parameter(names={"--path"}, description="download destiny path of the package", required=true)
        private String path;

        private DownloadCmd() {
        }

        @Override
        void run() throws Exception {
            CmdPackages.this.getPackages().download(this.packageName, this.path);
            this.print(String.format("The package '%s' downloaded to path '%s' successfully", this.packageName, this.path));
        }
    }

    @Parameters(commandDescription="List all packages with given type in the specified namespace")
    private class ListPackagesCmd
    extends CliCommand {
        @Parameter(names={"--type"}, description="type of the package", required=true)
        private String type;
        @Parameter(description="namespace of the package", required=true)
        private String namespace;

        private ListPackagesCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdPackages.this.getPackages().listPackages(this.type, this.namespace));
        }
    }

    @Parameters(commandDescription="List all versions of the given package")
    private class ListPackageVersionsCmd
    extends CliCommand {
        @Parameter(description="the package name you want to query, don't need to specify the package version. type://tenant/namespace/packageName", required=true)
        private String packageName;

        private ListPackageVersionsCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdPackages.this.getPackages().listPackageVersions(this.packageName));
        }
    }

    @Parameters(commandDescription="Delete a package")
    private class DeletePackageCmd
    extends CliCommand {
        @Parameter(description="type://tenant/namespace/packageName@version", required=true)
        private String packageName;

        private DeletePackageCmd() {
        }

        @Override
        void run() throws Exception {
            CmdPackages.this.getPackages().delete(this.packageName);
            this.print(String.format("The package '%s' deleted successfully", this.packageName));
        }
    }
}

