/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.internal.CommandDescriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Generate documents automatically."})
public class CmdGenerateDocument
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocument.class);
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec pulsarAdminCommandSpec;

    public CmdGenerateDocument(Supplier<PulsarAdmin> admin) {
        super("documents", admin);
        this.addCommand("generate", new GenerateDocument());
    }

    public CommandLine.Model.CommandSpec getPulsarAdminCommandSpec() {
        return this.pulsarAdminCommandSpec;
    }

    @CommandLine.Command(description={"Generate document for modules"})
    private class GenerateDocument
    extends CliCommand {
        @CommandLine.Parameters(description={"Please specify the module name, if not, documents will be generated for all modules.Optional modules(clusters, tenants, brokers, broker-stats, namespaces, topics, schemas, bookies,functions, ns-isolation-policy, resource-quotas, functions, sources, sinks)"})
        private List<String> modules;
        private final Set<String> generatedModule = new HashSet<String>();

        private GenerateDocument() {
        }

        @Override
        void run() throws PulsarAdminException {
            StringBuilder sb = new StringBuilder();
            if (this.modules == null || this.modules.isEmpty()) {
                CmdGenerateDocument.this.pulsarAdminCommandSpec.parent().subcommands().forEach((k, v) -> this.generateDocument(sb, (String)k, (CommandLine)v));
            } else {
                this.modules.forEach(module -> {
                    CommandLine commandLine = (CommandLine)CmdGenerateDocument.this.pulsarAdminCommandSpec.parent().subcommands().get(module);
                    if (commandLine == null) {
                        return;
                    }
                    this.generateDocument(sb, (String)module, commandLine);
                });
            }
        }

        private boolean needsLangSupport(String module, String subK) {
            String[] langSupport = new String[]{"localrun", "create", "update"};
            return module.equals("functions") && Arrays.asList(langSupport).contains(subK);
        }

        private void generateDocument(StringBuilder sb, String module, CommandLine obj) {
            if (this.generatedModule.contains(module)) {
                return;
            }
            String commandName = obj.getCommandName();
            this.generatedModule.add(commandName);
            sb.append("# ").append(module).append("\n\n");
            sb.append(CommandDescriptionUtil.getCommandDescription(obj)).append("\n");
            sb.append("\n\n```shell\n").append("$ pulsar-admin ").append(module).append(" subcommand").append("\n```");
            sb.append("\n\n");
            obj.getSubcommands().forEach((subK, subV) -> {
                sb.append("\n\n## ").append((String)subK).append("\n\n");
                sb.append(CommandDescriptionUtil.getCommandDescription(subV)).append("\n\n");
                sb.append("**Command:**\n\n");
                sb.append("```shell\n$ pulsar-admin ").append(module).append(" ").append((String)subK).append(" options").append("\n```\n\n");
                List options = obj.getCommandSpec().args();
                if (options.size() > 0) {
                    sb.append("**Options:**\n\n");
                    sb.append("|Flag|Description|Default|");
                    if (this.needsLangSupport(module, (String)subK)) {
                        sb.append("Support|\n");
                        sb.append("|---|---|---|---|\n");
                    } else {
                        sb.append("\n|---|---|---|\n");
                    }
                }
                options.forEach(ele -> {
                    if (ele.hidden() || !(ele instanceof CommandLine.Model.OptionSpec)) {
                        return;
                    }
                    String argDescription = CommandDescriptionUtil.getArgDescription(ele);
                    String[] descriptions = argDescription.replace("\n", " ").split(" #");
                    sb.append("| `").append(Arrays.toString(((CommandLine.Model.OptionSpec)ele).names())).append("` | ").append(descriptions[0]).append("|").append(ele.defaultValue()).append("|");
                    if (this.needsLangSupport(module, (String)subK) && descriptions.length > 1) {
                        sb.append(descriptions[1]);
                    }
                    sb.append("|\n");
                });
                System.out.println(sb);
            });
        }
    }
}

