/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.extensions.CustomCommandFactory;
import org.apache.pulsar.admin.cli.utils.CustomCommandFactoryDefinition;
import org.apache.pulsar.admin.cli.utils.CustomCommandFactoryDefinitions;
import org.apache.pulsar.admin.cli.utils.CustomCommandFactoryMetaData;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCommandFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(CustomCommandFactoryProvider.class);
    @VisibleForTesting
    static final String COMMAND_FACTORY_ENTRY = "command_factory";

    public static List<CustomCommandFactory> createCustomCommandFactories(Properties conf) throws IOException {
        String names = conf.getProperty("customCommandFactories", "");
        ArrayList<CustomCommandFactory> result = new ArrayList<CustomCommandFactory>();
        if (names.isEmpty()) {
            return result;
        }
        String directory = conf.getProperty("cliExtensionsDirectory", "cliextensions");
        String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
        CustomCommandFactoryDefinitions definitions = CustomCommandFactoryProvider.searchForCustomCommandFactories(directory, narExtractionDirectory);
        for (String name : names.split(",")) {
            CustomCommandFactoryMetaData metaData = definitions.getFactories().get(name);
            if (null == metaData) {
                throw new RuntimeException("No factory is found for name `" + name + "`. Available names are : " + String.valueOf(definitions.getFactories()));
            }
            CustomCommandFactory factory = CustomCommandFactoryProvider.load(metaData, narExtractionDirectory);
            if (factory != null) {
                result.add(factory);
            }
            log.debug("Successfully loaded command factory for name `{}`", (Object)name);
        }
        return result;
    }

    private static CustomCommandFactoryDefinitions searchForCustomCommandFactories(String directory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(directory, new String[0]).toAbsolutePath();
        log.debug("Searching for command factories  in {}", (Object)path);
        CustomCommandFactoryDefinitions customCommandFactoryDefinitions = new CustomCommandFactoryDefinitions();
        if (!path.toFile().exists()) {
            log.error("Pulsar command factories directory not found");
            return customCommandFactoryDefinitions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    CustomCommandFactoryDefinition def = CustomCommandFactoryProvider.getCustomCommandFactoryDefinition(archive.toString(), narExtractionDirectory);
                    log.debug("Found command factory from {} : {}", (Object)archive, (Object)def);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)def.getName()));
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)def.getFactoryClass()));
                    CustomCommandFactoryMetaData metadata = new CustomCommandFactoryMetaData();
                    metadata.setDefinition(def);
                    metadata.setArchivePath(archive);
                    customCommandFactoryDefinitions.getFactories().put(def.getName(), metadata);
                }
                catch (Throwable t) {
                    log.warn("Failed to load command factories from {}. It is OK however if you want to use this command factory, please make sure you put the correct NAR package in the directory.", (Object)archive, (Object)t);
                }
            }
        }
        return customCommandFactoryDefinitions;
    }

    private static CustomCommandFactoryDefinition getCustomCommandFactoryDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(narPath)).extractionDirectory(narExtractionDirectory).build();){
            CustomCommandFactoryDefinition customCommandFactoryDefinition = CustomCommandFactoryProvider.getCustomCommandFactoryDefinition(ncl);
            return customCommandFactoryDefinition;
        }
    }

    @VisibleForTesting
    static CustomCommandFactoryDefinition getCustomCommandFactoryDefinition(NarClassLoader ncl) throws IOException {
        String configStr;
        try {
            configStr = ncl.getServiceDefinition("command_factory.yaml");
        }
        catch (NoSuchFileException e) {
            configStr = ncl.getServiceDefinition("command_factory.yml");
        }
        return (CustomCommandFactoryDefinition)ObjectMapperFactory.getYamlMapper().reader().readValue(configStr, CustomCommandFactoryDefinition.class);
    }

    private static CustomCommandFactory load(CustomCommandFactoryMetaData metadata, String narExtractionDirectory) throws IOException {
        File narFile = metadata.getArchivePath().toAbsolutePath().toFile();
        NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(narFile).parentClassLoader(CustomCommandFactory.class.getClassLoader()).extractionDirectory(narExtractionDirectory).build();
        CustomCommandFactoryDefinition def = CustomCommandFactoryProvider.getCustomCommandFactoryDefinition(ncl);
        if (StringUtils.isBlank((CharSequence)def.getFactoryClass())) {
            throw new IOException("Command Factory `" + def.getName() + "` does NOT provide a Command Factory implementation");
        }
        try {
            Class commandFactoryClass = ncl.loadClass(def.getFactoryClass());
            Object factory = commandFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(factory instanceof CustomCommandFactory)) {
                throw new IOException("Class " + def.getFactoryClass() + " does not implement CustomCommandFactory interface");
            }
            return (CustomCommandFactory)factory;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            log.error("Failed to load class {}", (Object)def.getFactoryClass(), (Object)e);
            throw new IOException(e);
        }
    }
}

