/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.Packages;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about packages"})
class CmdPackages
extends CmdBase {
    private Packages packages;

    public CmdPackages(Supplier<PulsarAdmin> admin) {
        super("packages", admin);
        this.addCommand("get-metadata", new GetMetadataCmd());
        this.addCommand("update-metadata", new UpdateMetadataCmd());
        this.addCommand("upload", new UploadCmd());
        this.addCommand("download", new DownloadCmd());
        this.addCommand("list", new ListPackagesCmd());
        this.addCommand("list-versions", new ListPackageVersionsCmd());
        this.addCommand("delete", new DeletePackageCmd());
    }

    private Packages getPackages() {
        if (this.packages == null) {
            this.packages = this.getAdmin().packages();
        }
        return this.packages;
    }

    @CommandLine.Command(description={"Get a package metadata information."})
    private class GetMetadataCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"type://tenant/namespace/packageName@version"}, arity="1")
        private String packageName;

        private GetMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdPackages.this.getPackages().getMetadata(this.packageName));
        }
    }

    @CommandLine.Command(description={"Update a package metadata information."})
    private class UpdateMetadataCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"type://tenant/namespace/packageName@version"}, arity="1")
        private String packageName;
        @CommandLine.Option(names={"-d", "--description"}, description={"descriptions of a package"}, required=true)
        private String description;
        @CommandLine.Option(names={"-c", "--contact"}, description={"contact info of a package"})
        private String contact;
        @CommandLine.Option(names={"--properties", "-P"}, description={"external information of a package"})
        private Map<String, String> properties = new HashMap<String, String>();

        private UpdateMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            CmdPackages.this.getPackages().updateMetadata(this.packageName, PackageMetadata.builder().description(this.description).contact(this.contact).properties(this.properties).build());
            this.print(String.format("The metadata of the package '%s' updated successfully", this.packageName));
        }
    }

    @CommandLine.Command(description={"Upload a package"})
    private class UploadCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"type://tenant/namespace/packageName@version"}, arity="1")
        private String packageName;
        @CommandLine.Option(names={"--description"}, description={"descriptions of a package"}, required=true)
        private String description;
        @CommandLine.Option(names={"--contact"}, description={"contact information of a package"})
        private String contact;
        @CommandLine.Option(names={"--properties", "-P"}, description={"external information of a package"})
        private Map<String, String> properties = new HashMap<String, String>();
        @CommandLine.Option(names={"--path"}, description={"file path of the package"}, required=true)
        private String path;

        private UploadCmd() {
        }

        @Override
        void run() throws Exception {
            PackageMetadata metadata = PackageMetadata.builder().description(this.description).contact(this.contact).properties(this.properties).build();
            CmdPackages.this.getPackages().upload(metadata, this.packageName, this.path);
            this.print(String.format("The package '%s' uploaded from path '%s' successfully", this.packageName, this.path));
        }
    }

    @CommandLine.Command(description={"Download a package"})
    private class DownloadCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"type://tenant/namespace/packageName@version"}, arity="1")
        private String packageName;
        @CommandLine.Option(names={"--path"}, description={"download destiny path of the package"}, required=true)
        private String path;

        private DownloadCmd() {
        }

        @Override
        void run() throws Exception {
            CmdPackages.this.getPackages().download(this.packageName, this.path);
            this.print(String.format("The package '%s' downloaded to path '%s' successfully", this.packageName, this.path));
        }
    }

    @CommandLine.Command(description={"List all packages with given type in the specified namespace"})
    private class ListPackagesCmd
    extends CliCommand {
        @CommandLine.Option(names={"--type"}, description={"type of the package"}, required=true)
        private String type;
        @CommandLine.Parameters(description={"namespace of the package"}, arity="1")
        private String namespace;

        private ListPackagesCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdPackages.this.getPackages().listPackages(this.type, this.namespace));
        }
    }

    @CommandLine.Command(description={"List all versions of the given package"})
    private class ListPackageVersionsCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"the package name you want to query, don't need to specify the package version. type://tenant/namespace/packageName"}, arity="1")
        private String packageName;

        private ListPackageVersionsCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdPackages.this.getPackages().listPackageVersions(this.packageName));
        }
    }

    @CommandLine.Command(description={"Delete a package"})
    private class DeletePackageCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"type://tenant/namespace/packageName@version"}, arity="1")
        private String packageName;

        private DeletePackageCmd() {
        }

        @Override
        void run() throws Exception {
            CmdPackages.this.getPackages().delete(this.packageName);
            this.print(String.format("The package '%s' deleted successfully", this.packageName));
        }
    }
}

