/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.cli.converters.picocli.ByteUnitToLongConverter;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.cli.CmdConsume;
import org.apache.pulsar.client.cli.CmdGenerateDocumentation;
import org.apache.pulsar.client.cli.CmdProduce;
import org.apache.pulsar.client.cli.CmdRead;
import org.apache.pulsar.client.cli.ProxyProtocolConverter;
import org.apache.pulsar.client.cli.PulsarClientPropertiesProvider;
import org.apache.pulsar.client.cli.PulsarVersionProvider;
import org.apache.pulsar.internal.CommandHook;
import org.apache.pulsar.internal.CommanderFactory;
import picocli.CommandLine;

@CommandLine.Command(name="pulsar-client", mixinStandardHelpOptions=true, versionProvider=PulsarVersionProvider.class, scope=CommandLine.ScopeType.INHERIT)
public class PulsarClientTool
implements CommandHook {
    private PulsarClientPropertiesProvider pulsarClientPropertiesProvider;
    @CommandLine.ArgGroup(exclusive=false)
    protected RootParams rootParams = new RootParams();
    boolean tlsAllowInsecureConnection;
    boolean tlsEnableHostnameVerification;
    String tlsKeyFilePath;
    String tlsCertificateFilePath;
    boolean useKeyStoreTls;
    String tlsTrustStoreType;
    String tlsTrustStorePath;
    String tlsTrustStorePassword;
    String tlsKeyStoreType;
    String tlsKeyStorePath;
    String tlsKeyStorePassword;
    protected final CommandLine commander;
    protected CmdProduce produceCommand;
    protected CmdConsume consumeCommand;
    protected CmdRead readCommand;
    CmdGenerateDocumentation generateDocumentation;

    public PulsarClientTool(Properties properties) {
        System.setProperty("picocli.version.name.0", "-v");
        this.commander = CommanderFactory.createRootCommanderWithHook(this, null);
        this.initCommander(properties);
    }

    @Override
    public int preRun() {
        return this.updateConfig();
    }

    protected void initCommander(Properties properties) {
        this.produceCommand = new CmdProduce();
        this.consumeCommand = new CmdConsume();
        this.readCommand = new CmdRead();
        this.generateDocumentation = new CmdGenerateDocumentation();
        this.tlsAllowInsecureConnection = Boolean.parseBoolean(properties.getProperty("tlsAllowInsecureConnection", "false"));
        this.tlsEnableHostnameVerification = Boolean.parseBoolean(properties.getProperty("tlsEnableHostnameVerification", "false"));
        this.useKeyStoreTls = Boolean.parseBoolean(properties.getProperty("useKeyStoreTls", "false"));
        this.tlsTrustStoreType = properties.getProperty("tlsTrustStoreType", "JKS");
        this.tlsTrustStorePath = properties.getProperty("tlsTrustStorePath");
        this.tlsTrustStorePassword = properties.getProperty("tlsTrustStorePassword");
        this.tlsKeyStoreType = properties.getProperty("tlsKeyStoreType", "JKS");
        this.tlsKeyStorePath = properties.getProperty("tlsKeyStorePath");
        this.tlsKeyStorePassword = properties.getProperty("tlsKeyStorePassword");
        this.tlsKeyFilePath = properties.getProperty("tlsKeyFilePath");
        this.tlsCertificateFilePath = properties.getProperty("tlsCertificateFilePath");
        this.pulsarClientPropertiesProvider = PulsarClientPropertiesProvider.create(properties);
        this.commander.setDefaultValueProvider((CommandLine.IDefaultValueProvider)this.pulsarClientPropertiesProvider);
        this.commander.addSubcommand("produce", (Object)this.produceCommand);
        this.commander.addSubcommand("consume", (Object)this.consumeCommand);
        this.commander.addSubcommand("read", (Object)this.readCommand);
        this.commander.addSubcommand("generate_documentation", (Object)this.generateDocumentation);
    }

    protected void addCommand(String name, Object cmd) {
        this.commander.addSubcommand(name, cmd);
    }

    private int updateConfig() throws PulsarClientException.UnsupportedAuthenticationException {
        ClientBuilder clientBuilder = PulsarClient.builder().memoryLimit(this.rootParams.memoryLimit, SizeUnit.BYTES);
        Authentication authentication = null;
        if (StringUtils.isNotBlank((CharSequence)this.rootParams.authPluginClassName)) {
            authentication = AuthenticationFactory.create((String)this.rootParams.authPluginClassName, (String)this.rootParams.authParams);
            clientBuilder.authentication(authentication);
        }
        if (StringUtils.isNotBlank((CharSequence)this.rootParams.listenerName)) {
            clientBuilder.listenerName(this.rootParams.listenerName);
        }
        clientBuilder.allowTlsInsecureConnection(this.tlsAllowInsecureConnection);
        clientBuilder.enableTlsHostnameVerification(this.tlsEnableHostnameVerification);
        clientBuilder.serviceUrl(this.rootParams.serviceURL);
        clientBuilder.tlsTrustCertsFilePath(this.rootParams.tlsTrustCertsFilePath).tlsKeyFilePath(this.tlsKeyFilePath).tlsCertificateFilePath(this.tlsCertificateFilePath);
        clientBuilder.useKeyStoreTls(this.useKeyStoreTls).tlsTrustStoreType(this.tlsTrustStoreType).tlsTrustStorePath(this.tlsTrustStorePath).tlsTrustStorePassword(this.tlsTrustStorePassword).tlsKeyStoreType(this.tlsKeyStoreType).tlsKeyStorePath(this.tlsKeyStorePath).tlsKeyStorePassword(this.tlsKeyStorePassword);
        if (StringUtils.isNotBlank((CharSequence)this.rootParams.proxyServiceURL)) {
            if (this.rootParams.proxyProtocol == null) {
                this.commander.getErr().println("proxy-protocol must be provided with proxy-url");
                return 1;
            }
            clientBuilder.proxyServiceUrl(this.rootParams.proxyServiceURL, this.rootParams.proxyProtocol);
        }
        this.produceCommand.updateConfig(clientBuilder, authentication, this.rootParams.serviceURL);
        this.consumeCommand.updateConfig(clientBuilder, authentication, this.rootParams.serviceURL);
        this.readCommand.updateConfig(clientBuilder, authentication, this.rootParams.serviceURL);
        return 0;
    }

    public int run(String[] args) {
        return this.commander.execute(args);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: pulsar-client CONF_FILE_PATH [options] [command] [command options]");
            System.exit(1);
        }
        String configFile = args[0];
        Properties properties = new Properties();
        if (configFile != null) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                properties.load(fis);
            }
        }
        PulsarClientTool clientTool = new PulsarClientTool(properties);
        int exitCode = clientTool.run(Arrays.copyOfRange(args, 1, args.length));
        System.exit(exitCode);
    }

    @VisibleForTesting
    public void replaceProducerCommand(CmdProduce object) {
        this.produceCommand = object;
        if (this.commander.getSubcommands().containsKey("produce")) {
            this.commander.getCommandSpec().removeSubcommand("produce");
        }
        this.commander.addSubcommand("produce", (Object)this.produceCommand);
    }

    @VisibleForTesting
    CommandLine getCommander() {
        return this.commander;
    }

    protected void setCommandName(String name) {
        this.commander.setCommandName(name);
    }

    protected String getServiceUrl() {
        return this.pulsarClientPropertiesProvider.getServiceUrl();
    }

    @CommandLine.Command(description={"Produce or consume messages on a specified topic"})
    public static class RootParams {
        @CommandLine.Option(names={"--url"}, descriptionKey="brokerServiceUrl", description={"Broker URL to which to connect."})
        String serviceURL = null;
        @CommandLine.Option(names={"--proxy-url"}, descriptionKey="proxyServiceUrl", description={"Proxy-server URL to which to connect."})
        String proxyServiceURL = null;
        @CommandLine.Option(names={"--proxy-protocol"}, descriptionKey="proxyProtocol", description={"Proxy protocol to select type of routing at proxy."}, converter={ProxyProtocolConverter.class})
        ProxyProtocol proxyProtocol = null;
        @CommandLine.Option(names={"--auth-plugin"}, descriptionKey="authPlugin", description={"Authentication plugin class name."})
        String authPluginClassName = null;
        @CommandLine.Option(names={"--listener-name"}, description={"Listener name for the broker."})
        String listenerName = null;
        @CommandLine.Option(names={"--auth-params"}, descriptionKey="authParams", description={"Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}\"."})
        String authParams = null;
        @CommandLine.Option(names={"--tlsTrustCertsFilePath"}, descriptionKey="tlsTrustCertsFilePath", description={"File path to client trust certificates"})
        String tlsTrustCertsFilePath;
        @CommandLine.Option(names={"-ml", "--memory-limit"}, description={"Configure the Pulsar client memory limit (eg: 32M, 64M)"}, descriptionKey="memoryLimit", converter={ByteUnitToLongConverter.class})
        long memoryLimit = 0L;

        public String getServiceURL() {
            return this.serviceURL;
        }

        public String getProxyServiceURL() {
            return this.proxyServiceURL;
        }

        public ProxyProtocol getProxyProtocol() {
            return this.proxyProtocol;
        }

        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public String getAuthParams() {
            return this.authParams;
        }

        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        public long getMemoryLimit() {
            return this.memoryLimit;
        }
    }
}

