/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Map;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationUtil;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public final class AuthenticationFactory {
    public static final Authentication create(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            if (StringUtils.isNotBlank(authPluginClassName)) {
                Class<?> authClass = Class.forName(authPluginClassName);
                Authentication auth = (Authentication)authClass.newInstance();
                if (auth instanceof EncodedAuthenticationParameterSupport) {
                    ((EncodedAuthenticationParameterSupport)((Object)auth)).configure(authParamsString);
                } else {
                    auth.configure(AuthenticationUtil.configureFromPulsar1AuthParamString(authParamsString));
                }
                return auth;
            }
            return new AuthenticationDisabled();
        }
        catch (Throwable t) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t);
        }
    }

    public static final Authentication create(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            if (StringUtils.isNotBlank(authPluginClassName)) {
                Class<?> authClass = Class.forName(authPluginClassName);
                Authentication auth = (Authentication)authClass.newInstance();
                auth.configure(authParams);
                return auth;
            }
            return new AuthenticationDisabled();
        }
        catch (Throwable t) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t);
        }
    }
}

