/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

@Deprecated
public class ConsumerConfiguration
implements Serializable {
    static long minAckTimeoutMillis = 1000L;
    private static final long serialVersionUID = 1L;
    private final ConsumerConfigurationData<byte[]> conf = new ConsumerConfigurationData();
    private boolean initializeSubscriptionOnLatest = true;

    public ConsumerConfiguration() {
        this.conf.setAcknowledgementsGroupTimeMicros(0L);
    }

    public long getAckTimeoutMillis() {
        return this.conf.getAckTimeoutMillis();
    }

    public ConsumerConfiguration setAckTimeout(long ackTimeout, TimeUnit timeUnit) {
        long ackTimeoutMillis = timeUnit.toMillis(ackTimeout);
        Preconditions.checkArgument(ackTimeoutMillis >= minAckTimeoutMillis, "Ack timeout should be should be greater than " + minAckTimeoutMillis + " ms");
        this.conf.setAckTimeoutMillis(timeUnit.toMillis(ackTimeout));
        return this;
    }

    public SubscriptionType getSubscriptionType() {
        return this.conf.getSubscriptionType();
    }

    public ConsumerConfiguration setSubscriptionType(SubscriptionType subscriptionType) {
        Preconditions.checkNotNull(subscriptionType);
        this.conf.setSubscriptionType(subscriptionType);
        return this;
    }

    public MessageListener<byte[]> getMessageListener() {
        return this.conf.getMessageListener();
    }

    public ConsumerConfiguration setMessageListener(MessageListener<byte[]> messageListener) {
        Preconditions.checkNotNull(messageListener);
        this.conf.setMessageListener(messageListener);
        return this;
    }

    public ConsumerEventListener getConsumerEventListener() {
        return this.conf.getConsumerEventListener();
    }

    public ConsumerConfiguration setConsumerEventListener(ConsumerEventListener listener) {
        Preconditions.checkNotNull(listener);
        this.conf.setConsumerEventListener(listener);
        return this;
    }

    public int getReceiverQueueSize() {
        return this.conf.getReceiverQueueSize();
    }

    public int getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.conf.getMaxTotalReceiverQueueSizeAcrossPartitions();
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        Preconditions.checkArgument(maxTotalReceiverQueueSizeAcrossPartitions >= this.conf.getReceiverQueueSize());
        this.conf.setMaxTotalReceiverQueueSizeAcrossPartitions(maxTotalReceiverQueueSizeAcrossPartitions);
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.conf.getCryptoKeyReader();
    }

    public ConsumerConfiguration setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        Preconditions.checkNotNull(cryptoKeyReader);
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.conf.setCryptoFailureAction(action);
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.conf.getCryptoFailureAction();
    }

    public ConsumerConfiguration setReceiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument(receiverQueueSize >= 0, "Receiver queue size cannot be negative");
        this.conf.setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    public String getConsumerName() {
        return this.conf.getConsumerName();
    }

    public ConsumerConfiguration setConsumerName(String consumerName) {
        Preconditions.checkArgument(consumerName != null && !consumerName.equals(""));
        this.conf.setConsumerName(consumerName);
        return this;
    }

    public int getPriorityLevel() {
        return this.conf.getPriorityLevel();
    }

    public void setPriorityLevel(int priorityLevel) {
        this.conf.setPriorityLevel(priorityLevel);
    }

    public boolean getReadCompacted() {
        return this.conf.isReadCompacted();
    }

    public ConsumerConfiguration setReadCompacted(boolean readCompacted) {
        this.conf.setReadCompacted(readCompacted);
        return this;
    }

    public ConsumerConfiguration setProperty(String key, String value) {
        Preconditions.checkArgument(key != null);
        Preconditions.checkArgument(value != null);
        this.conf.getProperties().put(key, value);
        return this;
    }

    public ConsumerConfiguration setProperties(Map<String, String> properties) {
        this.conf.getProperties().putAll(properties);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.conf.getProperties();
    }

    public ConsumerConfigurationData<byte[]> getConfigurationData() {
        return this.conf;
    }

    public ConsumerConfiguration setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.conf.setSubscriptionInitialPosition(subscriptionInitialPosition);
        return this;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.conf.getSubscriptionInitialPosition();
    }
}

