/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageRecordImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;

public class TopicMessageImpl<T>
extends MessageRecordImpl<T, TopicMessageIdImpl> {
    private final String topicName;
    private final Message<T> msg;

    TopicMessageImpl(String topicName, Message<T> msg) {
        this.topicName = topicName;
        this.msg = msg;
        this.messageId = new TopicMessageIdImpl(topicName, msg.getMessageId());
    }

    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageId getInnerMessageId() {
        return ((TopicMessageIdImpl)this.messageId).getInnerMessageId();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.msg.getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.msg.hasProperty(name);
    }

    @Override
    public String getProperty(String name) {
        return this.msg.getProperty(name);
    }

    @Override
    public byte[] getData() {
        return this.msg.getData();
    }

    @Override
    public long getPublishTime() {
        return this.msg.getPublishTime();
    }

    @Override
    public long getEventTime() {
        return this.msg.getEventTime();
    }

    @Override
    public long getSequenceId() {
        return this.msg.getSequenceId();
    }

    @Override
    public String getProducerName() {
        return this.msg.getProducerName();
    }

    @Override
    public boolean hasKey() {
        return this.msg.hasKey();
    }

    @Override
    public String getKey() {
        return this.msg.getKey();
    }

    @Override
    public T getValue() {
        return this.msg.getValue();
    }
}

