/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SecurityUtility;

public class AuthenticationDataTls
implements AuthenticationDataProvider {
    protected final X509Certificate[] certificates;
    protected final PrivateKey privateKey;

    public AuthenticationDataTls(String certFilePath, String keyFilePath) throws KeyManagementException {
        if (certFilePath == null) {
            throw new IllegalArgumentException("certFilePath must not be null");
        }
        if (keyFilePath == null) {
            throw new IllegalArgumentException("keyFilePath must not be null");
        }
        this.certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        this.privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
    }

    @Override
    public boolean hasDataForTls() {
        return true;
    }

    public X509Certificate[] getTlsCertificates() {
        return this.certificates;
    }

    @Override
    public PrivateKey getTlsPrivateKey() {
        return this.privateKey;
    }
}

