/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class StringSchema
implements Schema<String> {
    private final Charset charset;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public StringSchema() {
        this.charset = DEFAULT_CHARSET;
    }

    public StringSchema(Charset charset) {
        this.charset = charset;
    }

    @Override
    public byte[] encode(String message) {
        return message.getBytes(this.charset);
    }

    @Override
    public String decode(byte[] bytes) {
        return new String(bytes, this.charset);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setName("String");
        schemaInfo.setType(SchemaType.STRING);
        schemaInfo.setSchema(new byte[0]);
        return schemaInfo;
    }
}

