/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.scurrilous.circe.crc;

import org.apache.pulsar.shade.com.scurrilous.circe.crc.AbstractLongCrc;

final class ReflectedLongCrc
extends AbstractLongCrc {
    private final long[] table = new long[256];

    ReflectedLongCrc(String algorithm, int width, long poly, long init, long xorOut) {
        super(algorithm, width, init, xorOut);
        poly = this.reflect(poly);
        for (int i = 0; i < 256; ++i) {
            long crc = i;
            for (int j = 0; j < 8; ++j) {
                crc = (crc & 1L) != 0L ? crc >>> 1 ^ poly : crc >>> 1;
            }
            this.table[i] = crc;
        }
    }

    @Override
    protected long initial() {
        return this.reflect(super.initial());
    }

    @Override
    protected long resumeRaw(long crc, byte[] input, int index, int length) {
        for (int i = 0; i < length; ++i) {
            crc = this.table[(int)(crc ^ (long)input[index + i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }
}

