/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.compression;

import java.util.EnumMap;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodecLZ4;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodecNone;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodecZLib;

public class CompressionCodecProvider {
    private static final EnumMap<PulsarApi.CompressionType, Class<? extends CompressionCodec>> codecs;
    private static final CompressionCodec compressionCodecNone;
    private final EnumMap<PulsarApi.CompressionType, CompressionCodec> codecInstances = new EnumMap(PulsarApi.CompressionType.class);

    public static CompressionCodec getCompressionCodec(PulsarApi.CompressionType type) {
        if (type == PulsarApi.CompressionType.NONE) {
            return compressionCodecNone;
        }
        try {
            return codecs.get(type).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompressionCodecProvider() {
        try {
            for (PulsarApi.CompressionType type : PulsarApi.CompressionType.values()) {
                this.codecInstances.put(type, codecs.get(type).newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompressionCodec getCodec(PulsarApi.CompressionType type) {
        return this.codecInstances.get(type);
    }

    static {
        compressionCodecNone = new CompressionCodecNone();
        codecs = new EnumMap(PulsarApi.CompressionType.class);
        codecs.put(PulsarApi.CompressionType.NONE, CompressionCodecNone.class);
        codecs.put(PulsarApi.CompressionType.LZ4, CompressionCodecLZ4.class);
        codecs.put(PulsarApi.CompressionType.ZLIB, CompressionCodecZLib.class);
    }
}

