/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.naming;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;

public class NamespaceName
implements ServiceUnitId {
    private final String namespace;
    private final String tenant;
    private final String cluster;
    private final String localName;
    private static final LoadingCache<String, NamespaceName> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<String, NamespaceName>(){

        @Override
        public NamespaceName load(String name) throws Exception {
            return new NamespaceName(name);
        }
    });

    public static NamespaceName get(String tenant, String namespace) {
        NamespaceName.validateNamespaceName(tenant, namespace);
        return NamespaceName.get(tenant + '/' + namespace);
    }

    public static NamespaceName get(String tenant, String cluster, String namespace) {
        NamespaceName.validateNamespaceName(tenant, cluster, namespace);
        return NamespaceName.get(tenant + '/' + cluster + '/' + namespace);
    }

    public static NamespaceName get(String namespace) {
        try {
            Preconditions.checkNotNull(namespace);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid null namespace: " + namespace);
        }
        try {
            return cache.get(namespace);
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
        catch (UncheckedExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private NamespaceName(String namespace) {
        block5: {
            if (namespace == null || namespace.isEmpty()) {
                throw new IllegalArgumentException("Invalid null namespace: " + namespace);
            }
            try {
                String[] parts = namespace.split("/");
                if (parts.length == 2) {
                    NamespaceName.validateNamespaceName(parts[0], parts[1]);
                    this.tenant = parts[0];
                    this.cluster = null;
                    this.localName = parts[1];
                    break block5;
                }
                if (parts.length == 3) {
                    NamespaceName.validateNamespaceName(parts[0], parts[1], parts[2]);
                    this.tenant = parts[0];
                    this.cluster = parts[1];
                    this.localName = parts[2];
                    break block5;
                }
                throw new IllegalArgumentException("Invalid namespace format. namespace: " + namespace);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Invalid namespace format. namespace: " + namespace, e);
            }
        }
        this.namespace = namespace;
    }

    public String getTenant() {
        return this.tenant;
    }

    @Deprecated
    public String getCluster() {
        return this.cluster;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isGlobal() {
        return this.cluster == null || "global".equalsIgnoreCase(this.cluster);
    }

    public String getPersistentTopicName(String localTopic) {
        return this.getTopicName(TopicDomain.persistent, localTopic);
    }

    String getTopicName(TopicDomain domain, String topic) {
        try {
            Preconditions.checkNotNull(domain);
            NamedEntity.checkName(topic);
            return String.format("%s://%s/%s", domain.toString(), this.namespace, topic);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Null pointer is invalid as domain for topic.", e);
        }
    }

    @Override
    public String toString() {
        return this.namespace;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceName) {
            NamespaceName other = (NamespaceName)obj;
            return Objects.equal(this.namespace, other.namespace);
        }
        return false;
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public static void validateNamespaceName(String tenant, String namespace) {
        try {
            Preconditions.checkNotNull(tenant);
            Preconditions.checkNotNull(namespace);
            if (tenant.isEmpty() || namespace.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s", tenant, namespace));
            }
            NamedEntity.checkName(tenant);
            NamedEntity.checkName(namespace);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s/%s", tenant, namespace), e);
        }
    }

    public static void validateNamespaceName(String tenant, String cluster, String namespace) {
        try {
            Preconditions.checkNotNull(tenant);
            Preconditions.checkNotNull(cluster);
            Preconditions.checkNotNull(namespace);
            if (tenant.isEmpty() || cluster.isEmpty() || namespace.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s/%s", tenant, cluster, namespace));
            }
            NamedEntity.checkName(tenant);
            NamedEntity.checkName(cluster);
            NamedEntity.checkName(namespace);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(String.format("Invalid namespace format. namespace: %s/%s/%s", tenant, cluster, namespace), e);
        }
    }

    @Override
    public NamespaceName getNamespaceObject() {
        return this;
    }

    @Override
    public boolean includes(TopicName topicName) {
        return this.equals(topicName.getNamespaceObject());
    }

    public boolean isV2() {
        return this.cluster == null;
    }
}

