/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.NamespaceBundleStatsComparator;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;

@JsonDeserialize(as=LoadReport.class)
public class LoadReport
implements LoadManagerReport {
    private String name;
    private String brokerVersionString;
    private final String webServiceUrl;
    private final String webServiceUrlTls;
    private final String pulsarServiceUrl;
    private final String pulsarServiceUrlTls;
    private boolean persistentTopicsEnabled = true;
    private boolean nonPersistentTopicsEnabled = true;
    private boolean isUnderLoaded;
    private boolean isOverLoaded;
    private long timestamp;
    private double msgRateIn;
    private double msgRateOut;
    private int numTopics;
    private int numConsumers;
    private int numProducers;
    private int numBundles;
    public static final String loadReportType = LoadReport.class.getSimpleName();
    private SystemResourceUsage systemResourceUsage;
    private Map<String, NamespaceBundleStats> bundleStats;
    private Set<String> bundleGains;
    private Set<String> bundleLosses;
    private double allocatedCPU;
    private double allocatedMemory;
    private double allocatedBandwidthIn;
    private double allocatedBandwidthOut;
    private double allocatedMsgRateIn;
    private double allocatedMsgRateOut;
    private double preAllocatedCPU;
    private double preAllocatedMemory;
    private double preAllocatedBandwidthIn;
    private double preAllocatedBandwidthOut;
    private double preAllocatedMsgRateIn;
    private double preAllocatedMsgRateOut;

    public LoadReport() {
        this(null, null, null, null);
    }

    public LoadReport(String webServiceUrl, String webServiceUrlTls, String pulsarServiceUrl, String pulsarServiceUrlTls) {
        this.webServiceUrl = webServiceUrl;
        this.webServiceUrlTls = webServiceUrlTls;
        this.pulsarServiceUrl = pulsarServiceUrl;
        this.pulsarServiceUrlTls = pulsarServiceUrlTls;
        this.bundleLosses = new HashSet<String>();
        this.bundleGains = new HashSet<String>();
        this.isUnderLoaded = false;
        this.isOverLoaded = false;
        this.timestamp = 0L;
        this.msgRateIn = 0.0;
        this.msgRateOut = 0.0;
        this.numTopics = 0;
        this.numConsumers = 0;
        this.numProducers = 0;
        this.numBundles = 0;
    }

    public void setBundleStats(Map<String, NamespaceBundleStats> stats) {
        this.bundleStats = stats == null ? null : new HashMap<String, NamespaceBundleStats>(stats);
    }

    @Override
    public Map<String, NamespaceBundleStats> getBundleStats() {
        return this.bundleStats;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String brokerName) {
        this.name = brokerName;
    }

    public SystemResourceUsage getSystemResourceUsage() {
        return this.systemResourceUsage;
    }

    public void setSystemResourceUsage(SystemResourceUsage systemResourceUsage) {
        this.systemResourceUsage = systemResourceUsage;
    }

    public boolean isUnderLoaded() {
        return this.isUnderLoaded;
    }

    public void setUnderLoaded(boolean isUnderLoaded) {
        this.isUnderLoaded = isUnderLoaded;
    }

    public boolean isOverLoaded() {
        return this.isOverLoaded;
    }

    @JsonIgnore
    public SystemResourceUsage.ResourceType getBottleneckResourceType() {
        SystemResourceUsage.ResourceType type = SystemResourceUsage.ResourceType.CPU;
        double maxUsage = this.systemResourceUsage.cpu.percentUsage();
        if ((double)this.systemResourceUsage.memory.percentUsage() > maxUsage) {
            maxUsage = this.systemResourceUsage.memory.percentUsage();
            type = SystemResourceUsage.ResourceType.Memory;
        }
        if ((double)this.systemResourceUsage.bandwidthIn.percentUsage() > maxUsage) {
            maxUsage = this.systemResourceUsage.bandwidthIn.percentUsage();
            type = SystemResourceUsage.ResourceType.BandwidthIn;
        }
        if ((double)this.systemResourceUsage.bandwidthOut.percentUsage() > maxUsage) {
            maxUsage = this.systemResourceUsage.bandwidthOut.percentUsage();
            type = SystemResourceUsage.ResourceType.BandwidthOut;
        }
        return type;
    }

    public void setOverLoaded(boolean isOverLoaded) {
        this.isOverLoaded = isOverLoaded;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public double getMsgRateIn() {
        this.msgRateIn = 0.0;
        if (this.bundleStats != null) {
            this.bundleStats.forEach((bundle, stats) -> this.msgRateIn += stats.msgRateIn);
        }
        return this.msgRateIn;
    }

    @Override
    public double getMsgRateOut() {
        this.msgRateOut = 0.0;
        if (this.bundleStats != null) {
            this.bundleStats.forEach((bundle, stats) -> this.msgRateOut += stats.msgRateOut);
        }
        return this.msgRateOut;
    }

    public String getLoadReportType() {
        return loadReportType;
    }

    @Override
    public int getNumTopics() {
        this.numTopics = 0;
        if (this.bundleStats != null) {
            this.bundleStats.forEach((bundle, stats) -> {
                this.numTopics = (int)((long)this.numTopics + stats.topics);
            });
        }
        return this.numTopics;
    }

    @Override
    public int getNumConsumers() {
        this.numConsumers = 0;
        if (this.bundleStats != null) {
            for (Map.Entry<String, NamespaceBundleStats> entry : this.bundleStats.entrySet()) {
                this.numConsumers += entry.getValue().consumerCount;
            }
        }
        return this.numConsumers;
    }

    @Override
    public int getNumProducers() {
        this.numProducers = 0;
        if (this.bundleStats != null) {
            for (Map.Entry<String, NamespaceBundleStats> entry : this.bundleStats.entrySet()) {
                this.numProducers += entry.getValue().producerCount;
            }
        }
        return this.numProducers;
    }

    @Override
    public int getNumBundles() {
        this.numBundles = 0;
        if (this.bundleStats != null) {
            this.numBundles = this.bundleStats.size();
        }
        return this.numBundles;
    }

    @JsonIgnore
    public Set<String> getBundles() {
        if (this.bundleStats != null) {
            return new HashSet<String>(this.bundleStats.keySet());
        }
        return new HashSet<String>();
    }

    @JsonIgnore
    public TreeMap<String, NamespaceBundleStats> getSortedBundleStats(SystemResourceUsage.ResourceType resType) {
        if (this.bundleStats == null) {
            return null;
        }
        NamespaceBundleStatsComparator nsc = new NamespaceBundleStatsComparator(this.bundleStats, resType);
        TreeMap<String, NamespaceBundleStats> sortedBundleStats = Maps.newTreeMap(nsc);
        sortedBundleStats.putAll(this.bundleStats);
        return sortedBundleStats;
    }

    public Set<String> getBundleGains() {
        return this.bundleGains;
    }

    public void setBundleGains(Set<String> bundleGains) {
        this.bundleGains = bundleGains;
    }

    public Set<String> getBundleLosses() {
        return this.bundleLosses;
    }

    public void setBundleLosses(Set<String> bundleLosses) {
        this.bundleLosses = bundleLosses;
    }

    public double getAllocatedCPU() {
        return this.allocatedCPU;
    }

    public void setAllocatedCPU(double allocatedCPU) {
        this.allocatedCPU = allocatedCPU;
    }

    public double getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public void setAllocatedMemory(double allocatedMemory) {
        this.allocatedMemory = allocatedMemory;
    }

    public double getAllocatedBandwidthIn() {
        return this.allocatedBandwidthIn;
    }

    public void setAllocatedBandwidthIn(double allocatedBandwidthIn) {
        this.allocatedBandwidthIn = allocatedBandwidthIn;
    }

    public double getAllocatedBandwidthOut() {
        return this.allocatedBandwidthOut;
    }

    public void setAllocatedBandwidthOut(double allocatedBandwidthOut) {
        this.allocatedBandwidthOut = allocatedBandwidthOut;
    }

    public double getAllocatedMsgRateIn() {
        return this.allocatedMsgRateIn;
    }

    public void setAllocatedMsgRateIn(double allocatedMsgRateIn) {
        this.allocatedMsgRateIn = allocatedMsgRateIn;
    }

    public double getAllocatedMsgRateOut() {
        return this.allocatedMsgRateOut;
    }

    public void setAllocatedMsgRateOut(double allocatedMsgRateOut) {
        this.allocatedMsgRateOut = allocatedMsgRateOut;
    }

    public double getPreAllocatedCPU() {
        return this.preAllocatedCPU;
    }

    public void setPreAllocatedCPU(double preAllocatedCPU) {
        this.preAllocatedCPU = preAllocatedCPU;
    }

    public double getPreAllocatedMemory() {
        return this.preAllocatedMemory;
    }

    public void setPreAllocatedMemory(double preAllocatedMemory) {
        this.preAllocatedMemory = preAllocatedMemory;
    }

    public double getPreAllocatedBandwidthIn() {
        return this.preAllocatedBandwidthIn;
    }

    public void setPreAllocatedBandwidthIn(double preAllocatedBandwidthIn) {
        this.preAllocatedBandwidthIn = preAllocatedBandwidthIn;
    }

    public double getPreAllocatedBandwidthOut() {
        return this.preAllocatedBandwidthOut;
    }

    public void setPreAllocatedBandwidthOut(double preAllocatedBandwidthOut) {
        this.preAllocatedBandwidthOut = preAllocatedBandwidthOut;
    }

    public double getPreAllocatedMsgRateIn() {
        return this.preAllocatedMsgRateIn;
    }

    public void setPreAllocatedMsgRateIn(double preAllocatedMsgRateIn) {
        this.preAllocatedMsgRateIn = preAllocatedMsgRateIn;
    }

    public double getPreAllocatedMsgRateOut() {
        return this.preAllocatedMsgRateOut;
    }

    public void setPreAllocatedMsgRateOut(double preAllocatedMsgRateOut) {
        this.preAllocatedMsgRateOut = preAllocatedMsgRateOut;
    }

    public void setBrokerVersionString(String brokerVersionString) {
        this.brokerVersionString = brokerVersionString;
    }

    @Override
    public String getBrokerVersionString() {
        return this.brokerVersionString;
    }

    @Override
    public String getWebServiceUrl() {
        return this.webServiceUrl;
    }

    @Override
    public String getWebServiceUrlTls() {
        return this.webServiceUrlTls;
    }

    @Override
    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    @Override
    public String getPulsarServiceUrlTls() {
        return this.pulsarServiceUrlTls;
    }

    @Override
    public boolean isPersistentTopicsEnabled() {
        return this.persistentTopicsEnabled;
    }

    public void setPersistentTopicsEnabled(boolean persistentTopicsEnabled) {
        this.persistentTopicsEnabled = persistentTopicsEnabled;
    }

    @Override
    public boolean isNonPersistentTopicsEnabled() {
        return this.nonPersistentTopicsEnabled;
    }

    public void setNonPersistentTopicsEnabled(boolean nonPersistentTopicsEnabled) {
        this.nonPersistentTopicsEnabled = nonPersistentTopicsEnabled;
    }

    @Override
    public ResourceUsage getCpu() {
        return this.systemResourceUsage != null ? this.systemResourceUsage.cpu : null;
    }

    @Override
    public ResourceUsage getMemory() {
        return this.systemResourceUsage != null ? this.systemResourceUsage.memory : null;
    }

    @Override
    public ResourceUsage getDirectMemory() {
        return this.systemResourceUsage != null ? this.systemResourceUsage.directMemory : null;
    }

    @Override
    public ResourceUsage getBandwidthIn() {
        return this.systemResourceUsage != null ? this.systemResourceUsage.bandwidthIn : null;
    }

    @Override
    public ResourceUsage getBandwidthOut() {
        return this.systemResourceUsage != null ? this.systemResourceUsage.bandwidthOut : null;
    }

    @Override
    public long getLastUpdate() {
        return this.timestamp;
    }

    @Override
    public double getMsgThroughputIn() {
        return this.msgRateIn;
    }

    @Override
    public double getMsgThroughputOut() {
        return this.msgRateOut;
    }
}

