/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer;

import java.util.Set;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;

public class ResourceUnitRanking
implements Comparable<ResourceUnitRanking> {
    private static final long KBITS_TO_BYTES = 128L;
    private static final double PERCENTAGE_DIFFERENCE_THRESHOLD = 5.0;
    private static double cpuUsageByMsgRate = 0.05;
    private SystemResourceUsage systemResourceUsage;
    private ResourceQuota allocatedQuota;
    private ResourceQuota preAllocatedQuota;
    private Set<String> loadedBundles;
    private Set<String> preAllocatedBundles;
    private double estimatedLoadPercentage;
    private double estimatedMessageRate;
    private double allocatedLoadPercentageCPU;
    private double allocatedLoadPercentageMemory;
    private double allocatedLoadPercentageBandwidthIn;
    private double allocatedLoadPercentageBandwidthOut;
    private double estimatedLoadPercentageCPU;
    private double estimatedLoadPercentageMemory;
    private double estimatedLoadPercentageDirectMemory;
    private double estimatedLoadPercentageBandwidthIn;
    private double estimatedLoadPercentageBandwidthOut;

    public ResourceUnitRanking(SystemResourceUsage systemResourceUsage, Set<String> loadedBundles, ResourceQuota allocatedQuota, Set<String> preAllocatedBundles, ResourceQuota preAllocatedQuota) {
        this.systemResourceUsage = systemResourceUsage;
        this.loadedBundles = loadedBundles;
        this.allocatedQuota = allocatedQuota;
        this.preAllocatedBundles = preAllocatedBundles;
        this.preAllocatedQuota = preAllocatedQuota;
        this.estimateLoadPercentage();
    }

    public static void setCpuUsageByMsgRate(double cpuUsageByMsgRate) {
        ResourceUnitRanking.cpuUsageByMsgRate = cpuUsageByMsgRate;
    }

    private void estimateLoadPercentage() {
        double cpuUsed = this.systemResourceUsage.cpu.usage;
        double cpuAllocated = cpuUsageByMsgRate * (this.allocatedQuota.getMsgRateIn() + this.allocatedQuota.getMsgRateOut());
        double cpuPreAllocated = cpuUsageByMsgRate * (this.preAllocatedQuota.getMsgRateIn() + this.preAllocatedQuota.getMsgRateOut());
        this.allocatedLoadPercentageCPU = this.systemResourceUsage.cpu.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * cpuAllocated / this.systemResourceUsage.cpu.limit);
        this.estimatedLoadPercentageCPU = this.systemResourceUsage.cpu.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * (Math.max(cpuUsed, cpuAllocated) + cpuPreAllocated) / this.systemResourceUsage.cpu.limit);
        double memUsed = this.systemResourceUsage.memory.usage;
        double memAllocated = this.allocatedQuota.getMemory();
        double memPreAllocated = this.preAllocatedQuota.getMemory();
        this.allocatedLoadPercentageMemory = this.systemResourceUsage.memory.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * memAllocated / this.systemResourceUsage.memory.limit);
        this.estimatedLoadPercentageMemory = this.systemResourceUsage.memory.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * (Math.max(memUsed, memAllocated) + memPreAllocated) / this.systemResourceUsage.memory.limit);
        double bandwidthInUsed = this.systemResourceUsage.bandwidthIn.usage;
        double bandwidthInAllocated = this.allocatedQuota.getBandwidthIn() / 128.0;
        double bandwidthInPreAllocated = this.preAllocatedQuota.getBandwidthIn() / 128.0;
        this.allocatedLoadPercentageBandwidthIn = this.systemResourceUsage.bandwidthIn.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * bandwidthInAllocated / this.systemResourceUsage.bandwidthIn.limit);
        this.estimatedLoadPercentageBandwidthIn = this.systemResourceUsage.bandwidthIn.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * (Math.max(bandwidthInUsed, bandwidthInAllocated) + bandwidthInPreAllocated) / this.systemResourceUsage.bandwidthIn.limit);
        double bandwidthOutUsed = this.systemResourceUsage.bandwidthOut.usage;
        double bandwidthOutAllocated = this.allocatedQuota.getBandwidthOut() / 128.0;
        double bandwidthOutPreAllocated = this.preAllocatedQuota.getBandwidthOut() / 128.0;
        this.allocatedLoadPercentageBandwidthOut = this.systemResourceUsage.bandwidthOut.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * bandwidthOutAllocated / this.systemResourceUsage.bandwidthOut.limit);
        this.estimatedLoadPercentageBandwidthOut = this.systemResourceUsage.bandwidthOut.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * (Math.max(bandwidthOutUsed, bandwidthOutAllocated) + bandwidthOutPreAllocated) / this.systemResourceUsage.bandwidthOut.limit);
        double directMemoryUsed = this.systemResourceUsage.directMemory.usage;
        this.estimatedLoadPercentageDirectMemory = this.systemResourceUsage.directMemory.limit <= 0.0 ? 0.0 : Math.min(100.0, 100.0 * directMemoryUsed / this.systemResourceUsage.directMemory.limit);
        this.estimatedLoadPercentage = Math.max(this.estimatedLoadPercentageCPU, Math.max(this.estimatedLoadPercentageMemory, Math.max(this.estimatedLoadPercentageDirectMemory, Math.max(this.estimatedLoadPercentageBandwidthIn, this.estimatedLoadPercentageBandwidthOut))));
        this.estimatedMessageRate = this.allocatedQuota.getMsgRateIn() + this.allocatedQuota.getMsgRateOut() + this.preAllocatedQuota.getMsgRateIn() + this.preAllocatedQuota.getMsgRateOut();
    }

    @Override
    public int compareTo(ResourceUnitRanking other) {
        if (Math.abs(this.estimatedLoadPercentage - other.estimatedLoadPercentage) > 5.0) {
            return Double.compare(this.estimatedLoadPercentage, other.estimatedLoadPercentage);
        }
        if (Math.abs(this.estimatedLoadPercentageMemory - other.estimatedLoadPercentageMemory) > 5.0) {
            return Double.compare(this.estimatedLoadPercentageMemory, other.estimatedLoadPercentageMemory);
        }
        if (Math.abs(this.estimatedLoadPercentageCPU - other.estimatedLoadPercentageCPU) > 5.0) {
            return Double.compare(this.estimatedLoadPercentageCPU, other.estimatedLoadPercentageCPU);
        }
        if (Math.abs(this.estimatedLoadPercentageBandwidthIn - other.estimatedLoadPercentageBandwidthIn) > 5.0) {
            return Double.compare(this.estimatedLoadPercentageBandwidthIn, other.estimatedLoadPercentageBandwidthIn);
        }
        if (Math.abs(this.estimatedLoadPercentageBandwidthOut - other.estimatedLoadPercentageBandwidthOut) > 5.0) {
            return Double.compare(this.estimatedLoadPercentageBandwidthOut, other.estimatedLoadPercentageBandwidthOut);
        }
        return Double.compare(this.estimatedLoadPercentage, other.estimatedLoadPercentage);
    }

    public int compareMessageRateTo(ResourceUnitRanking other) {
        return Double.compare(this.estimatedMessageRate, other.estimatedMessageRate);
    }

    public boolean isIdle() {
        return this.loadedBundles.isEmpty() && this.preAllocatedBundles.isEmpty();
    }

    public boolean isServiceUnitLoaded(String suName) {
        return this.loadedBundles.contains(suName);
    }

    public boolean isServiceUnitPreAllocated(String suName) {
        return this.preAllocatedBundles.contains(suName);
    }

    public void addPreAllocatedServiceUnit(String suName, ResourceQuota quota) {
        this.preAllocatedBundles.add(suName);
        this.preAllocatedQuota.add(quota);
        this.estimateLoadPercentage();
    }

    public void removeLoadedServiceUnit(String suName, ResourceQuota quota) {
        if (this.loadedBundles.remove(suName)) {
            this.allocatedQuota.substract(quota);
            this.estimateLoadPercentage();
        }
    }

    public Set<String> getPreAllocatedBundles() {
        return this.preAllocatedBundles;
    }

    public Set<String> getLoadedBundles() {
        return this.loadedBundles;
    }

    public double getEstimatedLoadPercentage() {
        return this.estimatedLoadPercentage;
    }

    public double getEstimatedMessageRate() {
        return this.estimatedMessageRate;
    }

    public double getAllocatedLoadPercentageCPU() {
        return this.allocatedLoadPercentageCPU;
    }

    public double getAllocatedLoadPercentageMemory() {
        return this.allocatedLoadPercentageMemory;
    }

    public double getAllocatedLoadPercentageBandwidthIn() {
        return this.allocatedLoadPercentageBandwidthIn;
    }

    public double getAllocatedLoadPercentageBandwidthOut() {
        return this.allocatedLoadPercentageBandwidthOut;
    }

    public String getEstimatedLoadPercentageString() {
        return String.format("msgrate: %.0f, load: %.1f%% - cpu: %.1f%%, mem: %.1f%%, directMemory: %.1f%%, bandwidthIn: %.1f%%, bandwidthOut: %.1f%%", this.estimatedMessageRate, this.estimatedLoadPercentage, this.estimatedLoadPercentageCPU, this.estimatedLoadPercentageMemory, this.estimatedLoadPercentageDirectMemory, this.estimatedLoadPercentageBandwidthIn, this.estimatedLoadPercentageBandwidthOut);
    }

    public long estimateMaxCapacity(ResourceQuota defaultQuota) {
        return ResourceUnitRanking.calculateBrokerMaxCapacity(this.systemResourceUsage, defaultQuota);
    }

    public static long calculateBrokerMaxCapacity(SystemResourceUsage systemResourceUsage, ResourceQuota defaultQuota) {
        double bandwidthOutLimit = systemResourceUsage.bandwidthOut.limit * 128.0;
        double bandwidthInLimit = systemResourceUsage.bandwidthIn.limit * 128.0;
        long capacity = ResourceUnitRanking.calculateBrokerCapacity(defaultQuota, systemResourceUsage.cpu.limit, systemResourceUsage.memory.limit, bandwidthOutLimit, bandwidthInLimit);
        return capacity;
    }

    private static long calculateBrokerCapacity(ResourceQuota defaultQuota, double usableCPU, double usableMem, double usableBandwidthOut, double usableBandwidthIn) {
        double cpuCapacity = usableCPU / cpuUsageByMsgRate / (defaultQuota.getMsgRateIn() + defaultQuota.getMsgRateOut());
        double memCapacity = usableMem / defaultQuota.getMemory();
        double bandwidthOutCapacity = usableBandwidthOut / defaultQuota.getBandwidthOut();
        double bandwidthInCapacity = usableBandwidthIn / defaultQuota.getBandwidthIn();
        double capacity = Math.min(cpuCapacity, Math.min(memCapacity, Math.min(bandwidthOutCapacity, bandwidthInCapacity)));
        return (long)Math.max(capacity, 0.0);
    }
}

