/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageRecordImpl;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;

public class MessageImpl<T>
extends MessageRecordImpl<T, MessageId> {
    private PulsarApi.MessageMetadata.Builder msgMetadataBuilder;
    private ClientCnx cnx;
    private ByteBuf payload;
    private Schema<T> schema;
    private transient Map<String, String> properties;
    private Recycler.Handle<MessageImpl<?>> recyclerHandle;
    private static final Recycler<MessageImpl<?>> RECYCLER = new Recycler<MessageImpl<?>>(){

        @Override
        protected MessageImpl<?> newObject(Recycler.Handle<MessageImpl<?>> handle) {
            return new MessageImpl(handle);
        }
    };

    static <T> MessageImpl<T> create(PulsarApi.MessageMetadata.Builder msgMetadataBuilder, ByteBuffer payload, Schema<T> schema) {
        MessageImpl<?> msg = RECYCLER.get();
        msg.msgMetadataBuilder = msgMetadataBuilder;
        msg.messageId = null;
        msg.cnx = null;
        msg.payload = Unpooled.wrappedBuffer(payload);
        msg.properties = null;
        msg.schema = schema;
        return msg;
    }

    static MessageImpl<byte[]> create(PulsarApi.MessageMetadata.Builder msgMetadataBuilder, ByteBuffer payload) {
        MessageImpl<byte[]> msg = RECYCLER.get();
        msg.msgMetadataBuilder = msgMetadataBuilder;
        msg.messageId = null;
        msg.cnx = null;
        msg.payload = Unpooled.wrappedBuffer(payload);
        msg.properties = null;
        msg.schema = Schema.BYTES;
        return msg;
    }

    MessageImpl(MessageIdImpl messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, ClientCnx cnx, Schema<T> schema) {
        this.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder(msgMetadata);
        this.messageId = messageId;
        this.cnx = cnx;
        this.payload = Unpooled.copiedBuffer(payload);
        this.properties = msgMetadata.getPropertiesCount() > 0 ? Collections.unmodifiableMap(this.msgMetadataBuilder.getPropertiesList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue))) : Collections.emptyMap();
        this.schema = schema;
    }

    MessageImpl(BatchMessageIdImpl batchMessageIdImpl, PulsarApi.MessageMetadata msgMetadata, PulsarApi.SingleMessageMetadata singleMessageMetadata, ByteBuf payload, ClientCnx cnx, Schema<T> schema) {
        this.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder(msgMetadata);
        this.messageId = batchMessageIdImpl;
        this.cnx = cnx;
        this.payload = Unpooled.copiedBuffer(payload);
        if (singleMessageMetadata.getPropertiesCount() > 0) {
            TreeMap<String, String> properties = Maps.newTreeMap();
            for (PulsarApi.KeyValue entry : singleMessageMetadata.getPropertiesList()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            this.properties = Collections.unmodifiableMap(properties);
        } else {
            this.properties = Collections.emptyMap();
        }
        if (singleMessageMetadata.hasPartitionKey()) {
            this.msgMetadataBuilder.setPartitionKey(singleMessageMetadata.getPartitionKey());
        }
        if (singleMessageMetadata.hasEventTime()) {
            this.msgMetadataBuilder.setEventTime(singleMessageMetadata.getEventTime());
        }
        this.schema = schema;
    }

    public MessageImpl(String msgId, Map<String, String> properties, byte[] payload, Schema<T> schema) {
        this(msgId, properties, Unpooled.wrappedBuffer(payload), schema);
    }

    public MessageImpl(String msgId, Map<String, String> properties, ByteBuf payload, Schema<T> schema) {
        String[] data = msgId.split(":");
        long ledgerId = Long.parseLong(data[0]);
        long entryId = Long.parseLong(data[1]);
        this.messageId = data.length == 3 ? new BatchMessageIdImpl(ledgerId, entryId, -1, Integer.parseInt(data[2])) : new MessageIdImpl(ledgerId, entryId, -1);
        this.cnx = null;
        this.payload = payload;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public static MessageImpl<byte[]> deserialize(ByteBuf headersAndPayload) throws IOException {
        MessageImpl<byte[]> msg = RECYCLER.get();
        PulsarApi.MessageMetadata msgMetadata = Commands.parseMessageMetadata(headersAndPayload);
        msg.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder(msgMetadata);
        msgMetadata.recycle();
        msg.payload = headersAndPayload;
        msg.messageId = null;
        msg.cnx = null;
        msg.properties = Collections.emptyMap();
        return msg;
    }

    public void setReplicatedFrom(String cluster) {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        this.msgMetadataBuilder.setReplicatedFrom(cluster);
    }

    public boolean isReplicated() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.hasReplicatedFrom();
    }

    public String getReplicatedFrom() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicatedFrom();
    }

    @Override
    public long getPublishTime() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getPublishTime();
    }

    @Override
    public long getEventTime() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasEventTime()) {
            return this.msgMetadataBuilder.getEventTime();
        }
        return 0L;
    }

    public boolean isExpired(int messageTTLInSeconds) {
        return messageTTLInSeconds != 0 && System.currentTimeMillis() > this.getPublishTime() + TimeUnit.SECONDS.toMillis(messageTTLInSeconds);
    }

    @Override
    public byte[] getData() {
        if (this.payload.arrayOffset() == 0 && this.payload.capacity() == this.payload.array().length) {
            return this.payload.array();
        }
        byte[] data = new byte[this.payload.readableBytes()];
        this.payload.readBytes(data);
        return data;
    }

    @Override
    public T getValue() {
        return this.schema.decode(this.getData());
    }

    @Override
    public long getSequenceId() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasSequenceId()) {
            return this.msgMetadataBuilder.getSequenceId();
        }
        return -1L;
    }

    @Override
    public String getProducerName() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasProducerName()) {
            return this.msgMetadataBuilder.getProducerName();
        }
        return null;
    }

    ByteBuf getDataBuffer() {
        return this.payload;
    }

    @Override
    public MessageId getMessageId() {
        Preconditions.checkNotNull(this.messageId, "Cannot get the message id of a message that was not received");
        return this.messageId;
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = this.msgMetadataBuilder.getPropertiesCount() > 0 ? Collections.unmodifiableMap(this.msgMetadataBuilder.getPropertiesList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue))) : Collections.emptyMap();
        }
        return this.properties;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    PulsarApi.MessageMetadata.Builder getMessageBuilder() {
        return this.msgMetadataBuilder;
    }

    @Override
    public boolean hasKey() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.hasPartitionKey();
    }

    @Override
    public String getKey() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getPartitionKey();
    }

    public ClientCnx getCnx() {
        return this.cnx;
    }

    public void recycle() {
        this.msgMetadataBuilder = null;
        this.messageId = null;
        this.payload = null;
        this.properties = null;
        if (this.recyclerHandle != null) {
            this.recyclerHandle.recycle(this);
        }
    }

    private MessageImpl(Recycler.Handle<MessageImpl<?>> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public boolean hasReplicateTo() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicateToCount() > 0;
    }

    public List<String> getReplicateTo() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicateToList();
    }

    void setMessageId(MessageIdImpl messageId) {
        this.messageId = messageId;
    }
}

