/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class UnAckedTopicMessageTracker
extends UnAckedMessageTracker {
    public UnAckedTopicMessageTracker(PulsarClientImpl client, ConsumerBase<?> consumerBase, long ackTimeoutMillis) {
        super(client, consumerBase, ackTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeTopicMessages(String topicName) {
        this.readLock.lock();
        try {
            int currentSetRemovedMsgCount = this.currentSet.removeIf(m -> {
                Preconditions.checkState(m instanceof TopicMessageIdImpl, "message should be of type TopicMessageIdImpl");
                return ((TopicMessageIdImpl)m).getTopicName().contains(topicName);
            });
            int oldSetRemovedMsgCount = this.oldOpenSet.removeIf(m -> {
                Preconditions.checkState(m instanceof TopicMessageIdImpl, "message should be of type TopicMessageIdImpl");
                return ((TopicMessageIdImpl)m).getTopicName().contains(topicName);
            });
            int n = currentSetRemovedMsgCount + oldSetRemovedMsgCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

