/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.pulsar.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.HeapArrayOfDoublesSketchIterator;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.SerializerDeserializer;
import org.apache.pulsar.shade.com.yahoo.sketches.tuple.Util;

final class HeapArrayOfDoublesCompactSketch
extends ArrayOfDoublesCompactSketch {
    private final short seedHash_;
    private long[] keys_;
    private double[] values_;

    HeapArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch) {
        super(sketch.getNumValues());
        this.isEmpty_ = sketch.isEmpty();
        this.theta_ = sketch.getThetaLong();
        this.seedHash_ = Util.computeSeedHash(sketch.getSeed());
        int count = sketch.getRetainedEntries();
        if (count > 0) {
            this.keys_ = new long[count];
            this.values_ = new double[count * this.numValues_];
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            int i = 0;
            while (it.next()) {
                this.keys_[i] = it.getKey();
                System.arraycopy(it.getValues(), 0, this.values_, i * this.numValues_, this.numValues_);
                ++i;
            }
        }
    }

    HeapArrayOfDoublesCompactSketch(long[] keys, double[] values, long theta, boolean isEmpty, int numValues, short seedHash) {
        super(numValues);
        this.keys_ = keys;
        this.values_ = values;
        this.theta_ = theta;
        this.isEmpty_ = isEmpty;
        this.seedHash_ = seedHash;
    }

    HeapArrayOfDoublesCompactSketch(Memory mem) {
        this(mem, 9001L);
    }

    HeapArrayOfDoublesCompactSketch(Memory mem, long seed) {
        super(mem.getByte(5L));
        this.seedHash_ = mem.getShort(6L);
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(mem.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch);
        byte version = mem.getByte(1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        boolean isBigEndian = mem.isAllBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal()));
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        Util.checkSeedHashes(this.seedHash_, Util.computeSeedHash(seed));
        this.isEmpty_ = mem.isAllBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        this.theta_ = mem.getLong(8L);
        boolean hasEntries = mem.isAllBitsSet(4L, (byte)(1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()));
        if (hasEntries) {
            int count = mem.getInt(16L);
            this.keys_ = new long[count];
            this.values_ = new double[count * this.numValues_];
            mem.getLongArray(24L, this.keys_, 0, count);
            mem.getDoubleArray((long)(24 + 8 * count), this.values_, 0, this.values_.length);
        }
    }

    @Override
    public int getRetainedEntries() {
        return this.keys_ == null ? 0 : this.keys_.length;
    }

    @Override
    public byte[] toByteArray() {
        int count = this.getRetainedEntries();
        int sizeBytes = 16;
        if (count > 0) {
            sizeBytes = 24 + 8 * count + 8 * this.numValues_ * count;
        }
        byte[] bytes = new byte[sizeBytes];
        NativeMemory mem = new NativeMemory(bytes);
        mem.putByte(0L, (byte)1);
        mem.putByte(1L, (byte)1);
        mem.putByte(2L, (byte)Family.TUPLE.getID());
        mem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        mem.putByte(4L, (byte)((isBigEndian ? 1 : 0) << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() | (this.isEmpty() ? 1 : 0) << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() | (count > 0 ? 1 : 0) << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()));
        mem.putByte(5L, (byte)this.numValues_);
        mem.putShort(6L, this.seedHash_);
        mem.putLong(8L, this.theta_);
        if (count > 0) {
            mem.putInt(16L, count);
            mem.putLongArray(24L, this.keys_, 0, count);
            mem.putDoubleArray((long)(24 + 8 * count), this.values_, 0, this.values_.length);
        }
        return bytes;
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            int i = 0;
            for (int j = 0; j < count; ++j) {
                values[i++] = Arrays.copyOfRange(this.values_, j * this.numValues_, (j + 1) * this.numValues_);
            }
        }
        return values;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new HeapArrayOfDoublesSketchIterator(this.keys_, this.values_, this.numValues_);
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }
}

