/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.Body;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.generator.FeedListener;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.generator.UnboundedQueueFeedableBodyGenerator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveStreamsBodyGenerator
implements FeedableBodyGenerator {
    private final Publisher<ByteBuf> publisher;
    private final FeedableBodyGenerator feedableBodyGenerator;
    private volatile FeedListener feedListener;
    private final long contentLength;

    public ReactiveStreamsBodyGenerator(Publisher<ByteBuf> publisher, long contentLength) {
        this.publisher = publisher;
        this.feedableBodyGenerator = new UnboundedQueueFeedableBodyGenerator();
        this.contentLength = contentLength;
    }

    public Publisher<ByteBuf> getPublisher() {
        return this.publisher;
    }

    @Override
    public boolean feed(ByteBuf buffer, boolean isLast) throws Exception {
        return this.feedableBodyGenerator.feed(buffer, isLast);
    }

    @Override
    public void setListener(FeedListener listener) {
        this.feedListener = listener;
        this.feedableBodyGenerator.setListener(listener);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public Body createBody() {
        return new StreamedBody(this.publisher, this.feedableBodyGenerator, this.contentLength);
    }

    private class SimpleSubscriber
    implements Subscriber<ByteBuf> {
        private final Logger LOGGER = LoggerFactory.getLogger(SimpleSubscriber.class);
        private final FeedableBodyGenerator feeder;
        private volatile Subscription subscription;

        public SimpleSubscriber(FeedableBodyGenerator feeder) {
            this.feeder = feeder;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (s == null) {
                throw null;
            }
            if (this.subscription != null) {
                s.cancel();
            } else {
                this.subscription = s;
                this.subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(ByteBuf t) {
            if (t == null) {
                throw null;
            }
            try {
                this.feeder.feed(t, false);
            }
            catch (Exception e) {
                this.LOGGER.error("Exception occurred while processing element in stream.", (Throwable)e);
                this.subscription.cancel();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (t == null) {
                throw null;
            }
            this.LOGGER.debug("Error occurred while consuming body stream.", t);
            FeedListener listener = ReactiveStreamsBodyGenerator.this.feedListener;
            if (listener != null) {
                listener.onError(t);
            }
        }

        @Override
        public void onComplete() {
            try {
                this.feeder.feed(Unpooled.EMPTY_BUFFER, true);
            }
            catch (Exception e) {
                this.LOGGER.info("Ignoring exception occurred while completing stream processing.", (Throwable)e);
                this.subscription.cancel();
            }
        }
    }

    private class StreamedBody
    implements Body {
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private final SimpleSubscriber subscriber;
        private final Body body;
        private final long contentLength;

        public StreamedBody(Publisher<ByteBuf> publisher, FeedableBodyGenerator bodyGenerator, long contentLength) {
            this.body = bodyGenerator.createBody();
            this.subscriber = new SimpleSubscriber(bodyGenerator);
            this.contentLength = contentLength;
        }

        @Override
        public void close() throws IOException {
            this.body.close();
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) throws IOException {
            if (this.initialized.compareAndSet(false, true)) {
                ReactiveStreamsBodyGenerator.this.publisher.subscribe(this.subscriber);
            }
            return this.body.transferTo(target);
        }
    }
}

