/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.Optional;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.com.scurrilous.circe.checksum.Crc32cIntChecksum;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.ReferenceCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageParser {
    private static final Logger log = LoggerFactory.getLogger(MessageParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseMessage(TopicName topicName, long ledgerId, long entryId, ByteBuf headersAndPayload, MessageProcessor processor) throws IOException {
        MessageIdImpl msgId = new MessageIdImpl(ledgerId, entryId, -1);
        PulsarApi.MessageIdData.Builder messageIdBuilder = PulsarApi.MessageIdData.newBuilder();
        messageIdBuilder.setLedgerId(ledgerId);
        messageIdBuilder.setEntryId(entryId);
        PulsarApi.MessageIdData messageId = messageIdBuilder.build();
        PulsarApi.MessageMetadata msgMetadata = null;
        ByteBuf payload = headersAndPayload;
        ReferenceCounted uncompressedPayload = null;
        try {
            if (!MessageParser.verifyChecksum(headersAndPayload, messageId, topicName.toString(), "reader")) {
                return;
            }
            try {
                msgMetadata = Commands.parseMessageMetadata(payload);
            }
            catch (Throwable t) {
                log.warn("[{}] Failed to deserialize metadata for message {} - Ignoring", (Object)topicName, (Object)messageId);
                if (uncompressedPayload != null) {
                    uncompressedPayload.release();
                }
                messageIdBuilder.recycle();
                messageId.recycle();
                msgMetadata.recycle();
                return;
            }
            if (msgMetadata.getEncryptionKeysCount() > 0) {
                throw new IOException("Cannot parse encrypted message " + msgMetadata + " on topic " + topicName);
            }
            uncompressedPayload = MessageParser.uncompressPayloadIfNeeded(messageId, msgMetadata, headersAndPayload, topicName.toString(), "reader");
            if (uncompressedPayload == null) {
                return;
            }
            int numMessages = msgMetadata.getNumMessagesInBatch();
            if (numMessages == 1 && !msgMetadata.hasNumMessagesInBatch()) {
                MessageImpl message = new MessageImpl(msgId, msgMetadata, (ByteBuf)uncompressedPayload, null, null);
                processor.process(msgId, message, (ByteBuf)uncompressedPayload);
                uncompressedPayload.release();
            } else {
                MessageParser.receiveIndividualMessagesFromBatch(msgMetadata, (ByteBuf)uncompressedPayload, messageId, null, -1, processor);
                uncompressedPayload.release();
            }
        }
        finally {
            if (uncompressedPayload != null) {
                uncompressedPayload.release();
            }
            messageIdBuilder.recycle();
            messageId.recycle();
            msgMetadata.recycle();
        }
    }

    public static boolean verifyChecksum(ByteBuf headersAndPayload, PulsarApi.MessageIdData messageId, String topic, String subscription) {
        int computedChecksum;
        int checksum;
        if (Commands.hasChecksum(headersAndPayload) && (checksum = Commands.readChecksum(headersAndPayload)) != (computedChecksum = Crc32cIntChecksum.computeChecksum(headersAndPayload))) {
            log.error("[{}][{}] Checksum mismatch for message at {}:{}. Received checksum: 0x{}, Computed checksum: 0x{}", new Object[]{topic, subscription, messageId.getLedgerId(), messageId.getEntryId(), Long.toHexString(checksum), Integer.toHexString(computedChecksum)});
            return false;
        }
        return true;
    }

    public static ByteBuf uncompressPayloadIfNeeded(PulsarApi.MessageIdData messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, String topic, String subscription) {
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec(msgMetadata.getCompression());
        int uncompressedSize = msgMetadata.getUncompressedSize();
        int payloadSize = payload.readableBytes();
        if (payloadSize > 5232640) {
            log.error("[{}][{}] Got corrupted payload message size {} at {}", new Object[]{topic, subscription, payloadSize, messageId});
            return null;
        }
        try {
            ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
            return uncompressedPayload;
        }
        catch (IOException e) {
            log.error("[{}][{}] Failed to decompress message with {} at {}: {}", new Object[]{topic, subscription, msgMetadata.getCompression(), messageId, e.getMessage(), e});
            return null;
        }
    }

    public static void receiveIndividualMessagesFromBatch(PulsarApi.MessageMetadata msgMetadata, ByteBuf uncompressedPayload, PulsarApi.MessageIdData messageId, ClientCnx cnx, int partitionIndex, MessageProcessor processor) {
        int batchSize = msgMetadata.getNumMessagesInBatch();
        try {
            for (int i = 0; i < batchSize; ++i) {
                PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
                ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch(uncompressedPayload, singleMessageMetadataBuilder, i, batchSize);
                if (singleMessageMetadataBuilder.getCompactedOut()) {
                    singleMessagePayload.release();
                    singleMessageMetadataBuilder.recycle();
                    continue;
                }
                BatchMessageIdImpl batchMessageIdImpl = new BatchMessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), partitionIndex, i, null);
                MessageImpl message = new MessageImpl(batchMessageIdImpl, msgMetadata, singleMessageMetadataBuilder.build(), singleMessagePayload, Optional.empty(), cnx, null);
                processor.process(batchMessageIdImpl, message, singleMessagePayload);
                singleMessagePayload.release();
                singleMessageMetadataBuilder.recycle();
            }
        }
        catch (IOException e) {
            log.warn("Unable to obtain messages in batch", (Throwable)e);
        }
    }

    private MessageParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface MessageProcessor {
        public void process(MessageId var1, Message<?> var2, ByteBuf var3);
    }
}

