/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerStatsRecorder;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.UnAckedTopicMessageTracker;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.util.ConsumerName;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTopicsConsumerImpl<T>
extends ConsumerBase<T> {
    protected NamespaceName namespaceName;
    private final ConcurrentHashMap<String, ConsumerImpl<T>> consumers;
    protected final ConcurrentHashMap<String, Integer> topics;
    private final ConcurrentLinkedQueue<ConsumerImpl<T>> pausedConsumers;
    private final int sharedQueueResumeThreshold;
    AtomicInteger allTopicPartitionsNumber;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConsumerStatsRecorder stats;
    private final UnAckedMessageTracker unAckedMessageTracker;
    private final ConsumerConfigurationData<T> internalConfig;
    private static final Logger log = LoggerFactory.getLogger(MultiTopicsConsumerImpl.class);

    MultiTopicsConsumerImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema) {
        super(client, "TopicsConsumerFakeTopicName" + ConsumerName.generateRandomName(), conf, Math.max(2, conf.getReceiverQueueSize()), listenerExecutor, subscribeFuture, schema);
        Preconditions.checkArgument(conf.getReceiverQueueSize() > 0, "Receiver queue size needs to be greater than 0 for Topics Consumer");
        this.topics = new ConcurrentHashMap();
        this.consumers = new ConcurrentHashMap();
        this.pausedConsumers = new ConcurrentLinkedQueue();
        this.sharedQueueResumeThreshold = this.maxReceiverQueueSize / 2;
        this.allTopicPartitionsNumber = new AtomicInteger(0);
        this.unAckedMessageTracker = conf.getAckTimeoutMillis() != 0L ? new UnAckedTopicMessageTracker(client, this, conf.getAckTimeoutMillis()) : UnAckedMessageTracker.UNACKED_MESSAGE_TRACKER_DISABLED;
        this.internalConfig = this.getInternalConsumerConfig();
        ConsumerStatsRecorder consumerStatsRecorder = this.stats = client.getConfiguration().getStatsIntervalSeconds() > 0L ? new ConsumerStatsRecorderImpl() : null;
        if (conf.getTopicNames().isEmpty()) {
            this.namespaceName = null;
            this.setState(HandlerState.State.Ready);
            this.subscribeFuture().complete(this);
            return;
        }
        Preconditions.checkArgument(conf.getTopicNames().isEmpty() || MultiTopicsConsumerImpl.topicNamesValid(conf.getTopicNames()), "Topics should have same namespace.");
        this.namespaceName = (NamespaceName)conf.getTopicNames().stream().findFirst().flatMap(s -> Optional.of(TopicName.get(s).getNamespaceObject())).get();
        List futures = conf.getTopicNames().stream().map(t -> this.subscribeAsync((String)t)).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futures).thenAccept(finalFuture -> {
            try {
                if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                    this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
                }
                this.setState(HandlerState.State.Ready);
                this.startReceivingMessages(this.consumers.values().stream().collect(Collectors.toList()));
                this.subscribeFuture().complete(this);
                log.info("[{}] [{}] Created topics consumer with {} sub-consumers", new Object[]{this.topic, this.subscription, this.allTopicPartitionsNumber.get()});
            }
            catch (PulsarClientException e) {
                log.warn("[{}] Failed startReceivingMessages while subscribe topics: {}", (Object)this.topic, (Object)e.getMessage());
                subscribeFuture.completeExceptionally(e);
            }
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to subscribe topics: {}", (Object)this.topic, (Object)ex.getMessage());
            subscribeFuture.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private static boolean topicNamesValid(Collection<String> topics) {
        Preconditions.checkState(topics != null && topics.size() >= 1, "topics should should contain more than 1 topic");
        String namespace = TopicName.get(topics.stream().findFirst().get()).getNamespace();
        Optional<String> result = topics.stream().filter(topic -> {
            boolean topicInvalid;
            boolean bl = topicInvalid = !TopicName.isValid(topic);
            if (topicInvalid) {
                return true;
            }
            String newNamespace = TopicName.get(topic).getNamespace();
            return !namespace.equals(newNamespace);
        }).findFirst();
        if (result.isPresent()) {
            log.warn("[{}] Received invalid topic name.  {}/{}", (Object)result.get());
            return false;
        }
        HashSet<String> set = new HashSet<String>(topics);
        if (set.size() == topics.size()) {
            return true;
        }
        log.warn("Topic names not unique. unique/all : {}/{}", (Object)set.size(), (Object)topics.size());
        return false;
    }

    private void startReceivingMessages(List<ConsumerImpl<T>> newConsumers) throws PulsarClientException {
        if (log.isDebugEnabled()) {
            log.debug("[{}] startReceivingMessages for {} new consumers in topics consumer, state: {}", new Object[]{this.topic, newConsumers.size(), this.getState()});
        }
        if (this.getState() == HandlerState.State.Ready) {
            newConsumers.forEach(consumer -> {
                consumer.sendFlowPermitsToBroker(consumer.getConnectionHandler().cnx(), this.conf.getReceiverQueueSize());
                this.receiveMessageFromConsumer((ConsumerImpl<T>)consumer);
            });
        }
    }

    private void receiveMessageFromConsumer(ConsumerImpl<T> consumer) {
        consumer.receiveAsync().thenAccept(message -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Receive message from sub consumer:{}", new Object[]{this.topic, this.subscription, consumer.getTopic()});
            }
            this.messageReceived(consumer, (Message<T>)message);
            this.lock.writeLock().lock();
            try {
                int size = this.incomingMessages.size();
                if (size >= this.maxReceiverQueueSize || size > this.sharedQueueResumeThreshold && !this.pausedConsumers.isEmpty()) {
                    this.pausedConsumers.add(consumer);
                } else {
                    this.client.eventLoopGroup().execute(() -> this.receiveMessageFromConsumer(consumer));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(ConsumerImpl<T> consumer, Message<T> message) {
        Preconditions.checkArgument(message instanceof MessageImpl);
        this.lock.writeLock().lock();
        try {
            TopicMessageImpl topicMessage = new TopicMessageImpl(consumer.getTopic(), consumer.getTopicNameWithoutPartition(), message);
            this.unAckedMessageTracker.add(topicMessage.getMessageId());
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Received message from topics-consumer {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
            }
            if (!this.pendingReceives.isEmpty()) {
                CompletableFuture receivedFuture = (CompletableFuture)this.pendingReceives.poll();
                this.listenerExecutor.execute(() -> receivedFuture.complete(topicMessage));
            } else {
                this.incomingMessages.put(topicMessage);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.listener != null) {
            this.listenerExecutor.execute(() -> {
                Message<T> msg;
                try {
                    msg = this.internalReceive();
                }
                catch (PulsarClientException e) {
                    log.warn("[{}] [{}] Failed to dequeue the message for listener", new Object[]{this.topic, this.subscription, e});
                    return;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}][{}] Calling message listener for message {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
                    }
                    this.listener.received(this, msg);
                }
                catch (Throwable t) {
                    log.error("[{}][{}] Message listener error in processing message: {}", new Object[]{this.topic, this.subscription, message, t});
                }
            });
        }
    }

    private void resumeReceivingFromPausedConsumersIfNeeded() {
        block5: {
            this.lock.readLock().lock();
            try {
                ConsumerImpl<T> consumer;
                if (this.incomingMessages.size() > this.sharedQueueResumeThreshold || this.pausedConsumers.isEmpty()) break block5;
                while ((consumer = this.pausedConsumers.poll()) != null) {
                    this.client.eventLoopGroup().execute(() -> this.receiveMessageFromConsumer(consumer));
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    protected Message<T> internalReceive() throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.take();
            Preconditions.checkState(message instanceof TopicMessageImpl);
            this.unAckedMessageTracker.add(message.getMessageId());
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    protected Message<T> internalReceive(int timeout, TimeUnit unit) throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.poll(timeout, unit);
            if (message != null) {
                Preconditions.checkArgument(message instanceof TopicMessageImpl);
                this.unAckedMessageTracker.add(message.getMessageId());
            }
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFuture<Message<Message>> result = new CompletableFuture<Message<Message>>();
        try {
            this.lock.writeLock().lock();
            Message message = (Message)this.incomingMessages.poll(0L, TimeUnit.SECONDS);
            if (message == null) {
                this.pendingReceives.add(result);
            } else {
                Preconditions.checkState(message instanceof TopicMessageImpl);
                this.unAckedMessageTracker.add(message.getMessageId());
                this.resumeReceivingFromPausedConsumersIfNeeded();
                result.complete(message);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(new PulsarClientException(e));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(MessageId messageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties) {
        Preconditions.checkArgument(messageId instanceof TopicMessageIdImpl);
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture(new PulsarClientException("Consumer already closed"));
        }
        if (ackType == PulsarApi.CommandAck.AckType.Cumulative) {
            Consumer individualConsumer = this.consumers.get(topicMessageId.getTopicPartitionName());
            if (individualConsumer != null) {
                MessageId innerId = topicMessageId.getInnerMessageId();
                return individualConsumer.acknowledgeCumulativeAsync(innerId);
            }
            return FutureUtil.failedFuture(new PulsarClientException.NotConnectedException());
        }
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        MessageId innerId = topicMessageId.getInnerMessageId();
        return consumer.doAcknowledge(innerId, ackType, properties).thenRun(() -> this.unAckedMessageTracker.remove(topicMessageId));
    }

    @Override
    public CompletableFuture<Void> unsubscribeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        this.setState(HandlerState.State.Closing);
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(c -> c.unsubscribeAsync()).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                this.setState(HandlerState.State.Closed);
                this.unAckedMessageTracker.close();
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName});
            } else {
                this.setState(HandlerState.State.Failed);
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.unAckedMessageTracker.close();
            return CompletableFuture.completedFuture(null);
        }
        this.setState(HandlerState.State.Closing);
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(c -> c.closeAsync()).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                this.setState(HandlerState.State.Closed);
                this.unAckedMessageTracker.close();
                closeFuture.complete(null);
                log.info("[{}] [{}] Closed Topics Consumer", (Object)this.topic, (Object)this.subscription);
                this.client.cleanupConsumer(this);
                this.failPendingReceive();
            } else {
                this.setState(HandlerState.State.Failed);
                closeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] Could not close Topics Consumer", new Object[]{this.topic, this.subscription, ex.getCause()});
            }
        });
        return closeFuture;
    }

    private void failPendingReceive() {
        this.lock.readLock().lock();
        try {
            if (this.listenerExecutor != null && !this.listenerExecutor.isShutdown()) {
                CompletableFuture receiveFuture;
                while (!this.pendingReceives.isEmpty() && (receiveFuture = (CompletableFuture)this.pendingReceives.poll()) != null) {
                    receiveFuture.completeExceptionally(new PulsarClientException.AlreadyClosedException("Consumer is already closed"));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isConnected() {
        return this.consumers.values().stream().allMatch(consumer -> consumer.isConnected());
    }

    @Override
    String getHandlerName() {
        return this.subscription;
    }

    private ConsumerConfigurationData<T> getInternalConsumerConfig() {
        Object internalConsumerConfig = this.conf.clone();
        ((ConsumerConfigurationData)internalConsumerConfig).setSubscriptionName(this.subscription);
        ((ConsumerConfigurationData)internalConsumerConfig).setConsumerName(this.consumerName);
        return internalConsumerConfig;
    }

    @Override
    public void redeliverUnacknowledgedMessages() {
        this.lock.writeLock().lock();
        try {
            this.consumers.values().stream().forEach(consumer -> consumer.redeliverUnacknowledgedMessages());
            this.incomingMessages.clear();
            this.unAckedMessageTracker.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    @Override
    public void redeliverUnacknowledgedMessages(Set<MessageId> messageIds) {
        Preconditions.checkArgument(messageIds.stream().findFirst().get() instanceof TopicMessageIdImpl);
        if (this.conf.getSubscriptionType() != SubscriptionType.Shared) {
            this.redeliverUnacknowledgedMessages();
            return;
        }
        this.removeExpiredMessagesFromQueue(messageIds);
        messageIds.stream().map(messageId -> (TopicMessageIdImpl)messageId).collect(Collectors.groupingBy(TopicMessageIdImpl::getTopicPartitionName, Collectors.toSet())).forEach((topicName, messageIds1) -> this.consumers.get(topicName).redeliverUnacknowledgedMessages(messageIds1.stream().map(mid -> mid.getInnerMessageId()).collect(Collectors.toSet())));
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    @Override
    public void seek(MessageId messageId) throws PulsarClientException {
        try {
            this.seekAsync(messageId).get();
        }
        catch (ExecutionException e) {
            throw new PulsarClientException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new PulsarClientException(e);
        }
    }

    @Override
    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        return FutureUtil.failedFuture(new PulsarClientException("Seek operation not supported on topics consumer"));
    }

    @Override
    public int getAvailablePermits() {
        return this.consumers.values().stream().mapToInt(ConsumerImpl::getAvailablePermits).sum();
    }

    @Override
    public boolean hasReachedEndOfTopic() {
        return this.consumers.values().stream().allMatch(Consumer::hasReachedEndOfTopic);
    }

    @Override
    public int numMessagesInQueue() {
        return this.incomingMessages.size() + this.consumers.values().stream().mapToInt(ConsumerImpl::numMessagesInQueue).sum();
    }

    @Override
    public synchronized ConsumerStats getStats() {
        if (this.stats == null) {
            return null;
        }
        this.stats.reset();
        this.consumers.values().stream().forEach(consumer -> this.stats.updateCumulativeStats(consumer.getStats()));
        return this.stats;
    }

    public UnAckedMessageTracker getUnAckedMessageTracker() {
        return this.unAckedMessageTracker;
    }

    private void removeExpiredMessagesFromQueue(Set<MessageId> messageIds) {
        Message peek = (Message)this.incomingMessages.peek();
        if (peek != null) {
            if (!messageIds.contains(peek.getMessageId())) {
                return;
            }
            Message message = (Message)this.incomingMessages.poll();
            Preconditions.checkState(message instanceof TopicMessageImpl);
            while (message != null) {
                MessageId messageId = message.getMessageId();
                if (!messageIds.contains(messageId)) {
                    messageIds.add(messageId);
                    break;
                }
                message = (Message)this.incomingMessages.poll();
            }
        }
    }

    private boolean topicNameValid(String topicName) {
        Preconditions.checkArgument(TopicName.isValid(topicName), "Invalid topic name:" + topicName);
        Preconditions.checkArgument(!this.topics.containsKey(topicName), "Topics already contains topic:" + topicName);
        if (this.namespaceName != null) {
            Preconditions.checkArgument(TopicName.get(topicName).getNamespace().toString().equals(this.namespaceName.toString()), "Topic " + topicName + " not in same namespace with Topics");
        }
        return true;
    }

    public CompletableFuture<Void> subscribeAsync(String topicName) {
        if (!this.topicNameValid(topicName)) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        ((CompletableFuture)this.client.getPartitionedTopicMetadata(topicName).thenAccept(metadata -> this.subscribeTopicPartitions(subscribeResult, topicName, metadata.partitions))).exceptionally(ex1 -> {
            log.warn("[{}] Failed to get partitioned topic metadata: {}", (Object)topicName, (Object)ex1.getMessage());
            subscribeResult.completeExceptionally((Throwable)ex1);
            return null;
        });
        return subscribeResult;
    }

    public static <T> MultiTopicsConsumerImpl<T> createPartitionedConsumer(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, CompletableFuture<Consumer<T>> subscribeFuture, int numPartitions, Schema<T> schema) {
        Preconditions.checkArgument(conf.getTopicNames().size() == 1, "Should have only 1 topic for partitioned consumer");
        Object cloneConf = conf.clone();
        String topicName = ((ConsumerConfigurationData)cloneConf).getSingleTopic();
        ((ConsumerConfigurationData)cloneConf).getTopicNames().remove(topicName);
        CompletableFuture<Consumer<T>> future = new CompletableFuture<Consumer<T>>();
        MultiTopicsConsumerImpl consumer = new MultiTopicsConsumerImpl(client, cloneConf, listenerExecutor, future, schema);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(c -> ((MultiTopicsConsumerImpl)c).subscribeAsync(topicName, numPartitions))).thenRun(() -> subscribeFuture.complete(consumer))).exceptionally(e -> {
            log.warn("Failed subscription for createPartitionedConsumer: {} {}, e:{}", new Object[]{topicName, numPartitions, e});
            subscribeFuture.completeExceptionally(((Throwable)e).getCause());
            return null;
        });
        return consumer;
    }

    private CompletableFuture<Void> subscribeAsync(String topicName, int numberPartitions) {
        if (!this.topicNameValid(topicName)) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        this.subscribeTopicPartitions(subscribeResult, topicName, numberPartitions);
        return subscribeResult;
    }

    private void subscribeTopicPartitions(CompletableFuture<Void> subscribeResult, String topicName, int numPartitions) {
        List<CompletableFuture<Object>> futureList;
        if (log.isDebugEnabled()) {
            log.debug("Subscribe to topic {} metadata.partitions: {}", (Object)topicName, (Object)numPartitions);
        }
        if (numPartitions > 1) {
            this.topics.putIfAbsent(topicName, numPartitions);
            this.allTopicPartitionsNumber.addAndGet(numPartitions);
            int receiverQueueSize = Math.min(this.conf.getReceiverQueueSize(), this.conf.getMaxTotalReceiverQueueSizeAcrossPartitions() / numPartitions);
            ConsumerConfigurationData<T> configurationData = this.getInternalConsumerConfig();
            configurationData.setReceiverQueueSize(receiverQueueSize);
            futureList = IntStream.range(0, numPartitions).mapToObj(partitionIndex -> {
                String partitionName = TopicName.get(topicName).getPartition(partitionIndex).toString();
                CompletableFuture subFuture = new CompletableFuture();
                ConsumerImpl newConsumer = new ConsumerImpl(this.client, partitionName, configurationData, this.client.externalExecutorProvider().getExecutor(), partitionIndex, subFuture, this.schema);
                this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
                return subFuture;
            }).collect(Collectors.toList());
        } else {
            this.topics.putIfAbsent(topicName, 1);
            this.allTopicPartitionsNumber.incrementAndGet();
            CompletableFuture subFuture = new CompletableFuture();
            ConsumerImpl<T> newConsumer = new ConsumerImpl<T>(this.client, topicName, this.internalConfig, this.client.externalExecutorProvider().getExecutor(), 0, subFuture, this.schema);
            this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
            futureList = Collections.singletonList(subFuture);
        }
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> {
            try {
                if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                    this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
                }
                int numTopics = this.topics.values().stream().mapToInt(Integer::intValue).sum();
                Preconditions.checkState(this.allTopicPartitionsNumber.get() == numTopics, "allTopicPartitionsNumber " + this.allTopicPartitionsNumber.get() + " not equals expected: " + numTopics);
                this.startReceivingMessages(this.consumers.values().stream().filter(consumer1 -> {
                    String consumerTopicName = consumer1.getTopic();
                    return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(TopicName.get(topicName).getPartitionedTopicName().toString());
                }).collect(Collectors.toList()));
                subscribeResult.complete(null);
                log.info("[{}] [{}] Success subscribe new topic {} in topics consumer, partitions: {}, allTopicPartitionsNumber: {}", new Object[]{this.topic, this.subscription, topicName, numPartitions, this.allTopicPartitionsNumber.get()});
                if (this.namespaceName == null) {
                    this.namespaceName = TopicName.get(topicName).getNamespaceObject();
                }
                return;
            }
            catch (PulsarClientException e) {
                this.handleSubscribeOneTopicError(topicName, e, subscribeResult);
                return;
            }
        })).exceptionally(ex -> {
            this.handleSubscribeOneTopicError(topicName, (Throwable)ex, subscribeResult);
            return null;
        });
    }

    private void handleSubscribeOneTopicError(String topicName, Throwable error, CompletableFuture<Void> subscribeFuture) {
        log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer {}", new Object[]{this.topic, topicName, error.getMessage()});
        this.client.externalExecutorProvider().getExecutor().submit(() -> {
            AtomicInteger toCloseNum = new AtomicInteger(0);
            this.consumers.values().stream().filter(consumer1 -> {
                String consumerTopicName = consumer1.getTopic();
                if (TopicName.get(consumerTopicName).getPartitionedTopicName().equals(topicName)) {
                    toCloseNum.incrementAndGet();
                    return true;
                }
                return false;
            }).collect(Collectors.toList()).forEach(consumer2 -> consumer2.closeAsync().whenComplete((r, ex) -> {
                consumer2.subscribeFuture().completeExceptionally(error);
                this.allTopicPartitionsNumber.decrementAndGet();
                this.consumers.remove(consumer2.getTopic());
                if (toCloseNum.decrementAndGet() == 0) {
                    log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer, subscribe error: {}", new Object[]{this.topic, topicName, error.getMessage()});
                    this.topics.remove(topicName);
                    Preconditions.checkState(this.allTopicPartitionsNumber.get() == this.consumers.values().size());
                    subscribeFuture.completeExceptionally(error);
                }
            }));
        });
    }

    public CompletableFuture<Void> unsubscribeAsync(String topicName) {
        Preconditions.checkArgument(TopicName.isValid(topicName), "Invalid topic name:" + topicName);
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        String topicPartName = TopicName.get(topicName).getPartitionedTopicName();
        List consumersToUnsub = this.consumers.values().stream().filter(consumer -> {
            String consumerTopicName = consumer.getTopic();
            return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(topicPartName);
        }).collect(Collectors.toList());
        List futureList = consumersToUnsub.stream().map(ConsumerImpl::unsubscribeAsync).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                consumersToUnsub.forEach(consumer1 -> {
                    this.consumers.remove(consumer1.getTopic());
                    this.pausedConsumers.remove(consumer1);
                    this.allTopicPartitionsNumber.decrementAndGet();
                });
                this.topics.remove(topicName);
                ((UnAckedTopicMessageTracker)this.unAckedMessageTracker).removeTopicMessages(topicName);
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer, allTopicPartitionsNumber: {}", new Object[]{topicName, this.subscription, this.consumerName, this.allTopicPartitionsNumber});
            } else {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                this.setState(HandlerState.State.Failed);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{topicName, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public List<String> getTopics() {
        return this.topics.keySet().stream().collect(Collectors.toList());
    }

    public List<String> getPartitionedTopics() {
        return this.consumers.keySet().stream().collect(Collectors.toList());
    }

    public List<ConsumerImpl<T>> getConsumers() {
        return this.consumers.values().stream().collect(Collectors.toList());
    }
}

