/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.pulsar.shade.org.apache.commons.beanutils.PropertyUtils;
import org.apache.pulsar.shade.org.apache.commons.collections.Transformer;
import org.apache.pulsar.shade.org.apache.commons.logging.Log;
import org.apache.pulsar.shade.org.apache.commons.logging.LogFactory;

public class BeanToPropertyValueTransformer
implements Transformer {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private boolean ignoreNull;

    public BeanToPropertyValueTransformer(String propertyName) {
        this(propertyName, false);
    }

    public BeanToPropertyValueTransformer(String propertyName, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.ignoreNull = ignoreNull;
    }

    public Object transform(Object object) {
        Object propertyValue = null;
        try {
            propertyValue = PropertyUtils.getProperty(object, this.propertyName);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Problem during transformation. Null value encountered in property path...";
            if (this.ignoreNull) {
                this.log.warn("WARNING: Problem during transformation. Null value encountered in property path...", e);
            }
            this.log.error("ERROR: Problem during transformation. Null value encountered in property path...", e);
            throw e;
        }
        catch (IllegalAccessException e) {
            String errorMsg = "Unable to access the property provided.";
            this.log.error("Unable to access the property provided.", e);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException e) {
            String errorMsg = "Exception occurred in property's getter";
            this.log.error("Exception occurred in property's getter", e);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException e) {
            String errorMsg = "No property found for name [" + this.propertyName + "]";
            this.log.error(errorMsg, e);
            throw new IllegalArgumentException(errorMsg);
        }
        return propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

