/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.handler;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.shade.io.netty.handler.codec.PrematureChannelClosureException;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpContent;
import org.apache.pulsar.shade.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseBodyPart;
import org.apache.pulsar.shade.org.asynchttpclient.exception.ChannelClosedException;
import org.apache.pulsar.shade.org.asynchttpclient.netty.DiscardEvent;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.OnLastHttpContentCallback;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelManager;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.Channels;
import org.apache.pulsar.shade.org.asynchttpclient.netty.future.StackTraceInspector;
import org.apache.pulsar.shade.org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.apache.pulsar.shade.org.asynchttpclient.netty.handler.intercept.Interceptors;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import org.apache.pulsar.shade.org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncHttpClientHandler
extends ChannelInboundHandlerAdapter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AsyncHttpClientConfig config;
    protected final ChannelManager channelManager;
    protected final NettyRequestSender requestSender;
    final Interceptors interceptors;
    final boolean hasIOExceptionFilters;

    AsyncHttpClientHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        this.config = config;
        this.channelManager = channelManager;
        this.requestSender = requestSender;
        this.interceptors = new Interceptors(config, channelManager, requestSender);
        this.hasIOExceptionFilters = !config.getIoExceptionFilters().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        Object attribute = Channels.getAttribute(channel);
        try {
            if (attribute instanceof OnLastHttpContentCallback) {
                if (msg instanceof LastHttpContent) {
                    ((OnLastHttpContentCallback)attribute).call();
                }
            } else if (attribute instanceof NettyResponseFuture) {
                NettyResponseFuture future = (NettyResponseFuture)attribute;
                future.touch();
                this.handleRead(channel, future, msg);
            } else if (attribute instanceof StreamedResponsePublisher) {
                StreamedResponsePublisher publisher = (StreamedResponsePublisher)attribute;
                publisher.future().touch();
                if (msg instanceof HttpContent) {
                    ByteBuf content = ((HttpContent)msg).content();
                    if (content.isReadable()) {
                        HttpResponseBodyPart part = this.config.getResponseBodyPartFactory().newResponseBodyPart(content, false);
                        ctx.fireChannelRead(part);
                    }
                    if (msg instanceof LastHttpContent) {
                        ctx.pipeline().remove(publisher);
                        ctx.read();
                        this.handleRead(channel, publisher.future(), msg);
                    }
                } else {
                    this.logger.info("Received unexpected message while expecting a chunk: " + msg);
                    ctx.pipeline().remove(publisher);
                    Channels.setDiscard(channel);
                }
            } else if (attribute != DiscardEvent.DISCARD) {
                this.logger.debug("Orphan channel {} with attribute {} received message {}, closing", new Object[]{channel, attribute, msg});
                Channels.silentlyCloseChannel(channel);
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.requestSender.isClosed()) {
            return;
        }
        Channel channel = ctx.channel();
        this.channelManager.removeAll(channel);
        NettyResponseFuture<?> attribute = Channels.getAttribute(channel);
        this.logger.debug("Channel Closed: {} with attribute {}", (Object)channel, (Object)attribute);
        if (attribute instanceof StreamedResponsePublisher) {
            attribute = ((StreamedResponsePublisher)((Object)attribute)).future();
        }
        if (attribute instanceof OnLastHttpContentCallback) {
            OnLastHttpContentCallback callback = (OnLastHttpContentCallback)((Object)attribute);
            Channels.setAttribute(channel, callback.future());
            callback.call();
        } else if (attribute instanceof NettyResponseFuture) {
            NettyResponseFuture<?> future = attribute;
            future.touch();
            if (this.hasIOExceptionFilters && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, ChannelClosedException.INSTANCE, channel)) {
                return;
            }
            this.handleChannelInactive(future);
            this.requestSender.handleUnexpectedClosedChannel(channel, future);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        Throwable cause = MiscUtils.getCause(e);
        if (cause instanceof PrematureChannelClosureException || cause instanceof ClosedChannelException) {
            return;
        }
        Channel channel = ctx.channel();
        NettyResponseFuture<?> future = null;
        this.logger.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
        try {
            NettyResponseFuture<?> attribute = Channels.getAttribute(channel);
            if (attribute instanceof StreamedResponsePublisher) {
                ctx.fireExceptionCaught(e);
                attribute = ((StreamedResponsePublisher)((Object)attribute)).future();
            }
            if (attribute instanceof NettyResponseFuture) {
                future = attribute;
                future.attachChannel(null, false);
                future.touch();
                if (cause instanceof IOException && this.hasIOExceptionFilters) {
                    if (!this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, ChannelClosedException.INSTANCE, channel)) {
                        Channels.silentlyCloseChannel(channel);
                    }
                    return;
                }
                if (StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                    this.logger.debug("Trying to recover from dead Channel: {}", (Object)channel);
                    future.pendingException = cause;
                    return;
                }
            } else if (attribute instanceof OnLastHttpContentCallback) {
                future = ((OnLastHttpContentCallback)OnLastHttpContentCallback.class.cast(attribute)).future();
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        if (future != null) {
            try {
                this.logger.debug("Was unable to recover Future: {}", (Object)future);
                this.requestSender.abort(channel, future, cause);
                this.handleException(future, e);
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage(), t);
            }
        }
        this.channelManager.closeChannel(channel);
        Channels.silentlyCloseChannel(channel);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (!this.isHandledByReactiveStreams(ctx)) {
            ctx.read();
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    private boolean isHandledByReactiveStreams(ChannelHandlerContext ctx) {
        return Channels.getAttribute(ctx.channel()) instanceof StreamedResponsePublisher;
    }

    void finishUpdate(NettyResponseFuture<?> future, Channel channel, boolean close) {
        future.cancelTimeouts();
        if (close) {
            this.channelManager.closeChannel(channel);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, future.getAsyncHandler(), true, future.getPartitionKey());
        }
        try {
            future.done();
        }
        catch (Exception t) {
            this.logger.debug(t.getMessage(), (Throwable)t);
        }
    }

    public abstract void handleRead(Channel var1, NettyResponseFuture<?> var2, Object var3) throws Exception;

    public abstract void handleException(NettyResponseFuture<?> var1, Throwable var2);

    public abstract void handleChannelInactive(NettyResponseFuture<?> var1);
}

