/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.List;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AbstractBatchMessageContainer;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMessageContainerImpl
extends AbstractBatchMessageContainer {
    private PulsarApi.MessageMetadata.Builder messageMetadata = PulsarApi.MessageMetadata.newBuilder();
    private long sequenceId = -1L;
    private ByteBuf batchedMessageMetadataAndPayload;
    private List<MessageImpl<?>> messages = Lists.newArrayList();
    protected SendCallback previousCallback = null;
    protected SendCallback firstCallback;
    private static final Logger log = LoggerFactory.getLogger(BatchMessageContainerImpl.class);

    BatchMessageContainerImpl() {
    }

    @Override
    public void add(MessageImpl<?> msg, SendCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] add message to batch, num messages in batch so far {}", new Object[]{this.topicName, this.producerName, this.numMessagesInBatch});
        }
        if (++this.numMessagesInBatch == 1) {
            this.sequenceId = Commands.initBatchMessageMetadata(this.messageMetadata, msg.getMessageBuilder());
            this.firstCallback = callback;
            this.batchedMessageMetadataAndPayload = PulsarByteBufAllocator.DEFAULT.buffer(Math.min(this.maxBatchSize, 131072));
        }
        if (this.previousCallback != null) {
            this.previousCallback.addCallback(msg, callback);
        }
        this.previousCallback = callback;
        this.currentBatchSizeBytes += (long)msg.getDataBuffer().readableBytes();
        this.messages.add(msg);
    }

    private ByteBuf getCompressedBatchMetadataAndPayload() {
        int batchWriteIndex = this.batchedMessageMetadataAndPayload.writerIndex();
        int batchReadIndex = this.batchedMessageMetadataAndPayload.readerIndex();
        int n = this.messages.size();
        for (int i = 0; i < n; ++i) {
            MessageImpl<?> msg = this.messages.get(i);
            PulsarApi.MessageMetadata.Builder msgBuilder = msg.getMessageBuilder();
            msg.getDataBuffer().markReaderIndex();
            try {
                this.batchedMessageMetadataAndPayload = Commands.serializeSingleMessageInBatchWithPayload(msgBuilder, msg.getDataBuffer(), this.batchedMessageMetadataAndPayload);
                continue;
            }
            catch (Throwable th) {
                for (int j = 0; j <= i; ++j) {
                    MessageImpl<?> previousMsg = this.messages.get(j);
                    previousMsg.getDataBuffer().resetReaderIndex();
                }
                this.batchedMessageMetadataAndPayload.writerIndex(batchWriteIndex);
                this.batchedMessageMetadataAndPayload.readerIndex(batchReadIndex);
                throw new RuntimeException(th);
            }
        }
        for (MessageImpl<?> msg : this.messages) {
            msg.getMessageBuilder().recycle();
        }
        int uncompressedSize = this.batchedMessageMetadataAndPayload.readableBytes();
        ByteBuf compressedPayload = this.compressor.encode(this.batchedMessageMetadataAndPayload);
        this.batchedMessageMetadataAndPayload.release();
        if (this.compressionType != PulsarApi.CompressionType.NONE) {
            this.messageMetadata.setCompression(this.compressionType);
            this.messageMetadata.setUncompressedSize(uncompressedSize);
        }
        this.maxBatchSize = Math.max(this.maxBatchSize, uncompressedSize);
        return compressedPayload;
    }

    public void clear() {
        this.messages = Lists.newArrayList();
        this.firstCallback = null;
        this.previousCallback = null;
        this.messageMetadata.clear();
        this.numMessagesInBatch = 0;
        this.currentBatchSizeBytes = 0L;
        this.sequenceId = -1L;
        this.batchedMessageMetadataAndPayload = null;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public void discard(Exception ex) {
        try {
            if (this.firstCallback != null) {
                this.firstCallback.sendComplete(ex);
            }
        }
        catch (Throwable t) {
            log.warn("[{}] [{}] Got exception while completing the callback for msg {}:", new Object[]{this.topicName, this.producerName, this.sequenceId, t});
        }
        ReferenceCountUtil.safeRelease(this.batchedMessageMetadataAndPayload);
        this.clear();
    }

    public boolean isMultiBatches() {
        return false;
    }

    @Override
    public ProducerImpl.OpSendMsg createOpSendMsg() throws IOException {
        ByteBuf encryptedPayload = this.producer.encryptMessage(this.messageMetadata, this.getCompressedBatchMetadataAndPayload());
        this.messageMetadata.setNumMessagesInBatch(this.numMessagesInBatch);
        ByteBufPair cmd = this.producer.sendMessage(this.producer.producerId, this.sequenceId, this.numMessagesInBatch, this.messageMetadata.build(), encryptedPayload);
        ProducerImpl.OpSendMsg op = ProducerImpl.OpSendMsg.create(this.messages, cmd, this.sequenceId, this.firstCallback);
        if (encryptedPayload.readableBytes() > ClientCnx.getMaxMessageSize()) {
            cmd.release();
            this.discard((Exception)new PulsarClientException.InvalidMessageException("Message size is bigger than " + ClientCnx.getMaxMessageSize() + " bytes"));
            if (op != null) {
                op.recycle();
            }
            return null;
        }
        op.setNumMessagesInBatch(this.numMessagesInBatch);
        op.setBatchSizeByte(this.currentBatchSizeBytes);
        return op;
    }
}

