/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.xerial.snappy;

import java.lang.ref.SoftReference;

class BufferRecycler {
    private static final int MIN_ENCODING_BUFFER = 4000;
    private static final int MIN_OUTPUT_BUFFER = 8000;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> recyclerRef = new ThreadLocal();
    private byte[] inputBuffer;
    private byte[] outputBuffer;
    private byte[] decodingBuffer;
    private byte[] encodingBuffer;
    private short[] encodingHash;

    BufferRecycler() {
    }

    public static BufferRecycler instance() {
        SoftReference<BufferRecycler> softReference = recyclerRef.get();
        BufferRecycler bufferRecycler = softReference == null ? null : softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        }
        return bufferRecycler;
    }

    public byte[] allocEncodingBuffer(int n) {
        byte[] byArray = this.encodingBuffer;
        if (byArray == null || byArray.length < n) {
            byArray = new byte[Math.max(n, 4000)];
        } else {
            this.encodingBuffer = null;
        }
        return byArray;
    }

    public void releaseEncodeBuffer(byte[] byArray) {
        if (this.encodingBuffer == null || byArray.length > this.encodingBuffer.length) {
            this.encodingBuffer = byArray;
        }
    }

    public byte[] allocOutputBuffer(int n) {
        byte[] byArray = this.outputBuffer;
        if (byArray == null || byArray.length < n) {
            byArray = new byte[Math.max(n, 8000)];
        } else {
            this.outputBuffer = null;
        }
        return byArray;
    }

    public void releaseOutputBuffer(byte[] byArray) {
        if (this.outputBuffer == null || byArray != null && byArray.length > this.outputBuffer.length) {
            this.outputBuffer = byArray;
        }
    }

    public short[] allocEncodingHash(int n) {
        short[] sArray = this.encodingHash;
        if (sArray == null || sArray.length < n) {
            sArray = new short[n];
        } else {
            this.encodingHash = null;
        }
        return sArray;
    }

    public void releaseEncodingHash(short[] sArray) {
        if (this.encodingHash == null || sArray != null && sArray.length > this.encodingHash.length) {
            this.encodingHash = sArray;
        }
    }

    public byte[] allocInputBuffer(int n) {
        byte[] byArray = this.inputBuffer;
        if (byArray == null || byArray.length < n) {
            byArray = new byte[Math.max(n, 8000)];
        } else {
            this.inputBuffer = null;
        }
        return byArray;
    }

    public void releaseInputBuffer(byte[] byArray) {
        if (this.inputBuffer == null || byArray != null && byArray.length > this.inputBuffer.length) {
            this.inputBuffer = byArray;
        }
    }

    public byte[] allocDecodeBuffer(int n) {
        byte[] byArray = this.decodingBuffer;
        if (byArray == null || byArray.length < n) {
            byArray = new byte[n];
        } else {
            this.decodingBuffer = null;
        }
        return byArray;
    }

    public void releaseDecodeBuffer(byte[] byArray) {
        if (this.decodingBuffer == null || byArray != null && byArray.length > this.decodingBuffer.length) {
            this.decodingBuffer = byArray;
        }
    }
}

