/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerBase;
import org.apache.pulsar.client.impl.schema.KeyValueSchema;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.util.TypeCheckUtil;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shaded.com.google.protobuf.v241.ByteString;

public class TypedMessageBuilderImpl<T>
implements TypedMessageBuilder<T> {
    private static final long serialVersionUID = 0L;
    private static final ByteBuffer EMPTY_CONTENT = ByteBuffer.allocate(0);
    private final ProducerBase<?> producer;
    private final PulsarApi.MessageMetadata.Builder msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder();
    private final Schema<T> schema;
    private ByteBuffer content;
    private final TransactionImpl txn;

    public TypedMessageBuilderImpl(ProducerBase<?> producer, Schema<T> schema) {
        this(producer, schema, null);
    }

    public TypedMessageBuilderImpl(ProducerBase<?> producer, Schema<T> schema, TransactionImpl txn) {
        this.producer = producer;
        this.schema = schema;
        this.content = EMPTY_CONTENT;
        this.txn = txn;
    }

    private long beforeSend() {
        if (this.txn == null) {
            return -1L;
        }
        this.msgMetadataBuilder.setTxnidLeastBits(this.txn.getTxnIdLeastBits());
        this.msgMetadataBuilder.setTxnidMostBits(this.txn.getTxnIdMostBits());
        long sequenceId = this.txn.nextSequenceId();
        this.msgMetadataBuilder.setSequenceId(sequenceId);
        return sequenceId;
    }

    public MessageId send() throws PulsarClientException {
        if (null != this.txn) {
            throw new IllegalStateException("Use sendAsync to send a transactional message");
        }
        return this.producer.send(this.getMessage());
    }

    public CompletableFuture<MessageId> sendAsync() {
        long sequenceId = this.beforeSend();
        CompletableFuture<MessageId> sendFuture = this.producer.internalSendAsync(this.getMessage());
        if (this.txn != null) {
            this.txn.registerProducedTopic(this.producer.getTopic());
            return this.txn.registerSendOp(sequenceId, sendFuture);
        }
        return sendFuture;
    }

    public TypedMessageBuilder<T> key(String key) {
        if (this.schema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
            KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
            Preconditions.checkArgument(kvSchema.getKeyValueEncodingType() != KeyValueEncodingType.SEPARATED, "This method is not allowed to set keys when in encoding type is SEPARATED");
        }
        this.msgMetadataBuilder.setPartitionKey(key);
        this.msgMetadataBuilder.setPartitionKeyB64Encoded(false);
        return this;
    }

    public TypedMessageBuilder<T> keyBytes(byte[] key) {
        if (this.schema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
            KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
            Preconditions.checkArgument(kvSchema.getKeyValueEncodingType() != KeyValueEncodingType.SEPARATED, "This method is not allowed to set keys when in encoding type is SEPARATED");
        }
        this.msgMetadataBuilder.setPartitionKey(Base64.getEncoder().encodeToString(key));
        this.msgMetadataBuilder.setPartitionKeyB64Encoded(true);
        return this;
    }

    public TypedMessageBuilder<T> orderingKey(byte[] orderingKey) {
        this.msgMetadataBuilder.setOrderingKey(ByteString.copyFrom((byte[])orderingKey));
        return this;
    }

    public TypedMessageBuilder<T> value(T value) {
        Preconditions.checkArgument(value != null, "Need Non-Null content value");
        if (this.schema.getSchemaInfo() != null && this.schema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
            KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
            KeyValue kv = (KeyValue)value;
            if (kvSchema.getKeyValueEncodingType() == KeyValueEncodingType.SEPARATED) {
                this.msgMetadataBuilder.setPartitionKey(Base64.getEncoder().encodeToString(kvSchema.getKeySchema().encode(kv.getKey())));
                this.msgMetadataBuilder.setPartitionKeyB64Encoded(true);
                this.content = ByteBuffer.wrap(kvSchema.getValueSchema().encode(kv.getValue()));
                return this;
            }
        }
        this.content = ByteBuffer.wrap(this.schema.encode(value));
        return this;
    }

    public TypedMessageBuilder<T> property(String name, String value) {
        Preconditions.checkArgument(name != null, "Need Non-Null name");
        Preconditions.checkArgument(value != null, "Need Non-Null value for name: " + name);
        this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(name).setValue(value).build());
        return this;
    }

    public TypedMessageBuilder<T> properties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument(entry.getKey() != null, "Need Non-Null key");
            Preconditions.checkArgument(entry.getValue() != null, "Need Non-Null value for key: " + entry.getKey());
            this.msgMetadataBuilder.addProperties(PulsarApi.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return this;
    }

    public TypedMessageBuilder<T> eventTime(long timestamp) {
        Preconditions.checkArgument(timestamp > 0L, "Invalid timestamp : '%s'", timestamp);
        this.msgMetadataBuilder.setEventTime(timestamp);
        return this;
    }

    public TypedMessageBuilder<T> sequenceId(long sequenceId) {
        Preconditions.checkArgument(sequenceId >= 0L);
        this.msgMetadataBuilder.setSequenceId(sequenceId);
        return this;
    }

    public TypedMessageBuilder<T> replicationClusters(List<String> clusters) {
        Preconditions.checkNotNull(clusters);
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addAllReplicateTo(clusters);
        return this;
    }

    public TypedMessageBuilder<T> disableReplication() {
        this.msgMetadataBuilder.clearReplicateTo();
        this.msgMetadataBuilder.addReplicateTo("__local__");
        return this;
    }

    public TypedMessageBuilder<T> deliverAfter(long delay, TimeUnit unit) {
        return this.deliverAt(System.currentTimeMillis() + unit.toMillis(delay));
    }

    public TypedMessageBuilder<T> deliverAt(long timestamp) {
        this.msgMetadataBuilder.setDeliverAtTime(timestamp);
        return this;
    }

    public TypedMessageBuilder<T> loadConf(Map<String, Object> config) {
        config.forEach((key, value) -> {
            if (key.equals("key")) {
                this.key(TypeCheckUtil.checkType(value, String.class));
            } else if (key.equals("properties")) {
                this.properties(TypeCheckUtil.checkType(value, Map.class));
            } else if (key.equals("eventTime")) {
                this.eventTime(TypeCheckUtil.checkType(value, Long.class));
            } else if (key.equals("sequenceId")) {
                this.sequenceId(TypeCheckUtil.checkType(value, Long.class));
            } else if (key.equals("replicationClusters")) {
                this.replicationClusters(TypeCheckUtil.checkType(value, List.class));
            } else if (key.equals("disableReplication")) {
                boolean disableReplication = TypeCheckUtil.checkType(value, Boolean.class);
                if (disableReplication) {
                    this.disableReplication();
                }
            } else if (key.equals("deliverAfterSeconds")) {
                this.deliverAfter(TypeCheckUtil.checkType(value, Long.class), TimeUnit.SECONDS);
            } else if (key.equals("deliverAt")) {
                this.deliverAt(TypeCheckUtil.checkType(value, Long.class));
            } else {
                throw new RuntimeException("Invalid message config key '" + key + "'");
            }
        });
        return this;
    }

    public PulsarApi.MessageMetadata.Builder getMetadataBuilder() {
        return this.msgMetadataBuilder;
    }

    public Message<T> getMessage() {
        this.beforeSend();
        return MessageImpl.create(this.msgMetadataBuilder, this.content, this.schema);
    }

    public long getPublishTime() {
        return this.msgMetadataBuilder.getPublishTime();
    }

    public boolean hasKey() {
        return this.msgMetadataBuilder.hasPartitionKey();
    }

    public String getKey() {
        return this.msgMetadataBuilder.getPartitionKey();
    }

    public ByteBuffer getContent() {
        return this.content;
    }
}

