/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.channel;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.pulsar.shade.io.netty.bootstrap.Bootstrap;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.ChannelFactory;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.shade.io.netty.channel.ChannelInitializer;
import org.apache.pulsar.shade.io.netty.channel.ChannelOption;
import org.apache.pulsar.shade.io.netty.channel.ChannelPipeline;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.channel.group.ChannelGroup;
import org.apache.pulsar.shade.io.netty.channel.group.DefaultChannelGroup;
import org.apache.pulsar.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pulsar.shade.io.netty.channel.oio.OioEventLoopGroup;
import org.apache.pulsar.shade.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpClientCodec;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpContentDecompressor;
import org.apache.pulsar.shade.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.apache.pulsar.shade.io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.apache.pulsar.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import org.apache.pulsar.shade.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import org.apache.pulsar.shade.io.netty.handler.logging.LogLevel;
import org.apache.pulsar.shade.io.netty.handler.logging.LoggingHandler;
import org.apache.pulsar.shade.io.netty.handler.proxy.Socks4ProxyHandler;
import org.apache.pulsar.shade.io.netty.handler.proxy.Socks5ProxyHandler;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslHandler;
import org.apache.pulsar.shade.io.netty.handler.stream.ChunkedWriteHandler;
import org.apache.pulsar.shade.io.netty.resolver.NameResolver;
import org.apache.pulsar.shade.io.netty.util.Timer;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.io.netty.util.concurrent.Future;
import org.apache.pulsar.shade.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.pulsar.shade.io.netty.util.concurrent.ImmediateEventExecutor;
import org.apache.pulsar.shade.io.netty.util.concurrent.Promise;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.ClientStats;
import org.apache.pulsar.shade.org.asynchttpclient.HostStats;
import org.apache.pulsar.shade.org.asynchttpclient.Realm;
import org.apache.pulsar.shade.org.asynchttpclient.SslEngineFactory;
import org.apache.pulsar.shade.org.asynchttpclient.channel.ChannelPool;
import org.apache.pulsar.shade.org.asynchttpclient.channel.ChannelPoolPartitioning;
import org.apache.pulsar.shade.org.asynchttpclient.channel.NoopChannelPool;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.OnLastHttpContentCallback;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.Channels;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.DefaultChannelPool;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.NioSocketChannelFactory;
import org.apache.pulsar.shade.org.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import org.apache.pulsar.shade.org.asynchttpclient.netty.handler.HttpHandler;
import org.apache.pulsar.shade.org.asynchttpclient.netty.handler.WebSocketHandler;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import org.apache.pulsar.shade.org.asynchttpclient.netty.ssl.DefaultSslEngineFactory;
import org.apache.pulsar.shade.org.asynchttpclient.proxy.ProxyServer;
import org.apache.pulsar.shade.org.asynchttpclient.uri.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    public static final String HTTP_CLIENT_CODEC = "http";
    public static final String SSL_HANDLER = "ssl";
    public static final String SOCKS_HANDLER = "socks";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunked-writer";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_COMPRESSOR_HANDLER = "ws-compressor";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    public static final String AHC_HTTP_HANDLER = "ahc-http";
    public static final String AHC_WS_HANDLER = "ahc-ws";
    public static final String LOGGING_HANDLER = "logging";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private final AsyncHttpClientConfig config;
    private final SslEngineFactory sslEngineFactory;
    private final EventLoopGroup eventLoopGroup;
    private final boolean allowReleaseEventLoopGroup;
    private final Bootstrap httpBootstrap;
    private final Bootstrap wsBootstrap;
    private final long handshakeTimeout;
    private final ChannelPool channelPool;
    private final ChannelGroup openChannels;
    private AsyncHttpClientHandler wsHandler;

    public ChannelManager(AsyncHttpClientConfig config, Timer nettyTimer) {
        ChannelFactory<NioSocketChannel> channelFactory;
        this.config = config;
        this.sslEngineFactory = config.getSslEngineFactory() != null ? config.getSslEngineFactory() : new DefaultSslEngineFactory();
        try {
            this.sslEngineFactory.init(config);
        }
        catch (SSLException e) {
            throw new RuntimeException("Could not initialize sslEngineFactory", e);
        }
        ChannelPool channelPool = config.getChannelPool();
        if (channelPool == null) {
            channelPool = config.isKeepAlive() ? new DefaultChannelPool(config, nettyTimer) : NoopChannelPool.INSTANCE;
        }
        this.channelPool = channelPool;
        this.openChannels = new DefaultChannelGroup("asyncHttpClient", GlobalEventExecutor.INSTANCE);
        this.handshakeTimeout = config.getHandshakeTimeout();
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName());
        boolean bl = this.allowReleaseEventLoopGroup = config.getEventLoopGroup() == null;
        if (this.allowReleaseEventLoopGroup) {
            if (config.isUseNativeTransport()) {
                this.eventLoopGroup = this.newEpollEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = this.getEpollSocketChannelFactory();
            } else {
                this.eventLoopGroup = new NioEventLoopGroup(config.getIoThreadsCount(), threadFactory);
                channelFactory = NioSocketChannelFactory.INSTANCE;
            }
        } else {
            this.eventLoopGroup = config.getEventLoopGroup();
            if (this.eventLoopGroup instanceof OioEventLoopGroup) {
                throw new IllegalArgumentException("Oio is not supported");
            }
            channelFactory = this.eventLoopGroup instanceof NioEventLoopGroup ? NioSocketChannelFactory.INSTANCE : this.getEpollSocketChannelFactory();
        }
        this.httpBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.wsBootstrap = this.newBootstrap(channelFactory, this.eventLoopGroup, config);
        this.httpBootstrap.option(ChannelOption.AUTO_READ, false);
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    private Bootstrap newBootstrap(ChannelFactory<? extends Channel> channelFactory, EventLoopGroup eventLoopGroup, AsyncHttpClientConfig config) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(channelFactory)).group(eventLoopGroup)).option(ChannelOption.ALLOCATOR, config.getAllocator() != null ? config.getAllocator() : ByteBufAllocator.DEFAULT)).option(ChannelOption.TCP_NODELAY, config.isTcpNoDelay())).option(ChannelOption.SO_REUSEADDR, config.isSoReuseAddress())).option(ChannelOption.AUTO_CLOSE, false);
        if (config.getConnectTimeout() > 0) {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, config.getConnectTimeout());
        }
        if (config.getSoLinger() >= 0) {
            bootstrap.option(ChannelOption.SO_LINGER, config.getSoLinger());
        }
        if (config.getSoSndBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, config.getSoSndBuf());
        }
        if (config.getSoRcvBuf() >= 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, config.getSoRcvBuf());
        }
        for (Map.Entry<ChannelOption<Object>, Object> entry : config.getChannelOptions().entrySet()) {
            bootstrap.option(entry.getKey(), entry.getValue());
        }
        return bootstrap;
    }

    private EventLoopGroup newEpollEventLoopGroup(int ioThreadsCount, ThreadFactory threadFactory) {
        try {
            Class<?> epollEventLoopGroupClass = Class.forName("org.apache.pulsar.shade.io.netty.channel.epoll.EpollEventLoopGroup");
            return (EventLoopGroup)epollEventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(ioThreadsCount, threadFactory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ChannelFactory<? extends Channel> getEpollSocketChannelFactory() {
        try {
            return (ChannelFactory)Class.forName("org.apache.pulsar.shade.org.asynchttpclient.netty.channel.EpollSocketChannelFactory").newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureBootstraps(NettyRequestSender requestSender) {
        final HttpHandler httpHandler = new HttpHandler(this.config, this, requestSender);
        this.wsHandler = new WebSocketHandler(this.config, this, requestSender);
        final LoggingHandler loggingHandler = new LoggingHandler(LogLevel.TRACE);
        this.httpBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor()).addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(ChannelManager.AHC_HTTP_HANDLER, (ChannelHandler)httpHandler);
                if (LOGGER.isTraceEnabled()) {
                    pipeline.addFirst(ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getHttpAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getHttpAdditionalChannelInitializer().accept(ch);
                }
            }
        });
        this.wsBootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline().addLast(ChannelManager.HTTP_CLIENT_CODEC, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.AHC_WS_HANDLER, (ChannelHandler)ChannelManager.this.wsHandler);
                if (ChannelManager.this.config.isEnableWebSocketCompression()) {
                    pipeline.addBefore(ChannelManager.AHC_WS_HANDLER, ChannelManager.WS_COMPRESSOR_HANDLER, WebSocketClientCompressionHandler.INSTANCE);
                }
                if (LOGGER.isDebugEnabled()) {
                    pipeline.addFirst(ChannelManager.LOGGING_HANDLER, (ChannelHandler)loggingHandler);
                }
                if (ChannelManager.this.config.getWsAdditionalChannelInitializer() != null) {
                    ChannelManager.this.config.getWsAdditionalChannelInitializer().accept(ch);
                }
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.config.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                @Override
                protected String getTargetContentEncoding(String contentEncoding) {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, AsyncHandler<?> asyncHandler, boolean keepAlive, Object partitionKey) {
        if (channel.isActive() && keepAlive) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            try {
                asyncHandler.onConnectionOffer(channel);
            }
            catch (Exception e) {
                LOGGER.error("onConnectionOffer crashed", (Throwable)e);
            }
            if (!this.channelPool.offer(channel, partitionKey)) {
                this.closeChannel(channel);
            }
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(Uri uri, String virtualHost, ProxyServer proxy, ChannelPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, virtualHost, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public void removeAll(Channel connection) {
        this.channelPool.removeAll(connection);
    }

    private void doClose() {
        this.openChannels.close();
        this.channelPool.destroy();
    }

    public void close() {
        if (this.allowReleaseEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully(this.config.getShutdownQuietPeriod(), this.config.getShutdownTimeout(), TimeUnit.MILLISECONDS).addListener(future -> this.doClose());
        } else {
            this.doClose();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        Channels.setDiscard(channel);
        this.removeAll(channel);
        Channels.silentlyCloseChannel(channel);
    }

    public void registerOpenChannel(Channel channel) {
        this.openChannels.add(channel);
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.config.getHttpClientCodecMaxInitialLineLength(), this.config.getHttpClientCodecMaxHeaderSize(), this.config.getHttpClientCodecMaxChunkSize(), false, this.config.isValidateResponseHeaders(), this.config.getHttpClientCodecInitialBufferSize());
    }

    private SslHandler createSslHandler(String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslEngineFactory.newSslEngine(this.config, peerHost, peerPort);
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeout > 0L) {
            sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeout);
        }
        return sslHandler;
    }

    public Future<Channel> updatePipelineForHttpTunneling(ChannelPipeline pipeline, Uri requestUri) {
        Future<Channel> whenHanshaked = null;
        if (pipeline.get(HTTP_CLIENT_CODEC) != null) {
            pipeline.remove(HTTP_CLIENT_CODEC);
        }
        if (requestUri.isSecured()) {
            if (!ChannelManager.isSslHandlerConfigured(pipeline)) {
                SslHandler sslHandler = this.createSslHandler(requestUri.getHost(), requestUri.getExplicitPort());
                whenHanshaked = sslHandler.handshakeFuture();
                pipeline.addBefore(INFLATER_HANDLER, SSL_HANDLER, sslHandler);
            }
            pipeline.addAfter(SSL_HANDLER, HTTP_CLIENT_CODEC, this.newHttpClientCodec());
        } else {
            pipeline.addBefore(AHC_HTTP_HANDLER, HTTP_CLIENT_CODEC, this.newHttpClientCodec());
        }
        if (requestUri.isWebSocket()) {
            pipeline.addAfter(AHC_HTTP_HANDLER, AHC_WS_HANDLER, this.wsHandler);
            pipeline.remove(AHC_HTTP_HANDLER);
        }
        return whenHanshaked;
    }

    public SslHandler addSslHandler(ChannelPipeline pipeline, Uri uri, String virtualHost, boolean hasSocksProxyHandler) {
        int peerPort;
        String peerHost;
        if (virtualHost != null) {
            int i = virtualHost.indexOf(58);
            if (i == -1) {
                peerHost = virtualHost;
                peerPort = uri.getSchemeDefaultPort();
            } else {
                peerHost = virtualHost.substring(0, i);
                peerPort = Integer.valueOf(virtualHost.substring(i + 1));
            }
        } else {
            peerHost = uri.getHost();
            peerPort = uri.getExplicitPort();
        }
        SslHandler sslHandler = this.createSslHandler(peerHost, peerPort);
        if (hasSocksProxyHandler) {
            pipeline.addAfter(SOCKS_HANDLER, SSL_HANDLER, sslHandler);
        } else {
            pipeline.addFirst(SSL_HANDLER, (ChannelHandler)sslHandler);
        }
        return sslHandler;
    }

    public Future<Bootstrap> getBootstrap(Uri uri, NameResolver<InetAddress> nameResolver, final ProxyServer proxy) {
        Promise<Bootstrap> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        if (uri.isWebSocket() && proxy == null) {
            return promise.setSuccess(this.wsBootstrap);
        }
        if (proxy != null && proxy.getProxyType().isSocks()) {
            Bootstrap socksBootstrap = this.httpBootstrap.clone();
            final ChannelHandler httpBootstrapHandler = socksBootstrap.config().handler();
            nameResolver.resolve(proxy.getHost()).addListener(whenProxyAddress -> {
                if (whenProxyAddress.isSuccess()) {
                    socksBootstrap.handler(new ChannelInitializer<Channel>(){

                        @Override
                        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                            httpBootstrapHandler.handlerAdded(ctx);
                            super.handlerAdded(ctx);
                        }

                        @Override
                        protected void initChannel(Channel channel) throws Exception {
                            Socks4ProxyHandler socksProxyHandler;
                            InetSocketAddress proxyAddress = new InetSocketAddress((InetAddress)whenProxyAddress.get(), proxy.getPort());
                            Realm realm = proxy.getRealm();
                            String username = realm != null ? realm.getPrincipal() : null;
                            String password = realm != null ? realm.getPassword() : null;
                            switch (proxy.getProxyType()) {
                                case SOCKS_V4: {
                                    socksProxyHandler = new Socks4ProxyHandler((SocketAddress)proxyAddress, username);
                                    break;
                                }
                                case SOCKS_V5: {
                                    socksProxyHandler = new Socks5ProxyHandler((SocketAddress)proxyAddress, username, password);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Only SOCKS4 and SOCKS5 supported at the moment.");
                                }
                            }
                            channel.pipeline().addFirst(ChannelManager.SOCKS_HANDLER, (ChannelHandler)socksProxyHandler);
                        }
                    });
                    promise.setSuccess(socksBootstrap);
                } else {
                    promise.setFailure(whenProxyAddress.cause());
                }
            });
        } else {
            promise.setSuccess(this.httpBootstrap);
        }
        return promise;
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_CLIENT_CODEC, WS_ENCODER_HANDLER, new WebSocket08FrameEncoder(true));
        pipeline.addAfter(WS_ENCODER_HANDLER, WS_DECODER_HANDLER, new WebSocket08FrameDecoder(false, this.config.isEnableWebSocketCompression(), this.config.getWebSocketMaxFrameSize()));
        if (this.config.isAggregateWebSocketFrameFragments()) {
            pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, new WebSocketFrameAggregator(this.config.getWebSocketMaxBufferSize()));
        }
        pipeline.remove(HTTP_CLIENT_CODEC);
    }

    private OnLastHttpContentCallback newDrainCallback(NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final Object partitionKey) {
        return new OnLastHttpContentCallback(future){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, this.future.getAsyncHandler(), keepAlive, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future) {
        this.drainChannelAndOffer(channel, future, future.isKeepAlive(), future.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future, boolean keepAlive, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future, channel, keepAlive, partitionKey));
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public ClientStats getClientStats() {
        Map totalConnectionsPerHost = this.openChannels.stream().map(Channel::remoteAddress).filter(a -> a.getClass() == InetSocketAddress.class).map(a -> (InetSocketAddress)a).map(InetSocketAddress::getHostName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map<String, Long> idleConnectionsPerHost = this.channelPool.getIdleChannelCountPerHost();
        Map<String, HostStats> statsPerHost = totalConnectionsPerHost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            long totalConnectionCount = (Long)entry.getValue();
            long idleConnectionCount = idleConnectionsPerHost.getOrDefault(entry.getKey(), 0L);
            long activeConnectionCount = totalConnectionCount - idleConnectionCount;
            return new HostStats(activeConnectionCount, idleConnectionCount);
        }));
        return new ClientStats(statsPerHost);
    }

    public boolean isOpen() {
        return this.channelPool.isOpen();
    }
}

