/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol.schema;

import java.util.Collections;
import java.util.TreeMap;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaInfo;

public final class SchemaInfoUtil {
    public static SchemaInfo newSchemaInfo(String name, SchemaData data) {
        SchemaInfo si = new SchemaInfo();
        si.setName(name);
        si.setSchema(data.getData());
        si.setType(data.getType());
        si.setProperties(data.getProps());
        return si;
    }

    public static SchemaInfo newSchemaInfo(PulsarApi.Schema schema) {
        SchemaInfo si = new SchemaInfo();
        si.setName(schema.getName());
        si.setSchema(schema.getSchemaData().toByteArray());
        si.setType(Commands.getSchemaType(schema.getType()));
        if (schema.getPropertiesCount() == 0) {
            si.setProperties(Collections.emptyMap());
        } else {
            si.setProperties(new TreeMap<String, String>());
            for (int i = 0; i < schema.getPropertiesCount(); ++i) {
                PulsarApi.KeyValue kv = schema.getProperties(i);
                si.getProperties().put(kv.getKey(), kv.getValue());
            }
        }
        return si;
    }

    public static SchemaInfo newSchemaInfo(String name, GetSchemaResponse schema) {
        SchemaInfo si = new SchemaInfo();
        si.setName(name);
        si.setSchema(schema.getData().getBytes());
        si.setType(schema.getType());
        si.setProperties(schema.getProperties());
        return si;
    }

    private SchemaInfoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

