/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;

public class AuthenticationDataToken
implements AuthenticationDataProvider {
    public static final String HTTP_HEADER_NAME = "Authorization";
    private final Supplier<String> tokenSupplier;

    public AuthenticationDataToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public boolean hasDataForHttp() {
        return true;
    }

    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return Collections.singletonMap(HTTP_HEADER_NAME, "Bearer " + this.getToken()).entrySet();
    }

    public boolean hasDataFromCommand() {
        return true;
    }

    public String getCommandData() {
        return this.getToken();
    }

    private String getToken() {
        try {
            return this.tokenSupplier.get();
        }
        catch (Throwable t) {
            throw new RuntimeException("failed to get client token", t);
        }
    }
}

