/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.List;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModel;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;

@ApiModel(value="BrokerNamespaceIsolationData", description="The namespace isolation data for a given broker")
public final class BrokerNamespaceIsolationDataImpl
implements BrokerNamespaceIsolationData {
    @ApiModelProperty(name="brokerName", value="The broker name", example="broker1:8080")
    private String brokerName;
    @ApiModelProperty(name="policyName", value="Policy name", example="my-policy")
    private String policyName;
    @ApiModelProperty(name="isPrimary", value="Is Primary broker", example="true/false")
    private boolean isPrimary;
    @ApiModelProperty(name="namespaceRegex", value="The namespace-isolation policies attached to this broker")
    private List<String> namespaceRegex;

    public static BrokerNamespaceIsolationDataImplBuilder builder() {
        return new BrokerNamespaceIsolationDataImplBuilder();
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public List<String> getNamespaceRegex() {
        return this.namespaceRegex;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public void setNamespaceRegex(List<String> namespaceRegex) {
        this.namespaceRegex = namespaceRegex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerNamespaceIsolationDataImpl)) {
            return false;
        }
        BrokerNamespaceIsolationDataImpl other = (BrokerNamespaceIsolationDataImpl)o;
        if (this.isPrimary() != other.isPrimary()) {
            return false;
        }
        String this$brokerName = this.getBrokerName();
        String other$brokerName = other.getBrokerName();
        if (this$brokerName == null ? other$brokerName != null : !this$brokerName.equals(other$brokerName)) {
            return false;
        }
        String this$policyName = this.getPolicyName();
        String other$policyName = other.getPolicyName();
        if (this$policyName == null ? other$policyName != null : !this$policyName.equals(other$policyName)) {
            return false;
        }
        List<String> this$namespaceRegex = this.getNamespaceRegex();
        List<String> other$namespaceRegex = other.getNamespaceRegex();
        return !(this$namespaceRegex == null ? other$namespaceRegex != null : !((Object)this$namespaceRegex).equals(other$namespaceRegex));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrimary() ? 79 : 97);
        String $brokerName = this.getBrokerName();
        result = result * 59 + ($brokerName == null ? 43 : $brokerName.hashCode());
        String $policyName = this.getPolicyName();
        result = result * 59 + ($policyName == null ? 43 : $policyName.hashCode());
        List<String> $namespaceRegex = this.getNamespaceRegex();
        result = result * 59 + ($namespaceRegex == null ? 43 : ((Object)$namespaceRegex).hashCode());
        return result;
    }

    public String toString() {
        return "BrokerNamespaceIsolationDataImpl(brokerName=" + this.getBrokerName() + ", policyName=" + this.getPolicyName() + ", isPrimary=" + this.isPrimary() + ", namespaceRegex=" + this.getNamespaceRegex() + ")";
    }

    public BrokerNamespaceIsolationDataImpl(String brokerName, String policyName, boolean isPrimary, List<String> namespaceRegex) {
        this.brokerName = brokerName;
        this.policyName = policyName;
        this.isPrimary = isPrimary;
        this.namespaceRegex = namespaceRegex;
    }

    public BrokerNamespaceIsolationDataImpl() {
    }

    public static class BrokerNamespaceIsolationDataImplBuilder
    implements BrokerNamespaceIsolationData.Builder {
        private String brokerName;
        private String policyName;
        private boolean isPrimary;
        private List<String> namespaceRegex;

        public BrokerNamespaceIsolationDataImplBuilder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public BrokerNamespaceIsolationDataImplBuilder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public BrokerNamespaceIsolationDataImplBuilder primary(boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public BrokerNamespaceIsolationDataImplBuilder namespaceRegex(List<String> namespaceRegex) {
            this.namespaceRegex = namespaceRegex;
            return this;
        }

        public BrokerNamespaceIsolationDataImpl build() {
            return new BrokerNamespaceIsolationDataImpl(this.brokerName, this.policyName, this.isPrimary, this.namespaceRegex);
        }
    }
}

