/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;

public class NonPersistentReplicatorStatsImpl
extends ReplicatorStatsImpl
implements NonPersistentReplicatorStats {
    public double msgDropRate;
    @JsonIgnore
    private final LongAdder msgDropCount = new LongAdder();

    public NonPersistentReplicatorStatsImpl add(NonPersistentReplicatorStatsImpl stats) {
        Objects.requireNonNull(stats);
        super.add(stats);
        this.msgDropRate += stats.msgDropRate;
        return this;
    }

    @JsonProperty
    public long getMsgDropCount() {
        return this.msgDropCount.sum();
    }

    public void incrementMsgDropCount() {
        this.msgDropCount.increment();
    }

    public double getMsgDropRate() {
        return this.msgDropRate;
    }

    public void setMsgDropRate(double msgDropRate) {
        this.msgDropRate = msgDropRate;
    }

    @Override
    public String toString() {
        return "NonPersistentReplicatorStatsImpl(msgDropRate=" + this.getMsgDropRate() + ", msgDropCount=" + this.getMsgDropCount() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonPersistentReplicatorStatsImpl)) {
            return false;
        }
        NonPersistentReplicatorStatsImpl other = (NonPersistentReplicatorStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getMsgDropRate(), other.getMsgDropRate()) != 0) {
            return false;
        }
        return this.getMsgDropCount() == other.getMsgDropCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NonPersistentReplicatorStatsImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $msgDropRate = Double.doubleToLongBits(this.getMsgDropRate());
        result = result * 59 + (int)($msgDropRate >>> 32 ^ $msgDropRate);
        long $msgDropCount = this.getMsgDropCount();
        result = result * 59 + (int)($msgDropCount >>> 32 ^ $msgDropCount);
        return result;
    }
}

