/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.stats.Rate;

public class PublisherStatsImpl
implements PublisherStats {
    @JsonIgnore
    private int count;
    public ProducerAccessMode accessMode;
    public double msgRateIn;
    public double msgThroughputIn;
    public double averageMsgSize;
    public double chunkedMessageRate;
    public long producerId;
    public boolean supportsPartialProducer;
    private String producerName;
    private String address;
    private String connectedSince;
    private String clientVersion;
    public Map<String, String> metadata;
    @JsonIgnore
    private final Rate msgIn = new Rate();
    @JsonIgnore
    private final Rate msgChunkIn = new Rate();

    public PublisherStatsImpl add(PublisherStatsImpl stats) {
        double newAverageMsgSize;
        if (stats == null) {
            throw new IllegalArgumentException("stats can't be null");
        }
        ++this.count;
        this.msgRateIn += stats.msgRateIn;
        this.msgThroughputIn += stats.msgThroughputIn;
        this.averageMsgSize = newAverageMsgSize = (this.averageMsgSize * (double)(this.count - 1) + stats.averageMsgSize) / (double)this.count;
        return this;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getConnectedSince() {
        return this.connectedSince;
    }

    public void setConnectedSince(String connectedSince) {
        this.connectedSince = connectedSince;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void calculateRates() {
        this.msgIn.calculateRate();
        this.msgChunkIn.calculateRate();
        this.msgRateIn = this.msgIn.getRate();
        this.msgThroughputIn = this.msgIn.getValueRate();
        this.averageMsgSize = this.msgIn.getAverageValue();
        this.chunkedMessageRate = this.msgChunkIn.getRate();
    }

    public void recordMsgIn(long messageCount, long byteCount) {
        this.msgIn.recordMultipleEvents(messageCount, byteCount);
    }

    @JsonIgnore
    public long getMsgInCounter() {
        return this.msgIn.getTotalCount();
    }

    @JsonIgnore
    public long getBytesInCounter() {
        return this.msgIn.getTotalValue();
    }

    public void recordChunkedMsgIn() {
        this.msgChunkIn.recordEvent();
    }

    @JsonIgnore
    public long getChunkedMsgInCounter() {
        return this.msgChunkIn.getTotalCount();
    }

    public int getCount() {
        return this.count;
    }

    public ProducerAccessMode getAccessMode() {
        return this.accessMode;
    }

    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    public double getAverageMsgSize() {
        return this.averageMsgSize;
    }

    public double getChunkedMessageRate() {
        return this.chunkedMessageRate;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public boolean isSupportsPartialProducer() {
        return this.supportsPartialProducer;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Rate getMsgIn() {
        return this.msgIn;
    }

    public Rate getMsgChunkIn() {
        return this.msgChunkIn;
    }

    @JsonIgnore
    public void setCount(int count) {
        this.count = count;
    }

    public void setAccessMode(ProducerAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    public void setAverageMsgSize(double averageMsgSize) {
        this.averageMsgSize = averageMsgSize;
    }

    public void setChunkedMessageRate(double chunkedMessageRate) {
        this.chunkedMessageRate = chunkedMessageRate;
    }

    public void setProducerId(long producerId) {
        this.producerId = producerId;
    }

    public void setSupportsPartialProducer(boolean supportsPartialProducer) {
        this.supportsPartialProducer = supportsPartialProducer;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublisherStatsImpl)) {
            return false;
        }
        PublisherStatsImpl other = (PublisherStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputIn(), other.getMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getAverageMsgSize(), other.getAverageMsgSize()) != 0) {
            return false;
        }
        if (Double.compare(this.getChunkedMessageRate(), other.getChunkedMessageRate()) != 0) {
            return false;
        }
        if (this.getProducerId() != other.getProducerId()) {
            return false;
        }
        if (this.isSupportsPartialProducer() != other.isSupportsPartialProducer()) {
            return false;
        }
        ProducerAccessMode this$accessMode = this.getAccessMode();
        ProducerAccessMode other$accessMode = other.getAccessMode();
        if (this$accessMode == null ? other$accessMode != null : !this$accessMode.equals(other$accessMode)) {
            return false;
        }
        String this$producerName = this.getProducerName();
        String other$producerName = other.getProducerName();
        if (this$producerName == null ? other$producerName != null : !this$producerName.equals(other$producerName)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$connectedSince = this.getConnectedSince();
        String other$connectedSince = other.getConnectedSince();
        if (this$connectedSince == null ? other$connectedSince != null : !this$connectedSince.equals(other$connectedSince)) {
            return false;
        }
        String this$clientVersion = this.getClientVersion();
        String other$clientVersion = other.getClientVersion();
        if (this$clientVersion == null ? other$clientVersion != null : !this$clientVersion.equals(other$clientVersion)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Rate this$msgIn = this.getMsgIn();
        Rate other$msgIn = other.getMsgIn();
        if (this$msgIn == null ? other$msgIn != null : !this$msgIn.equals(other$msgIn)) {
            return false;
        }
        Rate this$msgChunkIn = this.getMsgChunkIn();
        Rate other$msgChunkIn = other.getMsgChunkIn();
        return !(this$msgChunkIn == null ? other$msgChunkIn != null : !this$msgChunkIn.equals(other$msgChunkIn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublisherStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgThroughputIn = Double.doubleToLongBits(this.getMsgThroughputIn());
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $averageMsgSize = Double.doubleToLongBits(this.getAverageMsgSize());
        result = result * 59 + (int)($averageMsgSize >>> 32 ^ $averageMsgSize);
        long $chunkedMessageRate = Double.doubleToLongBits(this.getChunkedMessageRate());
        result = result * 59 + (int)($chunkedMessageRate >>> 32 ^ $chunkedMessageRate);
        long $producerId = this.getProducerId();
        result = result * 59 + (int)($producerId >>> 32 ^ $producerId);
        result = result * 59 + (this.isSupportsPartialProducer() ? 79 : 97);
        ProducerAccessMode $accessMode = this.getAccessMode();
        result = result * 59 + ($accessMode == null ? 43 : $accessMode.hashCode());
        String $producerName = this.getProducerName();
        result = result * 59 + ($producerName == null ? 43 : $producerName.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $connectedSince = this.getConnectedSince();
        result = result * 59 + ($connectedSince == null ? 43 : $connectedSince.hashCode());
        String $clientVersion = this.getClientVersion();
        result = result * 59 + ($clientVersion == null ? 43 : $clientVersion.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Rate $msgIn = this.getMsgIn();
        result = result * 59 + ($msgIn == null ? 43 : $msgIn.hashCode());
        Rate $msgChunkIn = this.getMsgChunkIn();
        result = result * 59 + ($msgChunkIn == null ? 43 : $msgChunkIn.hashCode());
        return result;
    }

    public String toString() {
        return "PublisherStatsImpl(count=" + this.getCount() + ", accessMode=" + this.getAccessMode() + ", msgRateIn=" + this.getMsgRateIn() + ", msgThroughputIn=" + this.getMsgThroughputIn() + ", averageMsgSize=" + this.getAverageMsgSize() + ", chunkedMessageRate=" + this.getChunkedMessageRate() + ", producerId=" + this.getProducerId() + ", supportsPartialProducer=" + this.isSupportsPartialProducer() + ", producerName=" + this.getProducerName() + ", address=" + this.getAddress() + ", connectedSince=" + this.getConnectedSince() + ", clientVersion=" + this.getClientVersion() + ", metadata=" + this.getMetadata() + ", msgIn=" + this.getMsgIn() + ", msgChunkIn=" + this.getMsgChunkIn() + ")";
    }
}

