/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.github.benmanes.caffeine.cache;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.pulsar.shade.org.checkerframework.checker.nullness.qual.Nullable;

enum SystemScheduler implements Scheduler
{
    INSTANCE;

    static final @Nullable Method delayedExecutor;

    @Override
    public Future<?> schedule(Executor executor, Runnable command, long delay, TimeUnit unit) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(command);
        Objects.requireNonNull(unit);
        try {
            Executor scheduler = (Executor)delayedExecutor.invoke(CompletableFuture.class, new Object[]{delay, unit, executor});
            return CompletableFuture.runAsync(command, scheduler);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static @Nullable Method getDelayedExecutorMethod() {
        try {
            return CompletableFuture.class.getMethod("delayedExecutor", Long.TYPE, TimeUnit.class, Executor.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    static boolean isPresent() {
        return delayedExecutor != null;
    }

    static {
        delayedExecutor = SystemScheduler.getDelayedExecutorMethod();
    }
}

