/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.PulsarClientSharedResources;
import org.apache.pulsar.client.impl.DnsResolverGroupImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.PulsarClientResourcesConfigurer;
import org.apache.pulsar.client.impl.PulsarClientSharedResourcesBuilderImpl;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.client.util.ScheduledExecutorProvider;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.util.Timer;

public class PulsarClientSharedResourcesImpl
implements PulsarClientSharedResources {
    Set<PulsarClientSharedResources.SharedResource> sharedResources;
    protected final EventLoopGroup ioEventLoopGroup;
    private final ExecutorProvider internalExecutorProvider;
    private final ExecutorProvider externalExecutorProvider;
    private final ScheduledExecutorProvider scheduledExecutorProvider;
    private final Timer timer;
    private final ExecutorProvider lookupExecutorProvider;
    private final DnsResolverGroupImpl dnsResolverGroup;

    public PulsarClientSharedResourcesImpl(Set<PulsarClientSharedResources.SharedResource> sharedResources, Map<PulsarClientSharedResources.SharedResource, PulsarClientSharedResourcesBuilderImpl.ResourceConfig> resourceConfigs, boolean shareConfigured) {
        if (shareConfigured) {
            if (resourceConfigs.isEmpty()) {
                throw new IllegalArgumentException("No resources have been configured while using shareConfigured mode");
            }
            this.sharedResources = Set.copyOf(resourceConfigs.keySet());
        } else {
            this.sharedResources = sharedResources.isEmpty() ? EnumSet.allOf(PulsarClientSharedResources.SharedResource.class) : Set.copyOf(sharedResources);
        }
        this.ioEventLoopGroup = this.sharedResources.contains(PulsarClientSharedResources.SharedResource.EventLoopGroup) ? PulsarClientResourcesConfigurer.createEventLoopGroupWithResourceConfig((PulsarClientSharedResourcesBuilderImpl.EventLoopResourceConfig)this.getResourceConfig(resourceConfigs, PulsarClientSharedResources.SharedResource.EventLoopGroup)) : null;
        this.externalExecutorProvider = this.sharedResources.contains(PulsarClientSharedResources.SharedResource.ListenerExecutor) ? PulsarClientResourcesConfigurer.createExternalExecutorProviderWithResourceConfig((PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig)this.getResourceConfig(resourceConfigs, PulsarClientSharedResources.SharedResource.ListenerExecutor)) : null;
        this.internalExecutorProvider = this.sharedResources.contains(PulsarClientSharedResources.SharedResource.InternalExecutor) ? PulsarClientResourcesConfigurer.createInternalExecutorProviderWithResourceConfig((PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig)this.getResourceConfig(resourceConfigs, PulsarClientSharedResources.SharedResource.InternalExecutor)) : null;
        this.scheduledExecutorProvider = this.sharedResources.contains(PulsarClientSharedResources.SharedResource.ScheduledExecutor) ? PulsarClientResourcesConfigurer.createScheduledExecutorProviderWithResourceConfig((PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig)this.getResourceConfig(resourceConfigs, PulsarClientSharedResources.SharedResource.ScheduledExecutor)) : null;
        this.lookupExecutorProvider = this.sharedResources.contains(PulsarClientSharedResources.SharedResource.LookupExecutor) ? PulsarClientResourcesConfigurer.createLookupExecutorProviderWithResourceConfig((PulsarClientSharedResourcesBuilderImpl.ThreadPoolResourceConfig)this.getResourceConfig(resourceConfigs, PulsarClientSharedResources.SharedResource.LookupExecutor)) : null;
        this.timer = this.sharedResources.contains(PulsarClientSharedResources.SharedResource.Timer) ? PulsarClientResourcesConfigurer.createTimer((PulsarClientSharedResourcesBuilderImpl.TimerResourceConfig)this.getResourceConfig(resourceConfigs, PulsarClientSharedResources.SharedResource.Timer)) : null;
        this.dnsResolverGroup = this.sharedResources.contains(PulsarClientSharedResources.SharedResource.DnsResolver) ? PulsarClientResourcesConfigurer.createDnsResolverGroupWithResourceConfig((PulsarClientSharedResourcesBuilderImpl.DnsResolverResourceConfig)this.getResourceConfig(resourceConfigs, PulsarClientSharedResources.SharedResource.DnsResolver)) : null;
    }

    private <T extends PulsarClientSharedResourcesBuilderImpl.ResourceConfig> T getResourceConfig(Map<PulsarClientSharedResources.SharedResource, PulsarClientSharedResourcesBuilderImpl.ResourceConfig> resourceConfigs, PulsarClientSharedResources.SharedResource resource) {
        return (T)resourceConfigs.get(resource);
    }

    public boolean contains(PulsarClientSharedResources.SharedResource sharedResource) {
        return this.sharedResources.contains(sharedResource);
    }

    public Set<PulsarClientSharedResources.SharedResource> getSharedResources() {
        return this.sharedResources;
    }

    public void close() throws PulsarClientException {
        if (this.externalExecutorProvider != null) {
            this.externalExecutorProvider.shutdownNow();
        }
        if (this.internalExecutorProvider != null) {
            this.internalExecutorProvider.shutdownNow();
        }
        if (this.scheduledExecutorProvider != null) {
            this.scheduledExecutorProvider.shutdownNow();
        }
        if (this.lookupExecutorProvider != null) {
            this.lookupExecutorProvider.shutdownNow();
        }
        if (this.dnsResolverGroup != null) {
            this.dnsResolverGroup.close();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.ioEventLoopGroup != null) {
            EventLoopUtil.shutdownGracefully(this.ioEventLoopGroup);
        }
    }

    public void applyTo(PulsarClientImpl.PulsarClientImplBuilder instanceBuilder) {
        if (this.externalExecutorProvider != null) {
            instanceBuilder.externalExecutorProvider(this.externalExecutorProvider);
        }
        if (this.internalExecutorProvider != null) {
            instanceBuilder.internalExecutorProvider(this.internalExecutorProvider);
        }
        if (this.scheduledExecutorProvider != null) {
            instanceBuilder.scheduledExecutorProvider(this.scheduledExecutorProvider);
        }
        if (this.lookupExecutorProvider != null) {
            instanceBuilder.lookupExecutorProvider(this.lookupExecutorProvider);
        }
        if (this.dnsResolverGroup != null) {
            instanceBuilder.dnsResolverGroup(this.dnsResolverGroup);
        }
        if (this.timer != null) {
            instanceBuilder.timer(this.timer);
        }
        if (this.ioEventLoopGroup != null) {
            instanceBuilder.eventLoopGroup(this.ioEventLoopGroup);
        }
    }

    @Generated
    public EventLoopGroup getIoEventLoopGroup() {
        return this.ioEventLoopGroup;
    }

    @Generated
    public ExecutorProvider getInternalExecutorProvider() {
        return this.internalExecutorProvider;
    }

    @Generated
    public ExecutorProvider getExternalExecutorProvider() {
        return this.externalExecutorProvider;
    }

    @Generated
    public ScheduledExecutorProvider getScheduledExecutorProvider() {
        return this.scheduledExecutorProvider;
    }

    @Generated
    public Timer getTimer() {
        return this.timer;
    }

    @Generated
    public ExecutorProvider getLookupExecutorProvider() {
        return this.lookupExecutorProvider;
    }

    @Generated
    public DnsResolverGroupImpl getDnsResolverGroup() {
        return this.dnsResolverGroup;
    }
}

