/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.StampedLock;

public class ConcurrentLongLongPairHashMap {
    private static final long EmptyKey = -1L;
    private static final long DeletedKey = -2L;
    private static final long ValueNotFound = -1L;
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private static final float DefaultMapFillFactor = 0.66f;
    private static final float DefaultMapIdleFactor = 0.15f;
    private static final float DefaultExpandFactor = 2.0f;
    private static final float DefaultShrinkFactor = 2.0f;
    private static final boolean DefaultAutoShrink = false;
    private final Section[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ConcurrentLongLongPairHashMap(int expectedItems, int concurrencyLevel, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
        Preconditions.checkArgument((expectedItems > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((concurrencyLevel > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((expectedItems >= concurrencyLevel ? 1 : 0) != 0);
        Preconditions.checkArgument((mapFillFactor > 0.0f && mapFillFactor < 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((mapIdleFactor > 0.0f && mapIdleFactor < 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((mapFillFactor > mapIdleFactor ? 1 : 0) != 0);
        Preconditions.checkArgument((expandFactor > 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((shrinkFactor > 1.0f ? 1 : 0) != 0);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / mapFillFactor);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity, mapFillFactor, mapIdleFactor, autoShrink, expandFactor, shrinkFactor);
        }
    }

    public long size() {
        long size = 0L;
        for (Section s : this.sections) {
            size += (long)s.size;
        }
        return size;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section s : this.sections) {
            capacity += (long)s.capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section s : this.sections) {
            if (s.size == 0) continue;
            return false;
        }
        return true;
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (Section s : this.sections) {
            usedBucketCount += (long)s.usedBuckets;
        }
        return usedBucketCount;
    }

    public LongPair get(long key1, long key2) {
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(key1);
        long h = ConcurrentLongLongPairHashMap.hash(key1, key2);
        return this.getSection(h).get(key1, key2, (int)h);
    }

    public boolean containsKey(long key1, long key2) {
        return this.get(key1, key2) != null;
    }

    public boolean put(long key1, long key2, long value1, long value2) {
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(key1);
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(value1);
        long h = ConcurrentLongLongPairHashMap.hash(key1, key2);
        return this.getSection(h).put(key1, key2, value1, value2, (int)h, false);
    }

    public boolean putIfAbsent(long key1, long key2, long value1, long value2) {
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(key1);
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(value1);
        long h = ConcurrentLongLongPairHashMap.hash(key1, key2);
        return this.getSection(h).put(key1, key2, value1, value2, (int)h, true);
    }

    public boolean remove(long key1, long key2) {
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(key1);
        long h = ConcurrentLongLongPairHashMap.hash(key1, key2);
        return this.getSection(h).remove(key1, key2, -1L, -1L, (int)h);
    }

    public boolean remove(long key1, long key2, long value1, long value2) {
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(key1);
        ConcurrentLongLongPairHashMap.checkBiggerEqualZero(value1);
        long h = ConcurrentLongLongPairHashMap.hash(key1, key2);
        return this.getSection(h).remove(key1, key2, value1, value2, (int)h);
    }

    private Section getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (Section s : this.sections) {
            s.clear();
        }
    }

    public void forEach(BiConsumerLongPair processor) {
        for (Section s : this.sections) {
            s.forEach(processor);
        }
    }

    public List<LongPair> keys() {
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)((int)this.size()));
        this.forEach((key1, key2, value1, value2) -> keys.add(new LongPair(key1, key2)));
        return keys;
    }

    public List<LongPair> values() {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)((int)this.size()));
        this.forEach((key1, key2, value1, value2) -> values.add(new LongPair(value1, value2)));
        return values;
    }

    public Map<LongPair, LongPair> asMap() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)((int)this.size()));
        this.forEach((key1, key2, value1, value2) -> map.put(new LongPair(key1, key2), new LongPair(value1, value2)));
        return map;
    }

    static final long hash(long key1, long key2) {
        long hash = key1 * -4132994306676758123L;
        hash ^= hash >>> 47;
        hash *= -4132994306676758123L;
        hash += 31L + key2 * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)(n & (long)(max - 1)) << 2;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static void checkBiggerEqualZero(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Keys and values must be >= 0");
        }
    }

    public static class Builder {
        int expectedItems = 256;
        int concurrencyLevel = 16;
        float mapFillFactor = 0.66f;
        float mapIdleFactor = 0.15f;
        float expandFactor = 2.0f;
        float shrinkFactor = 2.0f;
        boolean autoShrink = false;

        public Builder expectedItems(int expectedItems) {
            this.expectedItems = expectedItems;
            return this;
        }

        public Builder concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder mapFillFactor(float mapFillFactor) {
            this.mapFillFactor = mapFillFactor;
            return this;
        }

        public Builder mapIdleFactor(float mapIdleFactor) {
            this.mapIdleFactor = mapIdleFactor;
            return this;
        }

        public Builder expandFactor(float expandFactor) {
            this.expandFactor = expandFactor;
            return this;
        }

        public Builder shrinkFactor(float shrinkFactor) {
            this.shrinkFactor = shrinkFactor;
            return this;
        }

        public Builder autoShrink(boolean autoShrink) {
            this.autoShrink = autoShrink;
            return this;
        }

        public ConcurrentLongLongPairHashMap build() {
            return new ConcurrentLongLongPairHashMap(this.expectedItems, this.concurrencyLevel, this.mapFillFactor, this.mapIdleFactor, this.autoShrink, this.expandFactor, this.shrinkFactor);
        }
    }

    private static final class Section
    extends StampedLock {
        private volatile long[] table;
        private volatile int capacity;
        private final int initCapacity;
        private static final AtomicIntegerFieldUpdater<Section> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Section.class, "size");
        private volatile int size;
        private int usedBuckets;
        private int resizeThresholdUp;
        private int resizeThresholdBelow;
        private final float mapFillFactor;
        private final float mapIdleFactor;
        private final float expandFactor;
        private final float shrinkFactor;
        private final boolean autoShrink;

        Section(int capacity, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
            this.initCapacity = this.capacity = ConcurrentLongLongPairHashMap.alignToPowerOfTwo(capacity);
            this.table = new long[4 * this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.autoShrink = autoShrink;
            this.mapFillFactor = mapFillFactor;
            this.mapIdleFactor = mapIdleFactor;
            this.expandFactor = expandFactor;
            this.shrinkFactor = shrinkFactor;
            this.resizeThresholdUp = (int)((float)this.capacity * mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * mapIdleFactor);
            Arrays.fill(this.table, -1L);
        }

        LongPair get(long key1, long key2, int keyHash) {
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            int bucket = ConcurrentLongLongPairHashMap.signSafeMod(keyHash, this.capacity);
            try {
                while (true) {
                    long storedKey1 = this.table[bucket];
                    long storedKey2 = this.table[bucket + 1];
                    long storedValue1 = this.table[bucket + 2];
                    long storedValue2 = this.table[bucket + 3];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (key1 == storedKey1 && key2 == storedKey2) {
                            LongPair longPair = new LongPair(storedValue1, storedValue2);
                            return longPair;
                        }
                        if (storedKey1 == -1L) {
                            LongPair longPair = null;
                            return longPair;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            bucket = ConcurrentLongLongPairHashMap.signSafeMod(keyHash, this.capacity);
                            storedKey1 = this.table[bucket];
                            storedKey2 = this.table[bucket + 1];
                            storedValue1 = this.table[bucket + 2];
                            storedValue2 = this.table[bucket + 3];
                        }
                        if (key1 == storedKey1 && key2 == storedKey2) {
                            LongPair longPair = new LongPair(storedValue1, storedValue2);
                            return longPair;
                        }
                        if (storedKey1 == -1L) {
                            LongPair longPair = null;
                            return longPair;
                        }
                    }
                    bucket = bucket + 4 & this.table.length - 1;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean put(long key1, long key2, long value1, long value2, int keyHash, boolean onlyIfAbsent) {
            long stamp = this.writeLock();
            int bucket = ConcurrentLongLongPairHashMap.signSafeMod(keyHash, this.capacity);
            int firstDeletedKey = -1;
            try {
                while (true) {
                    long storedKey1 = this.table[bucket];
                    long storedKey2 = this.table[bucket + 1];
                    if (key1 == storedKey1 && key2 == storedKey2) {
                        if (!onlyIfAbsent) {
                            this.table[bucket + 2] = value1;
                            this.table[bucket + 3] = value2;
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (storedKey1 == -1L) {
                        if (firstDeletedKey != -1) {
                            bucket = firstDeletedKey;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.table[bucket] = key1;
                        this.table[bucket + 1] = key2;
                        this.table[bucket + 2] = value1;
                        this.table[bucket + 3] = value2;
                        SIZE_UPDATER.incrementAndGet(this);
                        boolean bl = true;
                        return bl;
                    }
                    if (storedKey1 == -2L && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    bucket = bucket + 4 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentLongLongPairHashMap.alignToPowerOfTwo((int)((float)this.capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean remove(long key1, long key2, long value1, long value2, int keyHash) {
            stamp = this.writeLock();
            bucket = ConcurrentLongLongPairHashMap.signSafeMod(keyHash, this.capacity);
            try {
                while (true) {
                    storedKey1 = this.table[bucket];
                    storedKey2 = this.table[bucket + 1];
                    storedValue1 = this.table[bucket + 2];
                    storedValue2 = this.table[bucket + 3];
                    if (key1 == storedKey1 && key2 == storedKey2) {
                        if (value1 == -1L || value1 == storedValue1 && value2 == storedValue2) {
                            Section.SIZE_UPDATER.decrementAndGet(this);
                            this.cleanBucket(bucket);
                            var21_12 = true;
                            return var21_12;
                        }
                        var21_13 = false;
                        return var21_13;
                    }
                    if (storedKey1 == -1L) {
                        var21_14 = false;
                        return var21_14;
                    }
                    bucket = bucket + 4 & this.table.length - 1;
                }
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = ConcurrentLongLongPairHashMap.access$500((int)((float)this.capacity / this.shrinkFactor));
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl35
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl35:
                // 3 sources

            }
        }

        private void cleanBucket(int bucket) {
            int nextInArray = bucket + 4 & this.table.length - 1;
            if (this.table[nextInArray] == -1L) {
                this.table[bucket] = -1L;
                this.table[bucket + 1] = -1L;
                this.table[bucket + 2] = -1L;
                this.table[bucket + 3] = -1L;
                --this.usedBuckets;
                bucket = bucket - 4 & this.table.length - 1;
                while (this.table[bucket] == -2L) {
                    this.table[bucket] = -1L;
                    this.table[bucket + 1] = -1L;
                    this.table[bucket + 2] = -1L;
                    this.table[bucket + 3] = -1L;
                    --this.usedBuckets;
                    bucket = bucket - 4 & this.table.length - 1;
                }
            } else {
                this.table[bucket] = -2L;
                this.table[bucket + 1] = -2L;
                this.table[bucket + 2] = -1L;
                this.table[bucket + 3] = -1L;
            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                Arrays.fill(this.table, -1L);
                this.size = 0;
                this.usedBuckets = 0;
                if (this.autoShrink) {
                    this.rehash(this.initCapacity);
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(BiConsumerLongPair processor) {
            long stamp = this.tryOptimisticRead();
            long[] table = this.table;
            boolean acquiredReadLock = false;
            try {
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    acquiredReadLock = true;
                    table = this.table;
                }
                for (int bucket = 0; bucket < table.length; bucket += 4) {
                    long storedKey1 = table[bucket];
                    long storedKey2 = table[bucket + 1];
                    long storedValue1 = table[bucket + 2];
                    long storedValue2 = table[bucket + 3];
                    if (!acquiredReadLock && !this.validate(stamp)) {
                        stamp = this.readLock();
                        acquiredReadLock = true;
                        storedKey1 = table[bucket];
                        storedKey2 = table[bucket + 1];
                        storedValue1 = table[bucket + 2];
                        storedValue2 = table[bucket + 3];
                    }
                    if (storedKey1 == -2L || storedKey1 == -1L) continue;
                    processor.accept(storedKey1, storedKey2, storedValue1, storedValue2);
                }
            }
            finally {
                if (acquiredReadLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        private void rehash(int newCapacity) {
            long[] newTable = new long[4 * newCapacity];
            Arrays.fill(newTable, -1L);
            for (int i = 0; i < this.table.length; i += 4) {
                long storedKey1 = this.table[i];
                long storedKey2 = this.table[i + 1];
                long storedValue1 = this.table[i + 2];
                long storedValue2 = this.table[i + 3];
                if (storedKey1 == -1L || storedKey1 == -2L) continue;
                Section.insertKeyValueNoLock(newTable, newCapacity, storedKey1, storedKey2, storedValue1, storedValue2);
            }
            this.table = newTable;
            this.usedBuckets = this.size;
            this.capacity = newCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private static void insertKeyValueNoLock(long[] table, int capacity, long key1, long key2, long value1, long value2) {
            int bucket = ConcurrentLongLongPairHashMap.signSafeMod(ConcurrentLongLongPairHashMap.hash(key1, key2), capacity);
            while (true) {
                long storedKey1;
                if ((storedKey1 = table[bucket]) == -1L) {
                    table[bucket] = key1;
                    table[bucket + 1] = key2;
                    table[bucket + 2] = value1;
                    table[bucket + 3] = value2;
                    return;
                }
                bucket = bucket + 4 & table.length - 1;
            }
        }
    }

    public static class LongPair
    implements Comparable<LongPair> {
        public final long first;
        public final long second;

        public LongPair(long first, long second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongPair) {
                LongPair other = (LongPair)obj;
                return this.first == other.first && this.second == other.second;
            }
            return false;
        }

        public int hashCode() {
            return (int)ConcurrentLongLongPairHashMap.hash(this.first, this.second);
        }

        @Override
        public int compareTo(LongPair o) {
            if (this.first != o.first) {
                return Long.compare(this.first, o.first);
            }
            return Long.compare(this.second, o.second);
        }
    }

    public static interface BiConsumerLongPair {
        public void accept(long var1, long var3, long var5, long var7);
    }

    public static interface LongLongPairPredicate {
        public boolean test(long var1, long var3, long var5, long var7);
    }

    public static interface LongLongPairFunction {
        public long apply(long var1, long var3);
    }
}

