/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PulsarDecoder
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(PulsarDecoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        PulsarApi.BaseCommand cmd = null;
        PulsarApi.BaseCommand.Builder cmdBuilder = null;
        try {
            int cmdSize = (int)buffer.readUnsignedInt();
            int writerIndex = buffer.writerIndex();
            buffer.writerIndex(buffer.readerIndex() + cmdSize);
            ByteBufCodedInputStream cmdInputStream = ByteBufCodedInputStream.get(buffer);
            cmdBuilder = PulsarApi.BaseCommand.newBuilder();
            cmd = cmdBuilder.mergeFrom(cmdInputStream, null).build();
            buffer.writerIndex(writerIndex);
            cmdInputStream.recycle();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Received cmd {}", (Object)ctx.channel().remoteAddress(), (Object)cmd.getType());
            }
            this.messageReceived();
            switch (cmd.getType()) {
                case PARTITIONED_METADATA: {
                    Preconditions.checkArgument((boolean)cmd.hasPartitionMetadata());
                    this.handlePartitionMetadataRequest(cmd.getPartitionMetadata());
                    cmd.getPartitionMetadata().recycle();
                    return;
                }
                case PARTITIONED_METADATA_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasPartitionMetadataResponse());
                    this.handlePartitionResponse(cmd.getPartitionMetadataResponse());
                    cmd.getPartitionMetadataResponse().recycle();
                    return;
                }
                case LOOKUP: {
                    Preconditions.checkArgument((boolean)cmd.hasLookupTopic());
                    this.handleLookup(cmd.getLookupTopic());
                    cmd.getLookupTopic().recycle();
                    return;
                }
                case LOOKUP_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasLookupTopicResponse());
                    this.handleLookupResponse(cmd.getLookupTopicResponse());
                    cmd.getLookupTopicResponse().recycle();
                    return;
                }
                case ACK: {
                    Preconditions.checkArgument((boolean)cmd.hasAck());
                    PulsarApi.CommandAck ack = cmd.getAck();
                    this.handleAck(ack);
                    int i = 0;
                    while (true) {
                        if (i >= ack.getMessageIdCount()) {
                            ack.recycle();
                            return;
                        }
                        ack.getMessageId(i).recycle();
                        ++i;
                    }
                }
                case CLOSE_CONSUMER: {
                    Preconditions.checkArgument((boolean)cmd.hasCloseConsumer());
                    this.handleCloseConsumer(cmd.getCloseConsumer());
                    cmd.getCloseConsumer().recycle();
                    return;
                }
                case CLOSE_PRODUCER: {
                    Preconditions.checkArgument((boolean)cmd.hasCloseProducer());
                    this.handleCloseProducer(cmd.getCloseProducer());
                    cmd.getCloseProducer().recycle();
                    return;
                }
                case CONNECT: {
                    Preconditions.checkArgument((boolean)cmd.hasConnect());
                    this.handleConnect(cmd.getConnect());
                    cmd.getConnect().recycle();
                    return;
                }
                case CONNECTED: {
                    Preconditions.checkArgument((boolean)cmd.hasConnected());
                    this.handleConnected(cmd.getConnected());
                    cmd.getConnected().recycle();
                    return;
                }
                case ERROR: {
                    Preconditions.checkArgument((boolean)cmd.hasError());
                    this.handleError(cmd.getError());
                    cmd.getError().recycle();
                    return;
                }
                case FLOW: {
                    Preconditions.checkArgument((boolean)cmd.hasFlow());
                    this.handleFlow(cmd.getFlow());
                    cmd.getFlow().recycle();
                    return;
                }
                case MESSAGE: {
                    Preconditions.checkArgument((boolean)cmd.hasMessage());
                    this.handleMessage(cmd.getMessage(), buffer);
                    cmd.getMessage().recycle();
                    return;
                }
                case PRODUCER: {
                    Preconditions.checkArgument((boolean)cmd.hasProducer());
                    this.handleProducer(cmd.getProducer());
                    cmd.getProducer().recycle();
                    return;
                }
                case SEND: {
                    Preconditions.checkArgument((boolean)cmd.hasSend());
                    ByteBuf headersAndPayload = buffer.markReaderIndex();
                    this.handleSend(cmd.getSend(), headersAndPayload);
                    cmd.getSend().recycle();
                    return;
                }
                case SEND_ERROR: {
                    Preconditions.checkArgument((boolean)cmd.hasSendError());
                    this.handleSendError(cmd.getSendError());
                    cmd.getSendError().recycle();
                    return;
                }
                case SEND_RECEIPT: {
                    Preconditions.checkArgument((boolean)cmd.hasSendReceipt());
                    this.handleSendReceipt(cmd.getSendReceipt());
                    cmd.getSendReceipt().recycle();
                    return;
                }
                case SUBSCRIBE: {
                    Preconditions.checkArgument((boolean)cmd.hasSubscribe());
                    this.handleSubscribe(cmd.getSubscribe());
                    cmd.getSubscribe().recycle();
                    return;
                }
                case SUCCESS: {
                    Preconditions.checkArgument((boolean)cmd.hasSuccess());
                    this.handleSuccess(cmd.getSuccess());
                    cmd.getSuccess().recycle();
                    return;
                }
                case PRODUCER_SUCCESS: {
                    Preconditions.checkArgument((boolean)cmd.hasProducerSuccess());
                    this.handleProducerSuccess(cmd.getProducerSuccess());
                    cmd.getProducerSuccess().recycle();
                    return;
                }
                case UNSUBSCRIBE: {
                    Preconditions.checkArgument((boolean)cmd.hasUnsubscribe());
                    this.handleUnsubscribe(cmd.getUnsubscribe());
                    cmd.getUnsubscribe().recycle();
                    return;
                }
                case SEEK: {
                    Preconditions.checkArgument((boolean)cmd.hasSeek());
                    this.handleSeek(cmd.getSeek());
                    cmd.getSeek().recycle();
                    return;
                }
                case PING: {
                    Preconditions.checkArgument((boolean)cmd.hasPing());
                    this.handlePing(cmd.getPing());
                    cmd.getPing().recycle();
                    return;
                }
                case PONG: {
                    Preconditions.checkArgument((boolean)cmd.hasPong());
                    this.handlePong(cmd.getPong());
                    cmd.getPong().recycle();
                    return;
                }
                case REDELIVER_UNACKNOWLEDGED_MESSAGES: {
                    Preconditions.checkArgument((boolean)cmd.hasRedeliverUnacknowledgedMessages());
                    this.handleRedeliverUnacknowledged(cmd.getRedeliverUnacknowledgedMessages());
                    cmd.getRedeliverUnacknowledgedMessages().recycle();
                    return;
                }
                case CONSUMER_STATS: {
                    Preconditions.checkArgument((boolean)cmd.hasConsumerStats());
                    this.handleConsumerStats(cmd.getConsumerStats());
                    cmd.getConsumerStats().recycle();
                    return;
                }
                case CONSUMER_STATS_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasConsumerStatsResponse());
                    this.handleConsumerStatsResponse(cmd.getConsumerStatsResponse());
                    cmd.getConsumerStatsResponse().recycle();
                    return;
                }
                case REACHED_END_OF_TOPIC: {
                    Preconditions.checkArgument((boolean)cmd.hasReachedEndOfTopic());
                    this.handleReachedEndOfTopic(cmd.getReachedEndOfTopic());
                    cmd.getReachedEndOfTopic().recycle();
                    return;
                }
                case GET_LAST_MESSAGE_ID: {
                    Preconditions.checkArgument((boolean)cmd.hasGetLastMessageId());
                    this.handleGetLastMessageId(cmd.getGetLastMessageId());
                    cmd.getGetLastMessageId().recycle();
                    return;
                }
                case GET_LAST_MESSAGE_ID_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetLastMessageIdResponse());
                    this.handleGetLastMessageIdSuccess(cmd.getGetLastMessageIdResponse());
                    cmd.getGetLastMessageIdResponse().recycle();
                    return;
                }
                case ACTIVE_CONSUMER_CHANGE: {
                    this.handleActiveConsumerChange(cmd.getActiveConsumerChange());
                    cmd.getActiveConsumerChange().recycle();
                    return;
                }
                case GET_TOPICS_OF_NAMESPACE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetTopicsOfNamespace());
                    this.handleGetTopicsOfNamespace(cmd.getGetTopicsOfNamespace());
                    cmd.getGetTopicsOfNamespace().recycle();
                    return;
                }
                case GET_TOPICS_OF_NAMESPACE_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetTopicsOfNamespaceResponse());
                    this.handleGetTopicsOfNamespaceSuccess(cmd.getGetTopicsOfNamespaceResponse());
                    cmd.getGetTopicsOfNamespaceResponse().recycle();
                    return;
                }
                case GET_SCHEMA: {
                    Preconditions.checkArgument((boolean)cmd.hasGetSchema());
                    this.handleGetSchema(cmd.getGetSchema());
                    cmd.getGetSchema().recycle();
                    return;
                }
                case GET_SCHEMA_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetSchemaResponse());
                    this.handleGetSchemaResponse(cmd.getGetSchemaResponse());
                    cmd.getGetSchemaResponse().recycle();
                    return;
                }
                case AUTH_CHALLENGE: {
                    Preconditions.checkArgument((boolean)cmd.hasAuthChallenge());
                    this.handleAuthChallenge(cmd.getAuthChallenge());
                    cmd.getAuthChallenge().recycle();
                    return;
                }
                case AUTH_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasAuthResponse());
                    this.handleAuthResponse(cmd.getAuthResponse());
                    cmd.getAuthResponse().recycle();
                    return;
                }
            }
            return;
        }
        finally {
            if (cmdBuilder != null) {
                cmdBuilder.recycle();
            }
            if (cmd != null) {
                cmd.recycle();
            }
            buffer.release();
        }
    }

    protected abstract void messageReceived();

    protected void handlePartitionMetadataRequest(PulsarApi.CommandPartitionedTopicMetadata response) {
        throw new UnsupportedOperationException();
    }

    protected void handlePartitionResponse(PulsarApi.CommandPartitionedTopicMetadataResponse response) {
        throw new UnsupportedOperationException();
    }

    protected void handleLookup(PulsarApi.CommandLookupTopic lookup) {
        throw new UnsupportedOperationException();
    }

    protected void handleLookupResponse(PulsarApi.CommandLookupTopicResponse connection) {
        throw new UnsupportedOperationException();
    }

    protected void handleConnect(PulsarApi.CommandConnect connect) {
        throw new UnsupportedOperationException();
    }

    protected void handleConnected(PulsarApi.CommandConnected connected) {
        throw new UnsupportedOperationException();
    }

    protected void handleSubscribe(PulsarApi.CommandSubscribe subscribe) {
        throw new UnsupportedOperationException();
    }

    protected void handleProducer(PulsarApi.CommandProducer producer) {
        throw new UnsupportedOperationException();
    }

    protected void handleSend(PulsarApi.CommandSend send, ByteBuf headersAndPayload) {
        throw new UnsupportedOperationException();
    }

    protected void handleSendReceipt(PulsarApi.CommandSendReceipt sendReceipt) {
        throw new UnsupportedOperationException();
    }

    protected void handleSendError(PulsarApi.CommandSendError sendError) {
        throw new UnsupportedOperationException();
    }

    protected void handleMessage(PulsarApi.CommandMessage cmdMessage, ByteBuf headersAndPayload) {
        throw new UnsupportedOperationException();
    }

    protected void handleAck(PulsarApi.CommandAck ack) {
        throw new UnsupportedOperationException();
    }

    protected void handleFlow(PulsarApi.CommandFlow flow) {
        throw new UnsupportedOperationException();
    }

    protected void handleRedeliverUnacknowledged(PulsarApi.CommandRedeliverUnacknowledgedMessages redeliver) {
        throw new UnsupportedOperationException();
    }

    protected void handleUnsubscribe(PulsarApi.CommandUnsubscribe unsubscribe) {
        throw new UnsupportedOperationException();
    }

    protected void handleSeek(PulsarApi.CommandSeek seek) {
        throw new UnsupportedOperationException();
    }

    protected void handleActiveConsumerChange(PulsarApi.CommandActiveConsumerChange change) {
        throw new UnsupportedOperationException();
    }

    protected void handleSuccess(PulsarApi.CommandSuccess success) {
        throw new UnsupportedOperationException();
    }

    protected void handleProducerSuccess(PulsarApi.CommandProducerSuccess success) {
        throw new UnsupportedOperationException();
    }

    protected void handleError(PulsarApi.CommandError error) {
        throw new UnsupportedOperationException();
    }

    protected void handleCloseProducer(PulsarApi.CommandCloseProducer closeProducer) {
        throw new UnsupportedOperationException();
    }

    protected void handleCloseConsumer(PulsarApi.CommandCloseConsumer closeConsumer) {
        throw new UnsupportedOperationException();
    }

    protected void handlePing(PulsarApi.CommandPing ping) {
        throw new UnsupportedOperationException();
    }

    protected void handlePong(PulsarApi.CommandPong pong) {
        throw new UnsupportedOperationException();
    }

    protected void handleConsumerStats(PulsarApi.CommandConsumerStats commandConsumerStats) {
        throw new UnsupportedOperationException();
    }

    protected void handleConsumerStatsResponse(PulsarApi.CommandConsumerStatsResponse commandConsumerStatsResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleReachedEndOfTopic(PulsarApi.CommandReachedEndOfTopic commandReachedEndOfTopic) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetLastMessageId(PulsarApi.CommandGetLastMessageId getLastMessageId) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetLastMessageIdSuccess(PulsarApi.CommandGetLastMessageIdResponse success) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetTopicsOfNamespace(PulsarApi.CommandGetTopicsOfNamespace commandGetTopicsOfNamespace) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetTopicsOfNamespaceSuccess(PulsarApi.CommandGetTopicsOfNamespaceResponse response) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetSchema(PulsarApi.CommandGetSchema commandGetSchema) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetSchemaResponse(PulsarApi.CommandGetSchemaResponse commandGetSchemaResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAuthResponse(PulsarApi.CommandAuthResponse commandAuthResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAuthChallenge(PulsarApi.CommandAuthChallenge commandAuthChallenge) {
        throw new UnsupportedOperationException();
    }
}

