/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.pulsar.common.policies.data.ExceptionInformation;
import org.apache.pulsar.common.util.ObjectMapperFactory;

public class FunctionStatus {
    public int numInstances;
    public int numRunning;
    public List<FunctionInstanceStatus> instances = new LinkedList<FunctionInstanceStatus>();

    public void addInstance(FunctionInstanceStatus functionInstanceStatus) {
        this.instances.add(functionInstanceStatus);
    }

    public static FunctionStatus decode(String json) throws IOException {
        return (FunctionStatus)ObjectMapperFactory.getThreadLocal().readValue(json, FunctionStatus.class);
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public int getNumRunning() {
        return this.numRunning;
    }

    public List<FunctionInstanceStatus> getInstances() {
        return this.instances;
    }

    public void setNumInstances(int numInstances) {
        this.numInstances = numInstances;
    }

    public void setNumRunning(int numRunning) {
        this.numRunning = numRunning;
    }

    public void setInstances(List<FunctionInstanceStatus> instances) {
        this.instances = instances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionStatus)) {
            return false;
        }
        FunctionStatus other = (FunctionStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumInstances() != other.getNumInstances()) {
            return false;
        }
        if (this.getNumRunning() != other.getNumRunning()) {
            return false;
        }
        List<FunctionInstanceStatus> this$instances = this.getInstances();
        List<FunctionInstanceStatus> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumInstances();
        result = result * 59 + this.getNumRunning();
        List<FunctionInstanceStatus> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        return result;
    }

    public String toString() {
        return "FunctionStatus(numInstances=" + this.getNumInstances() + ", numRunning=" + this.getNumRunning() + ", instances=" + this.getInstances() + ")";
    }

    public static class FunctionInstanceStatus {
        public int instanceId;
        public FunctionInstanceStatusData status;

        public int getInstanceId() {
            return this.instanceId;
        }

        public FunctionInstanceStatusData getStatus() {
            return this.status;
        }

        public void setInstanceId(int instanceId) {
            this.instanceId = instanceId;
        }

        public void setStatus(FunctionInstanceStatusData status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionInstanceStatus)) {
                return false;
            }
            FunctionInstanceStatus other = (FunctionInstanceStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getInstanceId() != other.getInstanceId()) {
                return false;
            }
            FunctionInstanceStatusData this$status = this.getStatus();
            FunctionInstanceStatusData other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionInstanceStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getInstanceId();
            FunctionInstanceStatusData $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionStatus.FunctionInstanceStatus(instanceId=" + this.getInstanceId() + ", status=" + this.getStatus() + ")";
        }

        public static class FunctionInstanceStatusData {
            public boolean running;
            public String error;
            public long numRestarts;
            public long numReceived;
            public long numSuccessfullyProcessed;
            public long numUserExceptions;
            public List<ExceptionInformation> latestUserExceptions;
            public long numSystemExceptions;
            public List<ExceptionInformation> latestSystemExceptions;
            public double averageLatency;
            public long lastInvocationTime;
            public String workerId;

            public boolean isRunning() {
                return this.running;
            }

            public String getError() {
                return this.error;
            }

            public long getNumRestarts() {
                return this.numRestarts;
            }

            public long getNumReceived() {
                return this.numReceived;
            }

            public long getNumSuccessfullyProcessed() {
                return this.numSuccessfullyProcessed;
            }

            public long getNumUserExceptions() {
                return this.numUserExceptions;
            }

            public List<ExceptionInformation> getLatestUserExceptions() {
                return this.latestUserExceptions;
            }

            public long getNumSystemExceptions() {
                return this.numSystemExceptions;
            }

            public List<ExceptionInformation> getLatestSystemExceptions() {
                return this.latestSystemExceptions;
            }

            public double getAverageLatency() {
                return this.averageLatency;
            }

            public long getLastInvocationTime() {
                return this.lastInvocationTime;
            }

            public String getWorkerId() {
                return this.workerId;
            }

            public void setRunning(boolean running) {
                this.running = running;
            }

            public void setError(String error) {
                this.error = error;
            }

            public void setNumRestarts(long numRestarts) {
                this.numRestarts = numRestarts;
            }

            public void setNumReceived(long numReceived) {
                this.numReceived = numReceived;
            }

            public void setNumSuccessfullyProcessed(long numSuccessfullyProcessed) {
                this.numSuccessfullyProcessed = numSuccessfullyProcessed;
            }

            public void setNumUserExceptions(long numUserExceptions) {
                this.numUserExceptions = numUserExceptions;
            }

            public void setLatestUserExceptions(List<ExceptionInformation> latestUserExceptions) {
                this.latestUserExceptions = latestUserExceptions;
            }

            public void setNumSystemExceptions(long numSystemExceptions) {
                this.numSystemExceptions = numSystemExceptions;
            }

            public void setLatestSystemExceptions(List<ExceptionInformation> latestSystemExceptions) {
                this.latestSystemExceptions = latestSystemExceptions;
            }

            public void setAverageLatency(double averageLatency) {
                this.averageLatency = averageLatency;
            }

            public void setLastInvocationTime(long lastInvocationTime) {
                this.lastInvocationTime = lastInvocationTime;
            }

            public void setWorkerId(String workerId) {
                this.workerId = workerId;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FunctionInstanceStatusData)) {
                    return false;
                }
                FunctionInstanceStatusData other = (FunctionInstanceStatusData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isRunning() != other.isRunning()) {
                    return false;
                }
                if (this.getNumRestarts() != other.getNumRestarts()) {
                    return false;
                }
                if (this.getNumReceived() != other.getNumReceived()) {
                    return false;
                }
                if (this.getNumSuccessfullyProcessed() != other.getNumSuccessfullyProcessed()) {
                    return false;
                }
                if (this.getNumUserExceptions() != other.getNumUserExceptions()) {
                    return false;
                }
                if (this.getNumSystemExceptions() != other.getNumSystemExceptions()) {
                    return false;
                }
                if (Double.compare(this.getAverageLatency(), other.getAverageLatency()) != 0) {
                    return false;
                }
                if (this.getLastInvocationTime() != other.getLastInvocationTime()) {
                    return false;
                }
                String this$error = this.getError();
                String other$error = other.getError();
                if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                    return false;
                }
                List<ExceptionInformation> this$latestUserExceptions = this.getLatestUserExceptions();
                List<ExceptionInformation> other$latestUserExceptions = other.getLatestUserExceptions();
                if (this$latestUserExceptions == null ? other$latestUserExceptions != null : !((Object)this$latestUserExceptions).equals(other$latestUserExceptions)) {
                    return false;
                }
                List<ExceptionInformation> this$latestSystemExceptions = this.getLatestSystemExceptions();
                List<ExceptionInformation> other$latestSystemExceptions = other.getLatestSystemExceptions();
                if (this$latestSystemExceptions == null ? other$latestSystemExceptions != null : !((Object)this$latestSystemExceptions).equals(other$latestSystemExceptions)) {
                    return false;
                }
                String this$workerId = this.getWorkerId();
                String other$workerId = other.getWorkerId();
                return !(this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof FunctionInstanceStatusData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isRunning() ? 79 : 97);
                long $numRestarts = this.getNumRestarts();
                result = result * 59 + (int)($numRestarts >>> 32 ^ $numRestarts);
                long $numReceived = this.getNumReceived();
                result = result * 59 + (int)($numReceived >>> 32 ^ $numReceived);
                long $numSuccessfullyProcessed = this.getNumSuccessfullyProcessed();
                result = result * 59 + (int)($numSuccessfullyProcessed >>> 32 ^ $numSuccessfullyProcessed);
                long $numUserExceptions = this.getNumUserExceptions();
                result = result * 59 + (int)($numUserExceptions >>> 32 ^ $numUserExceptions);
                long $numSystemExceptions = this.getNumSystemExceptions();
                result = result * 59 + (int)($numSystemExceptions >>> 32 ^ $numSystemExceptions);
                long $averageLatency = Double.doubleToLongBits(this.getAverageLatency());
                result = result * 59 + (int)($averageLatency >>> 32 ^ $averageLatency);
                long $lastInvocationTime = this.getLastInvocationTime();
                result = result * 59 + (int)($lastInvocationTime >>> 32 ^ $lastInvocationTime);
                String $error = this.getError();
                result = result * 59 + ($error == null ? 43 : $error.hashCode());
                List<ExceptionInformation> $latestUserExceptions = this.getLatestUserExceptions();
                result = result * 59 + ($latestUserExceptions == null ? 43 : ((Object)$latestUserExceptions).hashCode());
                List<ExceptionInformation> $latestSystemExceptions = this.getLatestSystemExceptions();
                result = result * 59 + ($latestSystemExceptions == null ? 43 : ((Object)$latestSystemExceptions).hashCode());
                String $workerId = this.getWorkerId();
                result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
                return result;
            }

            public String toString() {
                return "FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData(running=" + this.isRunning() + ", error=" + this.getError() + ", numRestarts=" + this.getNumRestarts() + ", numReceived=" + this.getNumReceived() + ", numSuccessfullyProcessed=" + this.getNumSuccessfullyProcessed() + ", numUserExceptions=" + this.getNumUserExceptions() + ", latestUserExceptions=" + this.getLatestUserExceptions() + ", numSystemExceptions=" + this.getNumSystemExceptions() + ", latestSystemExceptions=" + this.getLatestSystemExceptions() + ", averageLatency=" + this.getAverageLatency() + ", lastInvocationTime=" + this.getLastInvocationTime() + ", workerId=" + this.getWorkerId() + ")";
            }
        }
    }
}

