/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.MarkerType;
import org.apache.pulsar.common.api.proto.MarkersMessageIdData;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsSnapshot;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsSnapshotRequest;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsSnapshotResponse;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsUpdate;
import org.apache.pulsar.common.protocol.Commands;

public final class Markers {
    private static final FastThreadLocal<MessageMetadata> LOCAL_MESSAGE_METADATA = new FastThreadLocal<MessageMetadata>(){

        protected MessageMetadata initialValue() throws Exception {
            return new MessageMetadata();
        }
    };
    private static final FastThreadLocal<ReplicatedSubscriptionsSnapshotRequest> LOCAL_SNAPSHOT_REQUEST = new FastThreadLocal<ReplicatedSubscriptionsSnapshotRequest>(){

        protected ReplicatedSubscriptionsSnapshotRequest initialValue() throws Exception {
            return new ReplicatedSubscriptionsSnapshotRequest();
        }
    };
    private static final FastThreadLocal<ReplicatedSubscriptionsSnapshotResponse> LOCAL_SNAPSHOT_RESPONSE = new FastThreadLocal<ReplicatedSubscriptionsSnapshotResponse>(){

        protected ReplicatedSubscriptionsSnapshotResponse initialValue() throws Exception {
            return new ReplicatedSubscriptionsSnapshotResponse();
        }
    };
    private static final FastThreadLocal<ReplicatedSubscriptionsSnapshot> LOCAL_SNAPSHOT = new FastThreadLocal<ReplicatedSubscriptionsSnapshot>(){

        protected ReplicatedSubscriptionsSnapshot initialValue() throws Exception {
            return new ReplicatedSubscriptionsSnapshot();
        }
    };
    private static final FastThreadLocal<ReplicatedSubscriptionsUpdate> LOCAL_SUBSCRIPTION_UPDATE = new FastThreadLocal<ReplicatedSubscriptionsUpdate>(){

        protected ReplicatedSubscriptionsUpdate initialValue() throws Exception {
            return new ReplicatedSubscriptionsUpdate();
        }
    };

    private static ByteBuf newMessage(MarkerType markerType, Optional<String> restrictToCluster, ByteBuf payload) {
        MessageMetadata msgMetadata = ((MessageMetadata)LOCAL_MESSAGE_METADATA.get()).clear().setPublishTime(System.currentTimeMillis()).setProducerName("pulsar.marker").setSequenceId(0L).setMarkerType(markerType.getValue());
        restrictToCluster.ifPresent(msgMetadata::addReplicateTo);
        return Commands.serializeMetadataAndPayload(Commands.ChecksumType.Crc32c, msgMetadata, payload);
    }

    public static boolean isServerOnlyMarker(MessageMetadata msgMetadata) {
        return msgMetadata.hasMarkerType();
    }

    public static boolean isReplicatedSubscriptionSnapshotMarker(MessageMetadata msgMetadata) {
        return msgMetadata != null && msgMetadata.hasMarkerType() && msgMetadata.getMarkerType() == MarkerType.REPLICATED_SUBSCRIPTION_SNAPSHOT.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsSnapshotRequest(String snapshotId, String sourceCluster) {
        ReplicatedSubscriptionsSnapshotRequest req = ((ReplicatedSubscriptionsSnapshotRequest)LOCAL_SNAPSHOT_REQUEST.get()).clear().setSnapshotId(snapshotId).setSourceCluster(sourceCluster);
        ByteBuf payload = PulsarByteBufAllocator.DEFAULT.buffer(req.getSerializedSize());
        try {
            req.writeTo(payload);
            ByteBuf byteBuf = Markers.newMessage(MarkerType.REPLICATED_SUBSCRIPTION_SNAPSHOT_REQUEST, Optional.empty(), payload);
            return byteBuf;
        }
        finally {
            payload.release();
        }
    }

    public static ReplicatedSubscriptionsSnapshotRequest parseReplicatedSubscriptionsSnapshotRequest(ByteBuf payload) throws IOException {
        ReplicatedSubscriptionsSnapshotRequest req = (ReplicatedSubscriptionsSnapshotRequest)LOCAL_SNAPSHOT_REQUEST.get();
        req.parseFrom(payload, payload.readableBytes());
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsSnapshotResponse(String snapshotId, String replyToCluster, String cluster, long ledgerId, long entryId) {
        ReplicatedSubscriptionsSnapshotResponse response = ((ReplicatedSubscriptionsSnapshotResponse)LOCAL_SNAPSHOT_RESPONSE.get()).clear().setSnapshotId(snapshotId);
        response.setCluster().setCluster(cluster).setMessageId().setLedgerId(ledgerId).setEntryId(entryId);
        ByteBuf payload = PulsarByteBufAllocator.DEFAULT.buffer(response.getSerializedSize());
        try {
            response.writeTo(payload);
            ByteBuf byteBuf = Markers.newMessage(MarkerType.REPLICATED_SUBSCRIPTION_SNAPSHOT_RESPONSE, Optional.of(replyToCluster), payload);
            return byteBuf;
        }
        finally {
            payload.release();
        }
    }

    public static ReplicatedSubscriptionsSnapshotResponse parseReplicatedSubscriptionsSnapshotResponse(ByteBuf payload) throws IOException {
        ReplicatedSubscriptionsSnapshotResponse response = (ReplicatedSubscriptionsSnapshotResponse)LOCAL_SNAPSHOT_RESPONSE.get();
        response.parseFrom(payload, payload.readableBytes());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsSnapshot(String snapshotId, String sourceCluster, long ledgerId, long entryId, Map<String, MarkersMessageIdData> clusterIds) {
        ByteBuf byteBuf;
        ReplicatedSubscriptionsSnapshot snapshot = ((ReplicatedSubscriptionsSnapshot)LOCAL_SNAPSHOT.get()).clear().setSnapshotId(snapshotId);
        snapshot.setLocalMessageId().setLedgerId(ledgerId).setEntryId(entryId);
        clusterIds.forEach((cluster, msgId) -> snapshot.addCluster().setCluster((String)cluster).setMessageId().copyFrom((MarkersMessageIdData)msgId));
        int size = snapshot.getSerializedSize();
        ByteBuf payload = PulsarByteBufAllocator.DEFAULT.buffer(size);
        try {
            snapshot.writeTo(payload);
            byteBuf = Markers.newMessage(MarkerType.REPLICATED_SUBSCRIPTION_SNAPSHOT, Optional.of(sourceCluster), payload);
        }
        catch (Throwable throwable) {
            payload.release();
            throw throwable;
        }
        payload.release();
        return byteBuf;
    }

    public static ReplicatedSubscriptionsSnapshot parseReplicatedSubscriptionsSnapshot(ByteBuf payload) throws IOException {
        ReplicatedSubscriptionsSnapshot snapshot = (ReplicatedSubscriptionsSnapshot)LOCAL_SNAPSHOT.get();
        snapshot.parseFrom(payload, payload.readableBytes());
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf newReplicatedSubscriptionsUpdate(String subscriptionName, Map<String, MarkersMessageIdData> clusterIds) {
        ByteBuf byteBuf;
        ReplicatedSubscriptionsUpdate update = ((ReplicatedSubscriptionsUpdate)LOCAL_SUBSCRIPTION_UPDATE.get()).clear().setSubscriptionName(subscriptionName);
        clusterIds.forEach((cluster, msgId) -> update.addCluster().setCluster((String)cluster).setMessageId().copyFrom((MarkersMessageIdData)msgId));
        ByteBuf payload = PulsarByteBufAllocator.DEFAULT.buffer(update.getSerializedSize());
        try {
            update.writeTo(payload);
            byteBuf = Markers.newMessage(MarkerType.REPLICATED_SUBSCRIPTION_UPDATE, Optional.empty(), payload);
        }
        catch (Throwable throwable) {
            payload.release();
            throw throwable;
        }
        payload.release();
        return byteBuf;
    }

    public static ReplicatedSubscriptionsUpdate parseReplicatedSubscriptionsUpdate(ByteBuf payload) {
        ReplicatedSubscriptionsUpdate update = (ReplicatedSubscriptionsUpdate)LOCAL_SUBSCRIPTION_UPDATE.get();
        update.parseFrom(payload, payload.readableBytes());
        return update;
    }

    public static boolean isTxnCommitMarker(MessageMetadata msgMetadata) {
        return msgMetadata != null && msgMetadata.hasMarkerType() && msgMetadata.getMarkerType() == MarkerType.TXN_COMMIT.getValue();
    }

    public static boolean isTxnMarker(MessageMetadata msgMetadata) {
        return msgMetadata != null && msgMetadata.hasMarkerType() && (msgMetadata.getMarkerType() == MarkerType.TXN_COMMIT.getValue() || msgMetadata.getMarkerType() == MarkerType.TXN_ABORT.getValue());
    }

    public static ByteBuf newTxnCommitMarker(long sequenceId, long txnMostBits, long txnLeastBits) {
        return Markers.newTxnMarker(MarkerType.TXN_COMMIT, sequenceId, txnMostBits, txnLeastBits);
    }

    public static boolean isTxnAbortMarker(MessageMetadata msgMetadata) {
        return msgMetadata != null && msgMetadata.hasMarkerType() && msgMetadata.getMarkerType() == MarkerType.TXN_ABORT.getValue();
    }

    public static ByteBuf newTxnAbortMarker(long sequenceId, long txnMostBits, long txnLeastBits) {
        return Markers.newTxnMarker(MarkerType.TXN_ABORT, sequenceId, txnMostBits, txnLeastBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf newTxnMarker(MarkerType markerType, long sequenceId, long txnMostBits, long txnLeastBits) {
        MessageMetadata msgMetadata = ((MessageMetadata)LOCAL_MESSAGE_METADATA.get()).clear().setPublishTime(System.currentTimeMillis()).setProducerName("pulsar.txn.marker").setSequenceId(sequenceId).setMarkerType(markerType.getValue()).setTxnidMostBits(txnMostBits).setTxnidLeastBits(txnLeastBits);
        ByteBuf payload = PulsarByteBufAllocator.DEFAULT.buffer(0);
        try {
            ByteBuf byteBuf = Commands.serializeMetadataAndPayload(Commands.ChecksumType.Crc32c, msgMetadata, payload);
            return byteBuf;
        }
        finally {
            payload.release();
        }
    }

    private Markers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

